/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.metadata.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Strings;
import mulesoft.field.ModelField;
import mulesoft.field.TypeField;
import mulesoft.metadata.entity.Attribute;
import mulesoft.metadata.entity.AttributeBuilder;
import mulesoft.metadata.entity.DbObject;
import mulesoft.metadata.entity.DbObjectBuilder;
import mulesoft.metadata.entity.Entity;
import mulesoft.metadata.entity.SearchField;
import mulesoft.metadata.entity.View;
import mulesoft.metadata.entity.ViewAttribute;
import mulesoft.metadata.entity.ViewAttributeBuilder;
import mulesoft.metadata.exception.BuilderError;
import mulesoft.metadata.exception.BuilderException;
import mulesoft.metadata.exception.DuplicateFieldException;
import mulesoft.metadata.exception.NoAttributesException;
import mulesoft.metadata.exception.RemoteViewOfNonRemotableException;
import mulesoft.metadata.exception.RemoteViewWithAsException;
import mulesoft.metadata.exception.ViewWithIndexesException;
import mulesoft.type.FieldReference;
import mulesoft.type.MetaModel;
import mulesoft.type.Modifier;
import mulesoft.type.Type;
import mulesoft.type.Types;
import org.jetbrains.annotations.NotNull;

public class ViewBuilder
extends DbObjectBuilder<View, ViewAttribute, AttributeBuilder, ViewBuilder> {
    private String asQuery = "";
    private Integer batchSize = null;
    @NotNull
    private final List<ModelField> describeFields = new ArrayList<ModelField>();
    @NotNull
    private final List<MetaModel> entities;
    private List<ModelField> image;
    @NotNull
    private final List<ModelField> searchFields = new ArrayList<ModelField>();
    private boolean updatable = false;

    public ViewBuilder(String sourceName, @NotNull String pkg, @NotNull String name, @NotNull String defaultSchemaId) {
        super(sourceName, pkg, name, defaultSchemaId);
        this.entities = new ArrayList<MetaModel>();
        this.image = new ArrayList<ModelField>();
    }

    public ViewBuilder as(String query) {
        this.asQuery = query;
        return this;
    }

    public ViewBuilder batchSize(int size) {
        this.batchSize = size;
        return this;
    }

    @Override
    public View build() throws BuilderException {
        LinkedHashMap<String, TypeField> fieldsByAttributeName = new LinkedHashMap<String, TypeField>();
        Map attributeMap = (Map)Predefined.cast(fieldsByAttributeName);
        ArrayList<ModelField> describes = new ArrayList<ModelField>();
        ArrayList<Attribute> primaryKey = new ArrayList<Attribute>();
        ArrayList<SearchField> searchBy = new ArrayList<SearchField>();
        LinkedHashMap<String, Seq<Attribute>> uniqueMap = new LinkedHashMap<String, Seq<Attribute>>();
        HashMap<String, Seq<Attribute>> indexMap = new HashMap<String, Seq<Attribute>>();
        boolean remote = this.modifiers.contains(Modifier.REMOTE);
        View view = new View(this.sourceName, this.domain, this.id, this.label, this.modifiers, this.getDatabaseName(), this.dbNameGenerated, attributeMap, describes, this.updatable, searchBy, uniqueMap, indexMap, this.asQuery, primaryKey, this.entities, this.image, this.documentation, this.batchSize);
        this.addInternalFields(remote);
        this.buildAttributes(fieldsByAttributeName, (MetaModel)view);
        this.addFieldsByName(attributeMap, this.searchFields, describes);
        this.addAllFields(attributeMap, this.describeFields, describes);
        this.buildIndexes(this.uniqueIndexes, attributeMap, uniqueMap);
        this.buildIndexes(this.indexes, attributeMap, indexMap);
        this.buildPrimaryKey(this.primaryKeyFields, attributeMap, primaryKey);
        this.buildSearchByFields(this.searchByFields, attributeMap, searchBy, false);
        return view;
    }

    @Override
    @NotNull
    public List<BuilderError> check() {
        boolean remote;
        if (Predefined.isEmpty(this.fields.entrySet())) {
            this.builderErrors.add(new NoAttributesException(this.id));
        }
        if (remote = this.modifiers.contains(Modifier.REMOTE)) {
            if (!Predefined.isEmpty((String)this.asQuery)) {
                this.builderErrors.add(new RemoteViewWithAsException(this.id));
            }
            this.checkEntities();
        }
        if (!(this.uniqueIndexes.isEmpty() && this.indexes.isEmpty() || remote)) {
            this.builderErrors.add(new ViewWithIndexesException(this.id));
        }
        return this.builderErrors;
    }

    public ViewBuilder describedBy(Collection<ModelField> mf) {
        this.describeFields.clear();
        this.describeFields.addAll(mf);
        return this;
    }

    public ViewBuilder describedBy(String ... fs) {
        return this.describedBy(this.convertToModelFields(fs));
    }

    public ViewBuilder image(ModelField img) {
        this.image = new ArrayList<ModelField>();
        this.image.add(img);
        return this;
    }

    public ViewBuilder optimistic() {
        return (ViewBuilder)this.withModifier(Modifier.OPTIMISTIC_LOCKING);
    }

    public ViewBuilder updatable() {
        this.updatable = true;
        return this;
    }

    public ViewBuilder withEntities(List<MetaModel> models) {
        this.entities.addAll(models);
        return this;
    }

    @Override
    protected void checkDuplicates(AttributeBuilder a) throws DuplicateFieldException {
        for (AttributeBuilder builder : this.fields.values()) {
            if (!(builder instanceof ViewAttributeBuilder) || !((ViewAttributeBuilder)builder).getBaseAttribute().getName().equals(a.getName())) continue;
            throw DuplicateFieldException.onEntity(a.getName(), this.id);
        }
        super.checkDuplicates(a);
    }

    private void addInternalFields(boolean remote) {
        try {
            if (remote || this.updatable) {
                this.addInternalField(this.createAttribute("updateTime", (Type)Types.dateTimeType((int)3)).synthesized());
            }
            if (this.updatable && this.hasModifier(Modifier.OPTIMISTIC_LOCKING) && !remote) {
                this.addInternalField(this.createAttribute("instanceVersion", (Type)Types.longType()).synthesized());
            }
            if (remote) {
                MetaModel entity;
                MetaModel metaModel = entity = this.entities.isEmpty() ? null : this.entities.get(0);
                if (entity != null) {
                    if (entity.isInner()) {
                        String name = ((Entity)((Entity)entity).getParent().get()).getName();
                        String parentFieldName = Strings.deCapitalizeFirst((String)name);
                        this.addField(new ViewAttributeBuilder(parentFieldName, (ModelField)FieldReference.unresolvedFieldRef((String)parentFieldName)));
                    }
                    if (entity instanceof Entity && ((Entity)entity).isDeprecable()) {
                        this.addInternalField(this.createAttribute("deprecationTime", (Type)Types.dateTimeType((int)3)).synthesized().optional());
                    }
                }
            }
        }
        catch (BuilderException e) {
            this.builderErrors.add(e);
        }
    }

    private void buildPrimaryKey(List<ModelField> pks, Map<String, Attribute> attributeMap, List<Attribute> primaryKey) {
        this.addFieldsByName(attributeMap, pks, primaryKey);
    }

    private void checkEntities() {
        DbObject dbObject;
        MetaModel metaModel;
        if (!this.entities.isEmpty() && (metaModel = this.entities.get(0)) instanceof DbObject && !(dbObject = (DbObject)metaModel).isRemotable() && !dbObject.isSearchable()) {
            this.builderErrors.add(new RemoteViewOfNonRemotableException(this.id, metaModel.getFullName()));
        }
    }

    private AttributeBuilder createAttribute(String name, Type type) {
        return new AttributeBuilder(name, type);
    }
}

