/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.metadata.exception;

import java.util.Arrays;
import mulesoft.common.collections.Colls;
import mulesoft.metadata.exception.BuilderError;
import mulesoft.type.MetaModel;
import mulesoft.type.Type;
import mulesoft.type.exception.ReverseReferenceException;
import mulesoft.type.permission.PredefinedPermission;

public class BuilderErrors {
    private static final String EMPTY_DOMAIN = "Empty domain name for : '%s'";
    private static final String INVALID_OPTION = "Invalid option: '%s'";

    private BuilderErrors() {
    }

    public static BuilderError addingPredefinedPermissionError(String permissionName) {
        return new AddingPredefinedPermissionError(permissionName);
    }

    public static BuilderError cannotResolveSymbol(String ref) {
        return new CannotResolveSymbol(ref);
    }

    public static BuilderError createError(String msg, String modelName) {
        return new Default(msg, modelName);
    }

    public static IllegalArgument createIllegalArgument(String widgetName, String value, int n) {
        return new IllegalArgument(widgetName, value, n);
    }

    public static IllegalWidgetType createIllegalWidgetTypeError(String nodeName) {
        return new IllegalWidgetType(nodeName);
    }

    public static IllegalWidgetTypeOption createIllegalWidgetTypeOptionError(String nodeName) {
        return new IllegalWidgetTypeOption(nodeName);
    }

    public static BuilderError duplicateReverseReference(String attributeName) {
        return BuilderErrors.createError(ReverseReferenceException.message((String)attributeName, (boolean)true), attributeName);
    }

    public static BuilderError emptyAggregates(String name) {
        return BuilderErrors.createError("At least one aggregate must be defined on %s.", name);
    }

    public static BuilderError emptyDomain(String nodeName) {
        return new Default(EMPTY_DOMAIN, nodeName);
    }

    public static BuilderError emptyList(String name) {
        return BuilderErrors.createError("%s must have at least 1 row", name);
    }

    public static BuilderError enumValueKeyIsTooLong(String id) {
        return new Default("Key is too long, has length of %s when max is 50", String.valueOf(id.length()));
    }

    public static BuilderError enumValueLabelIsTooLong(String label) {
        return new Default("Label is too long, has a length of %s when max is 128", String.valueOf(label.length()));
    }

    public static BuilderError extraEnumValue(String value, String modelName) {
        return new Default(String.format("Extra value  '%s' for Enum '%s'", value, modelName), modelName);
    }

    public static BuilderError illegalBindingType(String name, MetaModel type) {
        return new IllegalBindingType(name, type);
    }

    public static <T extends Enum<T>> IllegalEnumValue illegalEnumValue(Class<T> enumeration, String value) {
        return new IllegalEnumValue(enumeration.getSimpleName(), value);
    }

    public static IllegalUniqueAttribute illegalUniqueAttribute(String nodeName) {
        return new IllegalUniqueAttribute(nodeName);
    }

    public static BuilderError imageNotSupported(Type widget) {
        return BuilderErrors.createError("Image not supported for '%s'", widget.toString());
    }

    public static InvalidExpression invalidExpression(String errorDetail, String nodeName) {
        return new InvalidExpression(errorDetail, nodeName);
    }

    public static BuilderError invalidMenuItemFormParameter(String message, String link) {
        return BuilderErrors.createError(message, link);
    }

    public static BuilderError invalidMultipleType(String modelName) {
        return BuilderErrors.createError("Invalid type for multiple field '" + modelName + "'", modelName);
    }

    public static BuilderError invalidOption(String nodeName) {
        return new Default(INVALID_OPTION, nodeName);
    }

    public static BuilderError invalidTypeForParameter(String message, String modelName) {
        return BuilderErrors.createError(message, modelName);
    }

    public static BuilderError javaReservedWordModel(String modelName) {
        return new JavaReservedWordModel(modelName);
    }

    public static BuilderError listingFormWithChildWidgets(String modelName) {
        return BuilderErrors.createError("Using listing option with children", modelName);
    }

    public static BuilderError listNotSupported(String name) {
        return BuilderErrors.createError("List is not supported by widget %s", name);
    }

    public static BuilderError lowerCaseModel(String modelName) {
        return new LowerCaseModel(modelName);
    }

    public static BuilderError missingEnumValue(String modelName, String fieldName) {
        return new Default(String.format("Missing value for field '%s' in Enum '%s'", fieldName, modelName), modelName);
    }

    public static BuilderError parameterNotAConstant(String message, String modelName) {
        return BuilderErrors.createError(message, modelName);
    }

    public static BuilderError subFormNotDefinedError(String subFormName) {
        return new SubFormNotDefinedError(subFormName);
    }

    public static BuilderError undefinedAggregate(String name) {
        return BuilderErrors.createError("Aggregate function '%s' not defined.", name);
    }

    public static BuilderError undefinedMetaModelType(String modelName) {
        return BuilderErrors.createError("MetaModel Type '%s' is undefined", modelName);
    }

    public static BuilderError unexpectedType(String typeName) {
        return new Default("Unexpected type: '%s'", typeName);
    }

    public static UnresolvedField unresolvedField(String nodeName, String fullName) {
        return new UnresolvedField(nodeName, fullName);
    }

    public static BuilderError unresolvedFieldType(String nodeName) {
        return new UnresolvedFieldType(nodeName);
    }

    public static UnresolvedReference unresolvedReference(String nodeName) {
        return new UnresolvedReference(nodeName);
    }

    public static BuilderError unresolvedReverseReference(String attributeName) {
        return BuilderErrors.createError(ReverseReferenceException.message((String)attributeName, (boolean)false), attributeName);
    }

    public static UnresolvedSearchable unresolvedSearchableField(String nodeName) {
        return new UnresolvedSearchable(nodeName);
    }

    public static BuilderError unspecifiedType(String name) {
        return new Default("No type specified for '%s'.", name);
    }

    public static class UnresolvedSearchable
    extends Default {
        private UnresolvedSearchable(String nodeName) {
            super("'%s' is not a searchable field.", nodeName);
        }
    }

    public static class UnresolvedReference
    extends Default {
        private UnresolvedReference(String nodeName) {
            super("Cannot resolve '%s'.", nodeName);
        }
    }

    public static class UnresolvedFieldType
    extends Default {
        private UnresolvedFieldType(String nodeName) {
            super("Field '%s' has unresolved type", nodeName);
        }
    }

    public static class UnresolvedField
    extends Default {
        private UnresolvedField(String nodeName, String fullName) {
            super("'%s' is not a field of '" + fullName + "'.", nodeName);
        }
    }

    private static class SubFormNotDefinedError
    extends Default {
        private SubFormNotDefinedError(String subFormName) {
            super("Cannot Resolve SubFormId '%s',", subFormName);
        }
    }

    public static class LowerCaseModel
    extends Default {
        private LowerCaseModel(String name) {
            super("Model '%s' name starts with lowercase character.", name);
        }
    }

    public static class JavaReservedWordModel
    extends Default {
        private JavaReservedWordModel(String name) {
            super("Model '%s' name is a java reserved word.", name);
        }
    }

    public static class InvalidExpression
    extends Default {
        private InvalidExpression(String errorDetail, String nodeName) {
            super(errorDetail, nodeName);
        }
    }

    public static class IllegalWidgetTypeOption
    extends Default {
        private IllegalWidgetTypeOption(String nodeName) {
            super("Invalid widget option: '%s'.", nodeName);
        }
    }

    public static class IllegalWidgetType
    extends Default {
        private IllegalWidgetType(String nodeName) {
            super("Could not retrieve WidgetType for: '%s'.", nodeName);
        }
    }

    public static class IllegalUniqueAttribute
    extends Default {
        private IllegalUniqueAttribute(String nodeName) {
            super("Attribute 'unique' is only supported for widgets inside tables, widget: '%s'.", nodeName);
        }
    }

    public static class IllegalEnumValue
    extends Default {
        private IllegalEnumValue(String enumeration, String value) {
            super("Cannot resolve " + enumeration + " for value '%s'.", value);
        }
    }

    public static class IllegalBindingType
    extends Default {
        private IllegalBindingType(String name, MetaModel type) {
            super("Binding Form '%s' to a " + type.getName() + " is not allowed. Only entities are.", name);
        }
    }

    public static class IllegalArgument
    implements BuilderError {
        private final String msg;
        private final String nodeName;

        private IllegalArgument(String nodeName, String value, int n) {
            this.msg = String.format("Illegal value '%s' for argument #%d in widget type '%s'.", value, n, nodeName);
            this.nodeName = nodeName;
        }

        @Override
        public String getMessage() {
            return this.msg;
        }

        @Override
        public String getModelName() {
            return this.nodeName;
        }
    }

    private static class Default
    implements BuilderError {
        private final String modelName;
        private final String msg;

        private Default(String msg, String modelName) {
            this.modelName = modelName;
            this.msg = msg;
        }

        @Override
        public String getMessage() {
            return String.format(this.msg, this.modelName);
        }

        @Override
        public String getModelName() {
            return this.modelName;
        }
    }

    public static class CannotResolveSymbol
    extends Default {
        private CannotResolveSymbol(String ref) {
            super("Cannot resolve symbol '%s'", ref);
        }
    }

    public static class AddingPredefinedPermissionError
    implements BuilderError {
        private final String msg;
        private final String nodeName;

        private AddingPredefinedPermissionError(String permissionName) {
            this.msg = String.format("Permission '%s' is one of the predefined permissions %s.", permissionName, Colls.mkString(Arrays.asList(PredefinedPermission.values())));
            this.nodeName = permissionName;
        }

        @Override
        public String getMessage() {
            return this.msg;
        }

        @Override
        public String getModelName() {
            return this.nodeName;
        }
    }
}

