/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.metadata.exception;

import org.jetbrains.annotations.NotNull;

public class InvalidKeyToBeLocalized
extends RuntimeException {
    private final InvalidKeyLocalizeType type;
    private static final long serialVersionUID = -7129676170705181807L;

    public InvalidKeyToBeLocalized(String key, InvalidKeyLocalizeType type, Object ... args) {
        super("The key ( " + key + " ) has an invalid format: " + type.description(args));
        this.type = type;
    }

    @NotNull
    public InvalidKeyLocalizeType getType() {
        return this.type;
    }

    public static enum InvalidKeyLocalizeType {
        TOO_MANY_ARGUMENTS("Arguments allowed: %s. Arguments found: %s."),
        INVALID_KEY("This key '%s' wasn't found in .properties file."),
        FIELD_OPTION_DOESNT_EXIST("Widget '%s' doesn't exist in form '%s'."),
        FIELD_OPTION_CANNOT_LOCALIZE("This field option '%s' cannot be localized"),
        NOT_A_NUMBER("Third parameter must be an integer, '%s' is not"),
        NOT_THAT_MANY_CHECKS("Index out of bounds of Checks. Index: '%s'. Size: '%s'");

        private final String description;

        private InvalidKeyLocalizeType(String description) {
            this.description = description;
        }

        String description(Object ... args) {
            return String.format(this.description, args);
        }
    }
}

