/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.metadata.entity;

import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Option;
import mulesoft.common.core.Strings;
import mulesoft.field.FieldOption;
import mulesoft.field.FieldOptions;
import mulesoft.field.TypeField;
import mulesoft.metadata.entity.DbObject;
import mulesoft.metadata.entity.Entity;
import mulesoft.type.EnumType;
import mulesoft.type.Type;
import org.jetbrains.annotations.NotNull;

public class Attribute
extends TypeField {
    boolean inner;
    boolean multiple;
    @NotNull
    private final DbObject dbObject;
    @NotNull
    private final String label;
    @NotNull
    private String reverseReference;
    private final String serialSequenceName;
    private final boolean synthesized;
    private static final long serialVersionUID = 4966202528356787587L;

    Attribute(@NotNull DbObject dbObject, @NotNull String name, @NotNull Type type, @NotNull String label, FieldOptions options, boolean inner, boolean multiple, @NotNull String reverseReference, boolean synthesized, String seq) {
        super(name, type, options);
        this.dbObject = dbObject;
        this.multiple = multiple;
        this.serialSequenceName = seq != null && seq.isEmpty() ? Strings.truncate((String)dbObject.getTableName().getName(), (String)"SEQ", (String)"_", (int)30).toUpperCase() : seq;
        this.reverseReference = reverseReference;
        this.label = label;
        this.inner = inner;
        this.synthesized = synthesized;
    }

    public Option<DbObject> asDatabaseObject() {
        Type t = this.getFinalType();
        return t instanceof DbObject ? Option.some((Object)((Object)((DbObject)t))) : Option.empty();
    }

    public Option<Entity> asEntity() {
        Type t = this.getFinalType();
        return t instanceof Entity ? Option.some((Object)((Object)((Entity)t))) : Option.empty();
    }

    public Option<EnumType> asEnum() {
        Type t = this.getFinalType();
        return t instanceof EnumType ? Option.some((Object)((EnumType)t)) : Option.empty();
    }

    public boolean equals(Object obj) {
        return obj instanceof Attribute && this.getFullName().equals(((Attribute)((Object)obj)).getFullName());
    }

    public boolean hasColumn() {
        return !this.isMultipleReference() && !this.getOptions().hasOption(FieldOption.ABSTRACT);
    }

    public int hashCode() {
        return this.getFullName().hashCode();
    }

    public boolean hasUndefinedType() {
        return this.getFinalType().isUndefined();
    }

    @NotNull
    public ImmutableList<TypeField> retrieveSimpleFields() {
        if (this.isMultipleReference()) {
            return Colls.emptyList();
        }
        return super.retrieveSimpleFields();
    }

    public boolean isSynthesized() {
        return this.synthesized;
    }

    @NotNull
    public DbObject getDbObject() {
        return this.dbObject;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public String getElementClassName() {
        return this.isMultiple() ? super.getImplementationClassName() : "";
    }

    public String getFullName() {
        return this.dbObject.getFullName() + "." + this.getName();
    }

    @NotNull
    public String getImplementationClassName() {
        if (this.isMultipleReference()) {
            Type type = this.getFinalType();
            return Seq.class.getName() + "<" + type.getImplementationClassName() + ">";
        }
        return super.getImplementationClassName();
    }

    public boolean isSerial() {
        return this.serialSequenceName != null;
    }

    @NotNull
    public String getLabel() {
        return this.label;
    }

    public boolean isInner() {
        return this.inner;
    }

    @NotNull
    public String getReverseReference() {
        return this.reverseReference;
    }

    public void setReverseReference(@NotNull String reverseReference) {
        this.reverseReference = reverseReference;
    }

    @NotNull
    public String getSequenceName() {
        return this.serialSequenceName;
    }

    public int getSequenceStart() {
        return this.getOptions().getInt(FieldOption.START_WITH, 1);
    }

    private boolean isMultipleReference() {
        return this.isMultiple() && this.getFinalType() instanceof DbObject;
    }
}

