/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.metadata.entity;

import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import mulesoft.cache.CacheType;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Option;
import mulesoft.common.core.QName;
import mulesoft.expr.RefTypeSolver;
import mulesoft.field.ModelField;
import mulesoft.field.TypeField;
import mulesoft.metadata.entity.Attribute;
import mulesoft.metadata.entity.Entity;
import mulesoft.metadata.entity.SearchField;
import mulesoft.metadata.entity.View;
import mulesoft.type.CompositeType;
import mulesoft.type.ModelType;
import mulesoft.type.Modifier;
import mulesoft.type.Type;
import org.jetbrains.annotations.NotNull;

public abstract class DbObject
extends ModelType
implements Type,
CompositeType {
    @NotNull
    protected final Map<String, Seq<Attribute>> indexes;
    @NotNull
    private final Map<String, Attribute> attributes;
    @NotNull
    private final CacheType cacheType;
    @NotNull
    private List<ModelField> describes;
    @NotNull
    private final String documentation;
    @NotNull
    private List<ModelField> image;
    @NotNull
    private List<SearchField> searchByFields;
    @NotNull
    private final QName tableName;
    private final boolean tableNameGenerated;
    @NotNull
    private final LinkedHashMap<String, Seq<Attribute>> uniqueIndexes;
    private static final long serialVersionUID = 6074642150038128884L;

    DbObject(@NotNull String sourceName, @NotNull String domain, @NotNull String name, @NotNull String label, @NotNull EnumSet<Modifier> modifiers, String defaultForm, @NotNull Map<String, Attribute> attributes, @NotNull QName tableName, boolean tableNameGenerated, @NotNull List<ModelField> describes, @NotNull List<SearchField> searchByFields, @NotNull CacheType cacheType, @NotNull LinkedHashMap<String, Seq<Attribute>> uniqueIndexes, @NotNull Map<String, Seq<Attribute>> indexes, @NotNull List<ModelField> image, @NotNull String documentation) {
        super(sourceName, domain, name, label, modifiers, defaultForm);
        this.tableName = tableName;
        this.tableNameGenerated = tableNameGenerated;
        this.describes = describes;
        this.attributes = attributes;
        this.uniqueIndexes = uniqueIndexes;
        this.indexes = indexes;
        this.image = image;
        this.searchByFields = searchByFields;
        this.cacheType = cacheType;
        this.documentation = documentation;
    }

    @NotNull
    public Seq<Attribute> allAttributes() {
        return this.attributes();
    }

    public View asView() {
        return (View)((Object)Predefined.cast((Object)((Object)this)));
    }

    @NotNull
    public Seq<Attribute> attributes() {
        return Colls.immutable(this.attributes.values());
    }

    public void compileSearchByOptions(@NotNull RefTypeSolver solver) {
        for (SearchField f : this.searchByFields()) {
            f.getOptions().compile(solver);
        }
    }

    @NotNull
    public Seq<ModelField> describes() {
        return Colls.immutable(this.describes);
    }

    public abstract boolean hasCompositePrimaryKey();

    public abstract boolean hasDefaultPrimaryKey();

    public boolean hasImage() {
        return Predefined.isNotEmpty(this.image);
    }

    @NotNull
    public String image() {
        if (!this.image.isEmpty()) {
            return this.image.get(0).getName();
        }
        return "";
    }

    public ImmutableList<TypeField> primaryKeySimpleFields() {
        return TypeField.retrieveSimpleFields(this.getPrimaryKey());
    }

    public ImmutableList<TypeField> retrieveSimpleFields() {
        return this.primaryKeySimpleFields();
    }

    @NotNull
    public ImmutableList<SearchField> searchByFields() {
        if (this.searchByFields.isEmpty() && this.hasModifier(Modifier.DEFAULT_SEARCHABLE)) {
            this.searchByFields = this.notEmptySearchByFields();
        }
        return Colls.immutable(this.searchByFields);
    }

    public void solveDescribes(Function<ModelField, ModelField> function) {
        this.describes = Colls.map(this.describes, function).toList();
    }

    public void solveReferences(Function<ModelField, ModelField> function) {
        this.solveDescribes(function);
        this.image = Colls.map(this.image, function).toList();
        this.solveSearchByFields(function);
    }

    public void solveSearchByFields(Function<ModelField, ModelField> function) {
        this.searchByFields = Colls.map(this.searchByFields(), searchField -> SearchField.searchField(searchField.getId(), (ModelField)function.apply(searchField.getField()), searchField.getOptions())).toList();
    }

    public boolean splitMutator() {
        return this.cacheType.isFull();
    }

    public void validateSearchableDatabaseTypes(Consumer<SearchField> validator) {
        if (this.isDatabaseSearchable()) {
            this.searchByFields().forEach(validator);
        }
    }

    @NotNull
    public Option<Attribute> getAttribute(String attribute) {
        return Predefined.option((Object)((Object)this.attributes.get(attribute)));
    }

    @NotNull
    public Seq<TypeField> getBoundableFields() {
        return (Seq)Predefined.cast(this.attributes());
    }

    public boolean isOptimistic() {
        return this.hasModifier(Modifier.OPTIMISTIC_LOCKING);
    }

    @NotNull
    public CacheType getCacheType() {
        return this.cacheType;
    }

    @NotNull
    public Seq<Attribute> getChildren() {
        return Colls.immutable(this.attributes.values());
    }

    public boolean isProtected() {
        return false;
    }

    public boolean isTableNameGenerated() {
        return this.tableNameGenerated;
    }

    @NotNull
    public String getDocumentation() {
        return this.documentation;
    }

    public boolean isAuditable() {
        return this.hasModifier(Modifier.AUDITABLE);
    }

    public boolean isDatabaseSearchable() {
        return this.hasModifier(Modifier.DATABASE_SEARCHABLE);
    }

    public boolean isDeprecable() {
        return this.hasModifier(Modifier.DEPRECABLE);
    }

    public boolean isRemotable() {
        return this.hasModifier(Modifier.REMOTABLE);
    }

    public boolean isSearchable() {
        return !this.searchByFields().isEmpty() || this.hasModifier(Modifier.DEFAULT_SEARCHABLE);
    }

    public boolean isUpdatable() {
        return true;
    }

    @NotNull
    public Option<Attribute> getField(String fieldName) {
        return Predefined.option((Object)((Object)this.attributes.get(fieldName)));
    }

    public String getForUpdatePackage() {
        return this.getDomain();
    }

    @NotNull
    public Seq<Attribute> getIndexByName(@NotNull String name) {
        Seq<Attribute> fields = this.indexes.get(name);
        if (fields == null) {
            return Colls.emptyIterable();
        }
        return fields;
    }

    @NotNull
    public Seq<String> getIndexNames() {
        return Colls.immutable(this.indexes.keySet());
    }

    @NotNull
    public Option<Entity> getParent() {
        return Option.empty();
    }

    @NotNull
    public abstract ImmutableList<Attribute> getPrimaryKey();

    public boolean isSearchableByFields() {
        return !this.searchByFields().isEmpty();
    }

    @NotNull
    public String getSchema() {
        return this.tableName.getQualification();
    }

    public boolean isDatabaseObject() {
        return true;
    }

    @NotNull
    public QName getTableName() {
        return this.tableName;
    }

    @NotNull
    public Seq<Attribute> getUniqueIndexByName(@NotNull String name) {
        Seq<Attribute> fields = this.uniqueIndexes.get(name);
        if (fields == null) {
            return Colls.emptyIterable();
        }
        return fields;
    }

    @NotNull
    public Seq<String> getUniqueIndexNames() {
        return Colls.immutable(this.uniqueIndexes.keySet());
    }

    public abstract boolean isPrimaryKey(@NotNull Attribute var1);

    protected List<SearchField> notEmptySearchByFields() {
        return this.modelFieldsToSearchFields((Iterable<? extends ModelField>)(this.isDatabaseSearchable() ? this.getPrimaryKey() : this.describes()));
    }

    @NotNull
    ImmutableList<SearchField> modelFieldsToSearchFields(Iterable<? extends ModelField> fields) {
        return ImmutableList.fromIterable(fields).map(SearchField::unresolvedSearchField).toList();
    }
}

