/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.metadata.entity;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mulesoft.cache.CacheType;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Option;
import mulesoft.common.core.QName;
import mulesoft.field.ModelField;
import mulesoft.metadata.entity.Attribute;
import mulesoft.metadata.entity.DbObject;
import mulesoft.metadata.entity.SearchField;
import mulesoft.type.Kind;
import mulesoft.type.MetaModel;
import mulesoft.type.MetaModelKind;
import mulesoft.type.Modifier;
import mulesoft.type.Type;
import org.jetbrains.annotations.NotNull;

public class Entity
extends DbObject {
    private final boolean defaultPrimaryKey;
    @NotNull
    private Option<Entity> parent = Option.empty();
    @NotNull
    private final ImmutableList<Attribute> primaryKey;
    private final boolean protect;
    private static final long serialVersionUID = -6431859732037954777L;

    Entity(@NotNull String sourceName, @NotNull String domain, @NotNull String name, @NotNull String description, @NotNull QName tableName, boolean tableNameGenerated, @NotNull EnumSet<Modifier> modifiers, boolean defaultPrimaryKey, @NotNull String defaultForm, @NotNull Map<String, Attribute> attributes, @NotNull List<Attribute> primaryKey, @NotNull List<ModelField> describes, @NotNull LinkedHashMap<String, Seq<Attribute>> uniqueIndexes, @NotNull Map<String, Seq<Attribute>> indexes, List<SearchField> searchByFields, CacheType cacheType, boolean protect, List<ModelField> image, @NotNull String documentation) {
        super(sourceName, domain, name, description, modifiers, defaultForm, attributes, tableName, tableNameGenerated, describes, searchByFields, cacheType, uniqueIndexes, indexes, image, documentation);
        this.primaryKey = Colls.immutable(primaryKey);
        this.defaultPrimaryKey = defaultPrimaryKey;
        this.protect = protect;
    }

    @Override
    @NotNull
    public Seq<Attribute> allAttributes() {
        return this.attributes().toList();
    }

    @Override
    public boolean hasCompositePrimaryKey() {
        return this.primaryKey.size() > 1 || ((Attribute)((Object)this.primaryKey.get(0))).isComposite();
    }

    @Override
    public boolean hasDefaultPrimaryKey() {
        return this.defaultPrimaryKey;
    }

    @Override
    public boolean isProtected() {
        return this.protect;
    }

    public boolean isComposite() {
        return true;
    }

    @NotNull
    public Kind getKind() {
        return Kind.REFERENCE;
    }

    @NotNull
    public MetaModelKind getMetaModelKind() {
        return MetaModelKind.ENTITY;
    }

    @Override
    @NotNull
    public Option<Entity> getParent() {
        return this.parent;
    }

    public void setParent(@NotNull Option<Entity> parent) {
        this.parent = parent;
    }

    @Override
    @NotNull
    public ImmutableList<Attribute> getPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isInner() {
        return !this.getParent().isEmpty();
    }

    public Seq<MetaModel> getReferences() {
        HashSet<MetaModel> result = new HashSet<MetaModel>();
        for (Attribute value : this.attributes()) {
            Type t = value.getType();
            if (!(t instanceof MetaModel)) continue;
            result.add((MetaModel)t);
        }
        return Colls.seq(result);
    }

    public boolean isEntity() {
        return true;
    }

    @Override
    public boolean isPrimaryKey(@NotNull Attribute attribute) {
        return this.primaryKey.contains((Object)attribute);
    }
}

