/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.metadata.entity;

import java.util.EnumSet;
import mulesoft.field.FieldOption;
import mulesoft.field.FieldOptions;
import mulesoft.field.ModelField;
import mulesoft.field.TypeField;
import mulesoft.type.FieldReference;
import mulesoft.type.Kind;
import org.jetbrains.annotations.NotNull;

public class SearchField {
    private final ModelField field;
    @NotNull
    private final String fieldName;
    private final String id;
    @NotNull
    private final FieldOptions options;
    private static final EnumSet<Kind> validDatabaseTypes = EnumSet.of(Kind.STRING, Kind.ENUM, Kind.DECIMAL, Kind.REAL, Kind.INT);

    private SearchField(String id, @NotNull ModelField field, @NotNull FieldOptions options) {
        this.id = id;
        this.field = field;
        this.fieldName = field.getName();
        this.options = options;
    }

    public String optionsString() {
        return this.options.toString();
    }

    public String toString() {
        return this.fieldName + ":" + this.field.getFinalType().getKind();
    }

    public boolean isValidTypeForDb() {
        return validDatabaseTypes.contains(this.getKind());
    }

    public int getBoost() {
        return this.options.getInt(FieldOption.BOOST, 1);
    }

    public boolean isAnalyzed() {
        return this.options.hasOption(FieldOption.ANALYZED);
    }

    public boolean isMultiple() {
        return this.field.getType().isArray() || this.field instanceof TypeField && ((TypeField)this.field).isMultiple();
    }

    @NotNull
    public ModelField getField() {
        return this.field;
    }

    @NotNull
    public String getFieldName() {
        return this.fieldName;
    }

    public int getFuzzy() {
        return this.options.getInt(FieldOption.FUZZY);
    }

    public String getId() {
        return this.id;
    }

    public Kind getKind() {
        return this.field.getType().getKind();
    }

    @NotNull
    public FieldOptions getOptions() {
        return this.options;
    }

    public boolean isSearchFilter() {
        return this.options.hasOption(FieldOption.FILTER_ONLY);
    }

    public int getSlop() {
        return this.options.getInt(FieldOption.SLOP);
    }

    public boolean isPrefix() {
        return this.options.hasOption(FieldOption.PREFIX);
    }

    @NotNull
    static SearchField searchField(String id, @NotNull ModelField f, @NotNull FieldOptions o) {
        return new SearchField(id, f, o);
    }

    @NotNull
    static SearchField unresolvedSearchField(@NotNull ModelField f) {
        return SearchField.searchField(f.getName(), (ModelField)FieldReference.unresolvedFieldRef((String)f.getName()), FieldOptions.EMPTY);
    }
}

