/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.metadata.entity;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableSet;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Option;
import mulesoft.field.TypeField;
import mulesoft.metadata.entity.TypeDef;
import mulesoft.type.CompositeType;
import mulesoft.type.MetaModel;
import mulesoft.type.Modifier;
import mulesoft.type.Type;
import org.jetbrains.annotations.NotNull;

public class StructType
extends TypeDef
implements CompositeType {
    private final ImmutableSet<String> args;
    @NotNull
    private final String defaultWidget;
    @NotNull
    private final String documentation;
    @NotNull
    private final Map<String, TypeField> fieldMap;
    @NotNull
    private final List<StructType> superTypes;
    private static final long serialVersionUID = 4093534455181687651L;

    StructType(@NotNull String sourceName, @NotNull String domain, @NotNull String name, @NotNull String description, @NotNull EnumSet<Modifier> modifiers, @NotNull Map<String, TypeField> fieldMap, @NotNull Set<String> args, @NotNull List<StructType> superTypes, @NotNull String defaultWidget, @NotNull String documentation) {
        super(sourceName, domain, name, description, modifiers);
        this.fieldMap = fieldMap;
        this.superTypes = superTypes;
        this.args = Colls.immutable(args);
        this.defaultWidget = defaultWidget;
        this.documentation = documentation;
    }

    public Seq<TypeField> retrieveSimpleFields() {
        return TypeField.retrieveSimpleFields(this.fieldMap.values());
    }

    public ImmutableSet<String> getArgs() {
        return this.args;
    }

    @NotNull
    public Seq<TypeField> getChildren() {
        return Colls.immutable(this.fieldMap.values());
    }

    @NotNull
    public String getDefaultWidget() {
        return this.defaultWidget;
    }

    @NotNull
    public String getDocumentation() {
        return this.documentation;
    }

    public boolean isComposite() {
        return true;
    }

    public boolean isInterface() {
        return this.hasModifier(Modifier.INTERFACE);
    }

    @NotNull
    public Option<TypeField> getField(String fieldName) {
        return Predefined.option((Object)this.fieldMap.get(fieldName));
    }

    public boolean isFinal() {
        return this.hasModifier(Modifier.FINAL);
    }

    public Seq<MetaModel> getReferences() {
        HashSet result = new HashSet();
        for (TypeField field : this.getChildren()) {
            Type type = field.getType().getFinalType();
            StructType.addMetaModelTypes(result, (Type)type);
        }
        for (StructType superType : this.getSuperTypes()) {
            StructType.addMetaModelTypes(result, (Type)superType);
        }
        return Colls.seq(result);
    }

    @NotNull
    public Seq<StructType> getSuperTypes() {
        return Colls.immutable(this.superTypes);
    }
}

