/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.metadata.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import mulesoft.cache.CacheType;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Option;
import mulesoft.common.core.QName;
import mulesoft.field.ModelField;
import mulesoft.metadata.entity.Attribute;
import mulesoft.metadata.entity.DbObject;
import mulesoft.metadata.entity.Entity;
import mulesoft.metadata.entity.SearchField;
import mulesoft.metadata.entity.ViewAttribute;
import mulesoft.type.Kind;
import mulesoft.type.MetaModel;
import mulesoft.type.MetaModelKind;
import mulesoft.type.Modifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class View
extends DbObject {
    private final String asQuery;
    private Map<String, Attribute> attributesByBaseAttributeName = null;
    private final Integer batchSize;
    private List<MetaModel> entities;
    private final List<Attribute> primaryKey;
    private ImmutableList<Attribute> primaryKeyAttributes = null;
    private final boolean updatable;
    private static final long serialVersionUID = -572105091881323844L;

    View(@NotNull String sourceName, @NotNull String domain, @NotNull String name, @NotNull String label, @NotNull EnumSet<Modifier> modifiers, @NotNull QName viewName, boolean viewNameGenerated, @NotNull Map<String, Attribute> attributeMap, List<ModelField> describeFields, boolean updatable, List<SearchField> searchByFields, @NotNull LinkedHashMap<String, Seq<Attribute>> uniqueIndexes, @NotNull Map<String, Seq<Attribute>> indexes, @Nullable String asQuery, List<Attribute> primaryKeyFields, List<MetaModel> entities, List<ModelField> image, @NotNull String documentation, @Nullable Integer batchSize) {
        super(sourceName, domain, name, label, modifiers, "", attributeMap, viewName, viewNameGenerated, describeFields, searchByFields, CacheType.NONE, uniqueIndexes, indexes, image, documentation);
        this.updatable = updatable;
        this.asQuery = (String)Predefined.notNull((Object)asQuery, (Object)"");
        this.entities = entities;
        this.batchSize = batchSize;
        this.primaryKey = primaryKeyFields;
    }

    @Override
    @NotNull
    public Seq<Attribute> allAttributes() {
        if (this.getBaseEntity().isPresent()) {
            ArrayList<Attribute> result = new ArrayList<Attribute>();
            for (Attribute attribute : ((DbObject)((Object)this.getBaseEntity().get())).getPrimaryKey()) {
                if (this.getAttributesByBaseAttributeName().containsKey(attribute.getName())) continue;
                result.add(attribute);
            }
            result.addAll((Collection<Attribute>)this.attributes().toList());
            return Colls.seq(result);
        }
        return this.attributes();
    }

    public Collection<MetaModel> entities() {
        return this.entities;
    }

    @Override
    public boolean hasCompositePrimaryKey() {
        return this.getBaseEntity().isPresent() && ((DbObject)((Object)this.getBaseEntity().get())).hasCompositePrimaryKey();
    }

    @Override
    public boolean hasDefaultPrimaryKey() {
        return this.getBaseEntity().isPresent() && ((DbObject)((Object)this.getBaseEntity().get())).hasDefaultPrimaryKey();
    }

    public void replaceEntities(ArrayList<DbObject> resolved) {
        this.entities.clear();
        this.entities.addAll(resolved);
    }

    public void solveMetaModels(Function<MetaModel, MetaModel> solver) {
        this.entities = Colls.map(this.entities, solver).toList();
    }

    public String getAsQuery() {
        return this.asQuery;
    }

    @NotNull
    public Option<Attribute> getAttributeByBaseAttributeName(String baseAttributeName) {
        return Predefined.option((Object)((Object)this.getAttributesByBaseAttributeName().get(baseAttributeName)));
    }

    @NotNull
    public Option<DbObject> getBaseEntity() {
        if (!this.asQuery.isEmpty() || this.entities.size() != 1) {
            return Option.empty();
        }
        MetaModel baseEntity = this.entities.get(0);
        if (baseEntity instanceof DbObject) {
            return Option.some((Object)((Object)((DbObject)baseEntity)));
        }
        throw new IllegalStateException("Entity could not be resolved or has not been resolved yet");
    }

    @Nullable
    public MetaModel getBaseEntityModelType() {
        return this.entities.isEmpty() ? null : this.entities.get(0);
    }

    @Nullable
    public Integer getBatchSize() {
        return this.batchSize;
    }

    public boolean isComposite() {
        return true;
    }

    public boolean isRemote() {
        return this.hasModifier(Modifier.REMOTE);
    }

    @Override
    public boolean isUpdatable() {
        return this.updatable;
    }

    @Override
    @NotNull
    public Option<Attribute> getField(String fieldName) {
        return this.getAttribute(fieldName);
    }

    @NotNull
    public Kind getKind() {
        return Kind.REFERENCE;
    }

    @NotNull
    public MetaModelKind getMetaModelKind() {
        return MetaModelKind.VIEW;
    }

    @Override
    @NotNull
    public Option<Entity> getParent() {
        Option<DbObject> base = this.getBaseEntity();
        return base.isPresent() ? ((DbObject)((Object)base.get())).getParent() : super.getParent();
    }

    @Override
    @NotNull
    public ImmutableList<Attribute> getPrimaryKey() {
        if (this.primaryKeyAttributes == null) {
            this.primaryKeyAttributes = this.calculatePrimaryKey();
        }
        return this.primaryKeyAttributes;
    }

    public boolean isInner() {
        return this.getBaseEntity().isPresent() && ((DbObject)((Object)this.getBaseEntity().get())).isInner();
    }

    public Seq<MetaModel> getReferences() {
        return !this.isRemote() ? Colls.immutable(this.entities) : Colls.emptyList();
    }

    public boolean isView() {
        return true;
    }

    @Override
    public boolean isPrimaryKey(@NotNull Attribute attribute) {
        return this.getPrimaryKey().contains((Object)attribute);
    }

    @Override
    protected List<SearchField> notEmptySearchByFields() {
        return this.modelFieldsToSearchFields((Iterable<? extends ModelField>)(this.describes().isEmpty() ? this.getPrimaryKey() : this.describes()));
    }

    private Attribute attributeByBaseName(Attribute attr) {
        return this.getAttributesByBaseAttributeName().getOrDefault(attr.getName(), attr);
    }

    private Map<String, Attribute> buildAttributesByBaseAttributeName(Seq<Attribute> as) {
        LinkedHashMap<String, Attribute> result = new LinkedHashMap<String, Attribute>();
        for (Attribute a : as) {
            if (!(a instanceof ViewAttribute)) continue;
            ViewAttribute viewAttribute = (ViewAttribute)a;
            result.put(viewAttribute.getBaseAttributeModelField().getName(), viewAttribute);
        }
        return result;
    }

    private ImmutableList<Attribute> calculatePrimaryKey() {
        if (!this.primaryKey.isEmpty()) {
            return Colls.immutable(this.primaryKey);
        }
        if (!Predefined.isEmpty((String)this.getAsQuery())) {
            return Colls.emptyList();
        }
        return (ImmutableList)this.getBaseEntity().map(DbObject::getPrimaryKey).map(pk -> pk.map(this::attributeByBaseName).toList()).orElse((Object)Colls.emptyList());
    }

    private Map<String, Attribute> getAttributesByBaseAttributeName() {
        if (this.attributesByBaseAttributeName == null) {
            this.attributesByBaseAttributeName = this.buildAttributesByBaseAttributeName(this.attributes());
        }
        return this.attributesByBaseAttributeName;
    }
}

