/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.expr;

import mulesoft.code.Code;
import mulesoft.code.Instruction;
import mulesoft.common.core.Option;
import mulesoft.common.core.Suppliers;
import mulesoft.expr.ExpressionAST;
import mulesoft.expr.RefTypeSolver;
import mulesoft.expr.exception.IllegalOperationException;
import mulesoft.expr.visitor.ExpressionVisitor;
import mulesoft.type.ArrayType;
import mulesoft.type.EnumType;
import mulesoft.type.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignmentExpression
extends ExpressionAST {
    private final boolean eq;
    private final ExpressionAST field;
    private ExpressionAST value;
    private final Option<ExpressionAST> when;

    public AssignmentExpression(ExpressionAST field, ExpressionAST value, Option<ExpressionAST> when, boolean eq) {
        super((Code)Instruction.ASSIGNMENT, Suppliers.empty());
        this.field = field;
        this.value = value;
        this.when = when;
        this.eq = eq;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void acceptOperands(ExpressionVisitor<?> visitor) {
        this.field.acceptOperands(visitor);
        this.value.acceptOperands(visitor);
        this.when.ifPresent(expr -> expr.acceptOperands(visitor));
    }

    public boolean hasWhen() {
        return this.when.isPresent();
    }

    @Override
    @NotNull
    public ExpressionAST solveType(@NotNull RefTypeSolver refResolver) {
        Type t;
        this.field.solveType(refResolver);
        Type fieldType = this.field.getType().getFinalType();
        if (fieldType.isArray()) {
            fieldType = ((ArrayType)fieldType).getElementType();
        }
        if (fieldType.isEnum()) {
            this.value = this.value.solveEnumRef((EnumType)fieldType);
        }
        this.value.solveType(refResolver);
        Type valueType = this.value.getType().getFinalType();
        Type type = t = valueType.isArray() ? ((ArrayType)valueType).getElementType() : valueType;
        if (!"_deprecated".equals(this.field.getName()) && !AssignmentExpression.hasValidType(t, fieldType)) {
            throw new IllegalOperationException(this.value, fieldType, valueType);
        }
        this.when.ifPresent(expr -> expr.solveType(refResolver));
        return super.solveType(refResolver);
    }

    public ExpressionAST getFieldExpr() {
        return this.field;
    }

    @Override
    public String getName() {
        return "assignment expression";
    }

    public boolean isEquals() {
        return this.eq;
    }

    public ExpressionAST getValueExpr() {
        return this.value;
    }

    public Option<ExpressionAST> getWhenExpr() {
        return this.when;
    }

    @Override
    @NotNull
    protected Type doSolveType(RefTypeSolver refResolver) {
        Type type = this.value.doSolveType(refResolver);
        return type.isArray() ? ((ArrayType)type).getElementType() : type;
    }

    @Override
    void setTargetType(@Nullable Type t) {
        super.setTargetType(t);
        this.field.setTargetType(t);
    }

    static boolean hasValidType(Type t, Type fieldType) {
        if (fieldType.isDatabaseObject() && t.isString()) {
            return true;
        }
        if (!fieldType.equivalent(t)) {
            return false;
        }
        return !fieldType.isDatabaseObject() || fieldType.getImplementationClassName().equals(t.getImplementationClassName());
    }
}

