/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.expr;

import java.util.EnumMap;
import mulesoft.code.Code;
import mulesoft.code.Instruction;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Maps;
import mulesoft.common.core.Tuple;
import mulesoft.expr.ExpressionAST;
import mulesoft.expr.ExpressionFactory;
import mulesoft.expr.RefTypeSolver;
import mulesoft.expr.exception.IllegalOperationException;
import mulesoft.expr.visitor.ExpressionVisitor;
import mulesoft.type.EnumType;
import mulesoft.type.IntType;
import mulesoft.type.Kind;
import mulesoft.type.Type;
import mulesoft.type.Types;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryExpression
extends ExpressionAST {
    @NotNull
    private ExpressionAST left;
    @NotNull
    private final Operator op;
    @NotNull
    private ExpressionAST right;

    public BinaryExpression(@NotNull Operator op, @NotNull ExpressionAST left, @NotNull ExpressionAST right) {
        this.op = op;
        this.left = left;
        this.right = right;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public final <T> T acceptLeft(ExpressionVisitor<T> visitor) {
        return this.left.accept(visitor);
    }

    @Override
    public void acceptOperands(ExpressionVisitor<?> visitor) {
        this.acceptLeft(visitor);
        this.acceptRight(visitor);
    }

    public final <T> T acceptRight(ExpressionVisitor<T> visitor) {
        return this.right.accept(visitor);
    }

    @NotNull
    public ExpressionAST getLeft() {
        return this.left;
    }

    @Override
    public String getName() {
        return this.op.toString().toLowerCase();
    }

    @NotNull
    public Operator getOp() {
        return this.op;
    }

    @NotNull
    public ExpressionAST getRight() {
        return this.right;
    }

    public boolean isShortCircuit() {
        return this.op == Operator.OR || this.op == Operator.AND;
    }

    @Override
    @NotNull
    protected Type doSolveType(RefTypeSolver refResolver) {
        this.applyConversions(refResolver);
        Type returnType = this.op.returnType(this.left.getType(), this.right.getType());
        if (returnType == null) {
            throw new IllegalOperationException(this);
        }
        this.instruction = this.op.code(this.left.getType(), this.right.getType());
        if (this.instruction == null) {
            throw new IllegalOperationException(this);
        }
        return returnType;
    }

    private void applyConversions(RefTypeSolver refResolver) {
        Type l = this.left.solveType(refResolver).getType();
        if (l.isEnum()) {
            this.right = this.right.solveEnumRef((EnumType)l);
        }
        Type r = this.right.solveType(refResolver).getType();
        Type t = this.getOp().commonType(l, r);
        if (t != Types.anyType()) {
            this.left = ExpressionFactory.conversion(this.left, t).solveType(refResolver);
            this.right = ExpressionFactory.conversion(this.right, t).solveType(refResolver);
        }
    }

    private static boolean isLong(Type l) {
        return l instanceof IntType && ((IntType)l).isLong();
    }

    public static enum Operator {
        ADD("+"){

            @Override
            Type commonType(Type l, Type r) {
                return l.isString() || r.isString() ? Types.stringType() : SUB.commonType(l, r);
            }

            @Override
            @Nullable
            public Code code(Type l, Type r) {
                if (l.isTime() && !Types.intType().equals(r)) {
                    return null;
                }
                return (Code)add.get(l.getKind());
            }
        }
        ,
        SUB("-"){

            @Override
            Type commonType(Type l, Type r) {
                return BinaryExpression.isLong(l) || BinaryExpression.isLong(r) ? Types.decimalType() : super.commonType(l, r);
            }

            @Override
            @Nullable
            public Code code(Type l, Type r) {
                Kind lk = l.getKind();
                return lk == Kind.DATE ? (Code)subDate.get(r.getKind()) : (lk == Kind.DATE_TIME ? (Code)subTime.get(r.getKind()) : (Code)sub.get(lk));
            }
        }
        ,
        DIV("/"){

            @Override
            Type commonType(Type l, Type r) {
                return SUB.commonType(l, r);
            }

            @Override
            @Nullable
            public Code code(Type l, Type r) {
                return (Code)div.get(l.getKind());
            }
        }
        ,
        MOD("%"){

            @Override
            @Nullable
            public Code code(Type l, Type r) {
                return (Code)mod.get(l.getKind());
            }

            @Override
            Type commonType(Type l, Type r) {
                return SUB.commonType(l, r);
            }
        }
        ,
        MUL("*"){

            @Override
            @Nullable
            public Code code(Type l, Type r) {
                return (Code)mul.get(l.getKind());
            }

            @Override
            Type commonType(Type l, Type r) {
                return SUB.commonType(l, r);
            }
        }
        ,
        AND("&&", Instruction.AND){

            @Override
            public Type returnType(Type l, Type r) {
                return l == Types.booleanType() && r == Types.booleanType() ? Types.booleanType() : null;
            }
        }
        ,
        OR("||", Instruction.OR){

            @Override
            public Type returnType(Type l, Type r) {
                return AND.returnType(l, r);
            }
        }
        ,
        EQ("==", Instruction.EQ){

            @Override
            @Nullable
            public Code code(Type l, Type r) {
                return l.isNumber() && r.isNumber() ? Instruction.EQ_NUM : super.code(l, r);
            }

            @Override
            public Type returnType(Type l, Type r) {
                return Types.booleanType();
            }
        }
        ,
        LE("<=", Instruction.LE){

            @Override
            public Type returnType(Type l, Type r) {
                return Types.booleanType();
            }
        }
        ,
        GE(">=", Instruction.GE){

            @Override
            public Type returnType(Type l, Type r) {
                return Types.booleanType();
            }
        }
        ,
        NE("!=", Instruction.NE){

            @Override
            @Nullable
            public Code code(Type l, Type r) {
                return l.isNumber() && r.isNumber() ? Instruction.NE_NUM : super.code(l, r);
            }

            @Override
            public Type returnType(Type l, Type r) {
                return Types.booleanType();
            }
        }
        ,
        GT(">", Instruction.GT){

            @Override
            public Type returnType(Type l, Type r) {
                return Types.booleanType();
            }
        }
        ,
        LT("<", Instruction.LT){

            @Override
            public Type returnType(Type l, Type r) {
                return Types.booleanType();
            }
        };

        private final Instruction instruction;
        private final String text;
        private static final EnumMap<Kind, Instruction> add;
        private static final EnumMap<Kind, Instruction> sub;
        private static final EnumMap<Kind, Instruction> subDate;
        private static final EnumMap<Kind, Instruction> subTime;
        private static final EnumMap<Kind, Instruction> mul;
        private static final EnumMap<Kind, Instruction> div;
        private static final EnumMap<Kind, Instruction> mod;

        private Operator(String s) {
            this(s, (Instruction)null);
        }

        private Operator(String s, Instruction instruction) {
            this.text = s;
            this.instruction = instruction;
        }

        public String toString() {
            return this.text;
        }

        Code code(Type l, Type r) {
            return (Code)Predefined.ensureNotNull((Object)this.instruction);
        }

        Type commonType(Type l, Type r) {
            return l.equivalent(r) ? l : l.commonSuperType(r);
        }

        Type returnType(Type leftOp, Type rightOp) {
            return leftOp.isTime() && rightOp.isTime() ? Types.intType() : leftOp;
        }

        boolean isArithmetic() {
            return this == ADD || this == SUB || this == DIV || this == MOD || this == MUL;
        }

        static {
            add = Maps.enumMap((Tuple)Tuple.tuple((Object)Kind.INT, (Object)Instruction.ADD_INT), (Tuple[])new Tuple[]{Tuple.tuple((Object)Kind.REAL, (Object)Instruction.ADD_REAL), Tuple.tuple((Object)Kind.DECIMAL, (Object)Instruction.ADD_DEC), Tuple.tuple((Object)Kind.STRING, (Object)Instruction.CAT), Tuple.tuple((Object)Kind.DATE, (Object)Instruction.ADD_DATE_INT), Tuple.tuple((Object)Kind.DATE_TIME, (Object)Instruction.ADD_TIME_INT)});
            sub = Maps.enumMap((Tuple)Tuple.tuple((Object)Kind.INT, (Object)Instruction.SUB_INT), (Tuple[])new Tuple[]{Tuple.tuple((Object)Kind.REAL, (Object)Instruction.SUB_REAL), Tuple.tuple((Object)Kind.DECIMAL, (Object)Instruction.SUB_DEC), Tuple.tuple((Object)Kind.DATE, (Object)Instruction.SUB_DATE_INT)});
            subDate = Maps.enumMap((Tuple)Tuple.tuple((Object)Kind.INT, (Object)Instruction.SUB_DATE_INT), (Tuple[])new Tuple[]{Tuple.tuple((Object)Kind.DATE, (Object)Instruction.SUB_DATE)});
            subTime = Maps.enumMap((Tuple)Tuple.tuple((Object)Kind.INT, (Object)Instruction.SUB_TIME_INT), (Tuple[])new Tuple[]{Tuple.tuple((Object)Kind.DATE_TIME, (Object)Instruction.SUB_TIME)});
            mul = Maps.enumMap((Tuple)Tuple.tuple((Object)Kind.INT, (Object)Instruction.MULT_INT), (Tuple[])new Tuple[]{Tuple.tuple((Object)Kind.REAL, (Object)Instruction.MULT_REAL), Tuple.tuple((Object)Kind.DECIMAL, (Object)Instruction.MULT_DEC)});
            div = Maps.enumMap((Tuple)Tuple.tuple((Object)Kind.INT, (Object)Instruction.DIV_INT), (Tuple[])new Tuple[]{Tuple.tuple((Object)Kind.REAL, (Object)Instruction.DIV_REAL), Tuple.tuple((Object)Kind.DECIMAL, (Object)Instruction.DIV_DEC)});
            mod = Maps.enumMap((Tuple)Tuple.tuple((Object)Kind.INT, (Object)Instruction.MOD_INT), (Tuple[])new Tuple[0]);
        }
    }
}

