/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.expr;

import java.util.EnumMap;
import java.util.function.Supplier;
import mulesoft.code.Code;
import mulesoft.code.FunctionCall;
import mulesoft.code.Instruction;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Maps;
import mulesoft.common.core.Option;
import mulesoft.common.core.Suppliers;
import mulesoft.common.core.Tuple;
import mulesoft.expr.ExpressionAST;
import mulesoft.expr.Ref;
import mulesoft.expr.RefTypeSolver;
import mulesoft.expr.UnaryExpression;
import mulesoft.expr.exception.IllegalOperationException;
import mulesoft.expr.visitor.ExpressionVisitor;
import mulesoft.type.DecimalType;
import mulesoft.type.EnumType;
import mulesoft.type.IntType;
import mulesoft.type.Kind;
import mulesoft.type.Type;
import mulesoft.type.Types;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConversionOp
extends UnaryExpression {
    private Option<Integer> scale = Option.empty();
    private static final EnumMap<Kind, Instruction> fromString = Maps.enumMap((Tuple)Tuple.tuple((Object)Kind.BOOLEAN, (Object)Instruction.STR_TO_BOOL), (Tuple[])new Tuple[]{Tuple.tuple((Object)Kind.DATE_TIME, (Object)Instruction.STR_TO_TIME), Tuple.tuple((Object)Kind.DATE, (Object)Instruction.STR_TO_DATE), Tuple.tuple((Object)Kind.REAL, (Object)Instruction.STR_TO_REAL), Tuple.tuple((Object)Kind.INT, (Object)Instruction.STR_TO_INT), Tuple.tuple((Object)Kind.DECIMAL, (Object)Instruction.STR_TO_DEC)});

    protected ConversionOp(ExpressionAST e, Supplier<Type> type) {
        super(UnaryExpression.Operator.CAST, e, type);
    }

    ConversionOp(Type type, ExpressionAST e) {
        this(e, (Supplier<Type>)Suppliers.fromObject((Object)type));
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    @NotNull
    public ExpressionAST solveType(@NotNull RefTypeSolver refResolver) {
        Type target = this.getTargetType();
        if (target.isEnum()) {
            this.operand = this.operand.solveEnumRef((EnumType)target);
        } else if (target.isArray() && this.operand instanceof Ref) {
            ((Ref)this.operand).setCol(true);
        }
        Type opType = this.operand.solveType(refResolver).getType();
        return this.conversionNeeded(opType) ? super.solveType(refResolver) : this.operand;
    }

    @Override
    public String toString() {
        return this.conversionNeeded(this.operand.getType()) ? super.toString() : this.operand.toString();
    }

    @Override
    public String getName() {
        return this.getTargetKind().getText();
    }

    public Option<Integer> getScale() {
        return this.scale;
    }

    public boolean isImplicit() {
        Type sourceType = this.getOperand().getType();
        Kind kind = sourceType.getKind();
        switch (this.getTargetKind()) {
            case STRING: {
                return true;
            }
            case REAL: {
                return kind == Kind.INT || kind == Kind.DECIMAL;
            }
            case DECIMAL: {
                return kind == Kind.INT || kind == Kind.REAL;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public Type getTargetType() {
        return ((Type)Predefined.notNull((Object)super.getTargetType(), (Object)Types.anyType())).getFinalType();
    }

    protected boolean conversionNeeded(Type opType) {
        return this.getTargetKind() != Kind.ANY && !opType.equivalent(this.getTargetType());
    }

    @Override
    @NotNull
    protected Type doSolveType(@NotNull RefTypeSolver refResolver) {
        Type opType = this.getOperand().solveType(refResolver).getType();
        Type t = this.getTargetType();
        this.instruction = this.findInstruction(opType, t);
        if (this.instruction == null) {
            throw new IllegalOperationException(this, t, this.getOperand().getType());
        }
        return t;
    }

    protected Kind getTargetKind() {
        return this.getTargetType().getKind();
    }

    @Nullable
    private Code findInstruction(Type sourceType, Type target) {
        if (sourceType.isString()) {
            return (Code)fromString.get(target.getKind());
        }
        Kind sourceKind = sourceType.getKind();
        switch (target.getKind()) {
            case STRING: {
                return sourceKind == Kind.DATE ? Instruction.TO_DATE_STR : (sourceKind == Kind.DATE_TIME ? Instruction.TO_TIME_STR : Instruction.TO_STR);
            }
            case REAL: {
                return sourceKind == Kind.INT ? Instruction.INT_TO_REAL : (sourceKind == Kind.DECIMAL ? Instruction.DEC_TO_REAL : null);
            }
            case INT: {
                return ((IntType)target).isLong() ? this.toLong(sourceKind) : this.toInt(sourceKind);
            }
            case DECIMAL: {
                if (sourceKind == Kind.DECIMAL) {
                    this.scale = Option.some((Object)((DecimalType)target).getDecimals());
                    return new FunctionCall("scale");
                }
                return sourceKind == Kind.INT ? Instruction.INT_TO_DEC : (sourceKind == Kind.REAL ? Instruction.REAL_TO_DEC : null);
            }
            case DATE_TIME: {
                return sourceKind == Kind.DATE ? Instruction.DATE_TO_DATE_TIME : null;
            }
            case DATE: {
                return sourceKind == Kind.DATE_TIME ? Instruction.DATE_TIME_TO_DATE : null;
            }
            case TYPE: {
                return this.findInstruction(sourceType, target.getFinalType());
            }
        }
        return null;
    }

    @Nullable
    private Instruction toInt(Kind sourceKind) {
        return sourceKind == Kind.REAL ? Instruction.REAL_TO_INT : (sourceKind == Kind.DECIMAL ? Instruction.DEC_TO_INT : null);
    }

    @Nullable
    private Code toLong(Kind sourceKind) {
        return sourceKind == Kind.REAL ? Instruction.REAL_TO_LONG : (sourceKind == Kind.DECIMAL ? Instruction.DEC_TO_LONG : (sourceKind == Kind.INT ? Instruction.INT_TO_LONG : null));
    }

    @Nullable
    public static ConversionOp fromTypeName(String name, @NotNull ExpressionAST operand) {
        Type type = Types.fromString((String)name);
        return type == Types.nullType() ? null : new ConversionOp(type, operand);
    }
}

