/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.expr;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import mulesoft.code.Binder;
import mulesoft.code.Code;
import mulesoft.code.Evaluator;
import mulesoft.common.Predefined;
import mulesoft.common.core.Option;
import mulesoft.common.core.Suppliers;
import mulesoft.common.serializer.StreamWriter;
import mulesoft.expr.Expression;
import mulesoft.expr.RefContextMapper;
import mulesoft.expr.RefTypeSolver;
import mulesoft.expr.exception.IllegalOperationException;
import mulesoft.expr.visitor.CodeGeneratorVisitor;
import mulesoft.expr.visitor.ExpressionVisitor;
import mulesoft.expr.visitor.ToStringVisitor;
import mulesoft.type.EnumType;
import mulesoft.type.Type;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExpressionAST {
    protected Supplier<Type> targetType;
    @Nullable
    Code instruction;
    @Nullable
    private Type type = null;
    @NonNls
    private static final String ILLEGAL_NULL_VALUE = "Null value. Do you forget to call solveType?";

    ExpressionAST() {
        this.instruction = null;
        this.targetType = Suppliers.empty();
    }

    ExpressionAST(@Nullable Code i, Supplier<Type> targetType) {
        this.instruction = i;
        this.targetType = targetType;
    }

    public abstract <T> T accept(ExpressionVisitor<T> var1);

    public abstract void acceptOperands(ExpressionVisitor<?> var1);

    public Expression createExpression() {
        return new Expression((Expression.Implementation)new Implementation(this));
    }

    @NotNull
    public ExpressionAST solveType(@NotNull RefTypeSolver refResolver) {
        if (this.type == null) {
            this.type = this.doSolveType(refResolver);
        }
        return this;
    }

    public String toString() {
        return ToStringVisitor.generate(this);
    }

    @NotNull
    public final Code getCode() {
        return (Code)Predefined.ensureNotNull((Object)this.instruction, (String)ILLEGAL_NULL_VALUE);
    }

    public abstract String getName();

    @Nullable
    public Type getTargetType() {
        return this.targetType.get();
    }

    @NotNull
    public Type getType() {
        return (Type)Predefined.ensureNotNull((Object)this.type, (String)ILLEGAL_NULL_VALUE);
    }

    @NotNull
    protected abstract Type doSolveType(RefTypeSolver var1);

    void solve(RefTypeSolver refResolver, Type expectedType) {
        Type c = this.solveType(refResolver).getType();
        if (!c.equals(expectedType)) {
            throw new IllegalOperationException(this, expectedType, c);
        }
    }

    @NotNull
    ExpressionAST solveEnumRef(EnumType enumType) {
        this.setTargetType((Type)enumType);
        return this;
    }

    void setTargetType(@Nullable Type t) {
        if (t != null && this.targetType.get() == null) {
            this.targetType = Suppliers.fromObject((Object)t);
        }
    }

    public static <T> T accept(Expression expression, ExpressionVisitor<T> visitor) {
        Expression.Implementation impl = expression.getImplementation();
        if (!(impl instanceof Implementation)) {
            throw new IllegalStateException("AST not present. Cannot be visited");
        }
        return ((Implementation)impl).ast.accept(visitor);
    }

    private static class Implementation
    implements Expression.Implementation {
        @NotNull
        private final ExpressionAST ast;
        @Nullable
        private Expression.Implementation compiledExpression;

        public Implementation(@NotNull ExpressionAST expressionAST) {
            this.ast = expressionAST;
            this.compiledExpression = null;
        }

        public void bind(Binder binder) {
            if (this.compiledExpression == null) {
                throw new IllegalStateException("Attempting to bind a not compiled Expression: " + this.ast);
            }
            this.getCompiled().bind(binder);
        }

        public void compile(RefTypeSolver solver) {
            if (this.compiledExpression == null) {
                this.compiledExpression = CodeGeneratorVisitor.compile(this.ast, solver);
            }
        }

        public Object evaluate(@NotNull Evaluator evaluator, Object context) {
            return this.getCompiled().evaluate(evaluator, context);
        }

        public List<String> extractStrings() {
            return this.getCompiled().extractStrings();
        }

        public Expression.Implementation reMapReferences(RefContextMapper mapper) {
            this.compiledExpression = CodeGeneratorVisitor.compile(this.ast, mapper);
            return this;
        }

        public Expression.Implementation replaceStrings(List<String> strings) {
            return this.getCompiled().replaceStrings(strings);
        }

        public Collection<String> retrieveReferences() {
            return this.getCompiled().retrieveReferences();
        }

        public void serialize(StreamWriter w) {
            this.getCompiled().serialize(w);
        }

        public String toString() {
            return this.ast.toString();
        }

        public Option<Object> getConstantValue() {
            return this.getCompiled().getConstantValue();
        }

        public boolean isCompiled() {
            return this.compiledExpression != null;
        }

        public boolean isConstant() {
            return this.isCompiled() && this.getCompiled().isConstant();
        }

        public Type getType() {
            return this.getCompiled().getType();
        }

        @NotNull
        private Expression.Implementation getCompiled() {
            if (this.compiledExpression == null) {
                throw new IllegalStateException("Expression was not compiled: " + this.ast);
            }
            return this.compiledExpression;
        }
    }
}

