/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.expr;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mulesoft.code.Fun;
import mulesoft.code.FunctionRegistry;
import mulesoft.common.annotation.GwtIncompatible;
import mulesoft.common.collections.ImmutableList;
import mulesoft.expr.BinaryExpression;
import mulesoft.expr.ConversionOp;
import mulesoft.expr.ExpressionAST;
import mulesoft.expr.ForbiddenExpression;
import mulesoft.expr.FunctionCallNode;
import mulesoft.expr.IfExpression;
import mulesoft.expr.Ref;
import mulesoft.expr.UnaryExpression;
import mulesoft.expr.Value;
import mulesoft.type.EnumType;
import mulesoft.type.Type;
import mulesoft.type.Types;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionFactory {
    @GwtIncompatible
    private static final Pattern INTERPOLATION_PATTERN = Pattern.compile("(?<!\\$)\\$[A-Za-z][A-Za-z0-9_]*");
    private static final Value NULL_VALUE_EXPR = new ImmutableValue(null, (Type)Types.nullType());
    private static final Value TRUE_VALUE_EXPR = new ImmutableValue(true, (Type)Types.booleanType());
    private static final Value FALSE_VALUE_EXPR = new ImmutableValue(false, (Type)Types.booleanType());

    private ExpressionFactory() {
    }

    public static BinaryExpression add(ExpressionAST left, ExpressionAST right) {
        return new BinaryExpression(BinaryExpression.Operator.ADD, left, right);
    }

    public static BinaryExpression and(ExpressionAST left, ExpressionAST right) {
        return new BinaryExpression(BinaryExpression.Operator.AND, left, right);
    }

    public static UnaryExpression avg(ExpressionAST expr) {
        return new UnaryExpression(UnaryExpression.Operator.AVG, expr);
    }

    public static Value bool(Boolean value) {
        return value != false ? TRUE_VALUE_EXPR : FALSE_VALUE_EXPR;
    }

    public static Value boolArray(Boolean ... bool) {
        return new Value(ExpressionFactory.list(bool), (Type)Types.arrayType((Type)Types.booleanType()));
    }

    public static ExpressionAST conversion(ExpressionAST e, Type t) {
        return t.equivalent(e.getType()) ? e : new ConversionOp(t, e);
    }

    public static UnaryExpression count(ExpressionAST expr) {
        return new UnaryExpression(UnaryExpression.Operator.COUNT, expr);
    }

    public static Value dateArray(Date ... date) {
        return new Value(ExpressionFactory.list(date), (Type)Types.arrayType((Type)Types.dateType()));
    }

    public static Value decimal(BigDecimal value) {
        return new Value(value, (Type)Types.decimalType((int)value.precision()));
    }

    public static Value decimalArray(BigDecimal ... decimals) {
        return new Value(ExpressionFactory.list(decimals), (Type)Types.arrayType((Type)Types.decimalType((int)Integer.MAX_VALUE)));
    }

    public static FunctionCallNode defined(ExpressionAST expr) {
        return new FunctionCallNode("defined", expr);
    }

    public static BinaryExpression div(ExpressionAST left, ExpressionAST right) {
        return new BinaryExpression(BinaryExpression.Operator.DIV, left, right);
    }

    public static FunctionCallNode empty(ExpressionAST expr) {
        return new FunctionCallNode("empty", expr);
    }

    public static BinaryExpression eq(ExpressionAST left, ExpressionAST right) {
        return new BinaryExpression(BinaryExpression.Operator.EQ, left, right);
    }

    public static FunctionCallNode fn(String name, ExpressionAST ... args) {
        return new FunctionCallNode(name, args);
    }

    public static ExpressionAST forbidden(String permission) {
        return new ForbiddenExpression(permission);
    }

    public static BinaryExpression ge(ExpressionAST left, ExpressionAST right) {
        return new BinaryExpression(BinaryExpression.Operator.GE, left, right);
    }

    public static BinaryExpression gt(ExpressionAST left, ExpressionAST right) {
        return new BinaryExpression(BinaryExpression.Operator.GT, left, right);
    }

    public static Value intArray(Integer ... integers) {
        return new Value(ExpressionFactory.list(integers), (Type)Types.arrayType((Type)Types.intType()));
    }

    public static Value integer(int value) {
        return new Value(value, (Type)Types.intType());
    }

    public static BinaryExpression le(ExpressionAST left, ExpressionAST right) {
        return new BinaryExpression(BinaryExpression.Operator.LE, left, right);
    }

    public static BinaryExpression lt(ExpressionAST left, ExpressionAST right) {
        return new BinaryExpression(BinaryExpression.Operator.LT, left, right);
    }

    public static UnaryExpression max(ExpressionAST expr) {
        return new UnaryExpression(UnaryExpression.Operator.MAX, expr);
    }

    public static UnaryExpression min(ExpressionAST expr) {
        return new UnaryExpression(UnaryExpression.Operator.MIN, expr);
    }

    public static BinaryExpression mod(ExpressionAST left, ExpressionAST right) {
        return new BinaryExpression(BinaryExpression.Operator.MOD, left, right);
    }

    public static BinaryExpression mul(ExpressionAST left, ExpressionAST right) {
        return new BinaryExpression(BinaryExpression.Operator.MUL, left, right);
    }

    public static BinaryExpression ne(ExpressionAST left, ExpressionAST right) {
        return new BinaryExpression(BinaryExpression.Operator.NE, left, right);
    }

    public static UnaryExpression not(ExpressionAST expr) {
        return new UnaryExpression(UnaryExpression.Operator.NOT, expr);
    }

    public static Value nullValue() {
        return NULL_VALUE_EXPR;
    }

    public static BinaryExpression or(ExpressionAST left, ExpressionAST right) {
        return new BinaryExpression(BinaryExpression.Operator.OR, left, right);
    }

    public static Value real(Double value) {
        return new Value(value, (Type)Types.realType());
    }

    public static Value realArray(Double ... doubles) {
        return new Value(ExpressionFactory.list(doubles), (Type)Types.arrayType((Type)Types.realType()));
    }

    public static Ref ref(String reference) {
        return new Ref(reference);
    }

    public static void registerFn(Fun<?> fun) {
        FunctionRegistry.getInstance().register(fun);
    }

    public static UnaryExpression rows(ExpressionAST expr) {
        return new UnaryExpression(UnaryExpression.Operator.ROWS, expr);
    }

    public static FunctionCallNode scale(ExpressionAST arg, int scale) {
        return ExpressionFactory.fn("scale", arg, ExpressionFactory.integer(scale));
    }

    public static UnaryExpression size(ExpressionAST expr) {
        return new UnaryExpression(UnaryExpression.Operator.SIZE, expr);
    }

    @GwtIncompatible
    public static ExpressionAST str(String value) {
        if (!ExpressionFactory.isInterpolation(value)) {
            return ExpressionFactory.value(ExpressionFactory.replaceDuplicates(value));
        }
        ImmutableList references = ImmutableList.build(b -> {
            Matcher matcher = INTERPOLATION_PATTERN.matcher(value);
            int start = 0;
            while (matcher.find()) {
                b.add((Object)ExpressionFactory.value(ExpressionFactory.replaceDuplicates(value.substring(start, matcher.start()))));
                b.add((Object)ExpressionFactory.ref(matcher.group().substring(1)));
                start = matcher.end();
            }
            b.add((Object)ExpressionFactory.value(ExpressionFactory.replaceDuplicates(value.substring(start))));
        });
        return (ExpressionAST)references.reduce(ExpressionFactory::add);
    }

    public static Value strArray(String ... str) {
        return new Value(ExpressionFactory.list(str), (Type)Types.arrayType((Type)Types.stringType()));
    }

    public static BinaryExpression sub(ExpressionAST left, ExpressionAST right) {
        return new BinaryExpression(BinaryExpression.Operator.SUB, left, right);
    }

    public static UnaryExpression sum(ExpressionAST expr) {
        return new UnaryExpression(UnaryExpression.Operator.SUM, expr);
    }

    public static Value value(String value) {
        return new Value(value, (Type)Types.stringType((int)value.length()));
    }

    public static Value value(Type type, Object value) {
        return new Value(value, type);
    }

    public static IfExpression wildcard(ExpressionAST condition, ExpressionAST trueExpr, ExpressionAST falseExpr) {
        return new IfExpression(condition, trueExpr, falseExpr);
    }

    @GwtIncompatible
    public static boolean isInterpolation(@NotNull String str) {
        return INTERPOLATION_PATTERN.matcher(str).find();
    }

    private static <T> ArrayList<T> list(T[] array) {
        return new ArrayList<T>(Arrays.asList(array));
    }

    private static String replaceDuplicates(String value) {
        return value.replaceAll("\\$\\$", "\\$");
    }

    private static class ImmutableValue
    extends Value {
        public ImmutableValue(Object o, Type type) {
            super(o, type);
        }

        @Override
        @NotNull
        ExpressionAST solveEnumRef(EnumType enumType) {
            return this;
        }

        @Override
        void setTargetType(@Nullable Type t) {
            throw new RuntimeException("Should not be called");
        }
    }
}

