/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.expr;

import mulesoft.code.Code;
import mulesoft.code.Instruction;
import mulesoft.common.core.Suppliers;
import mulesoft.expr.ExpressionAST;
import mulesoft.expr.RefPermissionSolver;
import mulesoft.expr.RefTypeSolver;
import mulesoft.expr.exception.IllegalOperationException;
import mulesoft.expr.visitor.ExpressionVisitor;
import mulesoft.type.Type;
import mulesoft.type.Types;
import org.jetbrains.annotations.NotNull;

public class ForbiddenExpression
extends ExpressionAST {
    @NotNull
    private final String permission;

    public ForbiddenExpression(@NotNull String permission) {
        super((Code)Instruction.FORBIDDEN, Suppliers.fromObject((Object)Types.booleanType()));
        this.permission = permission;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public final void acceptOperands(ExpressionVisitor<?> visitor) {
        visitor.visit(this);
    }

    @Override
    public String getName() {
        return Instruction.FORBIDDEN.name().toLowerCase();
    }

    @NotNull
    public String getPermission() {
        return this.permission;
    }

    @Override
    @NotNull
    protected Type doSolveType(RefTypeSolver refResolver) {
        this.doSolvePermissionRef(refResolver);
        return Types.booleanType();
    }

    private void doSolvePermissionRef(RefTypeSolver refResolver) {
        if (!(refResolver instanceof RefPermissionSolver)) {
            throw new IllegalOperationException(this, "The 'forbidden' operation can only be used inside Forms.");
        }
        if (!((RefPermissionSolver)refResolver).hasPermission(this.permission)) {
            throw new IllegalOperationException(this, "Permission '" + this.permission + "' not declared on form.");
        }
    }
}

