/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.expr;

import java.util.Arrays;
import java.util.List;
import mulesoft.code.Fun;
import mulesoft.code.FunctionRegistry;
import mulesoft.expr.ExpressionAST;
import mulesoft.expr.RefTypeSolver;
import mulesoft.expr.exception.IllegalOperationException;
import mulesoft.expr.visitor.ExpressionVisitor;
import mulesoft.type.Type;
import org.jetbrains.annotations.NotNull;

public class FunctionCallNode
extends ExpressionAST {
    private final List<ExpressionAST> arguments;
    private Fun<?> function;
    private final String name;

    public FunctionCallNode(String name, List<ExpressionAST> arguments) {
        this.name = name;
        this.arguments = arguments;
        this.function = null;
    }

    FunctionCallNode(String name, ExpressionAST ... expressions) {
        this(name, Arrays.asList(expressions));
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void acceptOperands(ExpressionVisitor<?> visitor) {
        for (ExpressionAST expr : this.arguments) {
            expr.accept(visitor);
        }
    }

    public boolean canBeConstant() {
        return this.function.canBeConstant();
    }

    public Object execute(Object ... args) {
        return this.function.invoke(args);
    }

    public List<ExpressionAST> getArguments() {
        return this.arguments;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    protected Type doSolveType(@NotNull RefTypeSolver refResolver) {
        Type[] argTypes = this.solveArgumentTypes(refResolver);
        Fun found = null;
        for (Fun fun : FunctionRegistry.getInstance().functions()) {
            if (!fun.getName().equals(this.name)) continue;
            found = fun;
            if (!this.argumentsMatch(fun, argTypes)) continue;
            this.function = fun;
            return this.function.getReturnType();
        }
        throw new IllegalOperationException(this, found, argTypes);
    }

    private boolean argumentsMatch(Fun<?> fun, Type[] argTypes) {
        Type[] types = fun.getArgTypes();
        if (types.length != argTypes.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (argTypes[i].equivalent(types[i])) continue;
            return false;
        }
        return true;
    }

    private Type[] solveArgumentTypes(RefTypeSolver refResolver) {
        Type[] argTypes = new Type[this.arguments.size()];
        int i = 0;
        for (ExpressionAST a : this.arguments) {
            argTypes[i++] = a.solveType(refResolver).getType();
        }
        return argTypes;
    }
}

