/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.expr;

import mulesoft.code.Code;
import mulesoft.code.Instruction;
import mulesoft.common.core.Suppliers;
import mulesoft.expr.ExpressionAST;
import mulesoft.expr.ExpressionFactory;
import mulesoft.expr.RefTypeSolver;
import mulesoft.expr.exception.IllegalOperationException;
import mulesoft.expr.visitor.ExpressionVisitor;
import mulesoft.type.EnumType;
import mulesoft.type.Type;
import mulesoft.type.Types;
import org.jetbrains.annotations.NotNull;

public class IfExpression
extends ExpressionAST {
    @NotNull
    private final ExpressionAST cond;
    @NotNull
    private ExpressionAST falseExpr;
    @NotNull
    private ExpressionAST trueExpr;

    public IfExpression(@NotNull ExpressionAST cond, @NotNull ExpressionAST trueExpr, @NotNull ExpressionAST falseExpr) {
        super((Code)Instruction.IF, Suppliers.empty());
        this.cond = cond;
        this.trueExpr = trueExpr;
        this.falseExpr = falseExpr;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public <T> T acceptCondition(ExpressionVisitor<T> visitor) {
        return this.cond.accept(visitor);
    }

    public <T> T acceptElse(ExpressionVisitor<T> visitor) {
        return this.falseExpr.accept(visitor);
    }

    @Override
    public void acceptOperands(ExpressionVisitor<?> visitor) {
        this.acceptCondition(visitor);
        this.acceptThen(visitor);
        this.acceptElse(visitor);
    }

    public <T> T acceptThen(ExpressionVisitor<T> visitor) {
        return this.trueExpr.accept(visitor);
    }

    @Override
    public String getName() {
        return "if";
    }

    @Override
    @NotNull
    protected Type doSolveType(RefTypeSolver refResolver) {
        Type b;
        Type a;
        this.cond.solve(refResolver, (Type)Types.booleanType());
        Type target = this.getTargetType();
        if (target instanceof EnumType) {
            EnumType et = (EnumType)target;
            this.trueExpr = this.trueExpr.solveEnumRef(et);
            this.falseExpr = this.falseExpr.solveEnumRef(et);
        }
        if (!(a = this.trueExpr.solveType(refResolver).getType()).equivalent(b = this.falseExpr.solveType(refResolver).getType())) {
            Type t = a.commonSuperType(b);
            if (t == Types.anyType()) {
                throw new IllegalOperationException(this.falseExpr, a, b);
            }
            this.trueExpr = ExpressionFactory.conversion(this.trueExpr, t).solveType(refResolver);
            this.falseExpr = ExpressionFactory.conversion(this.falseExpr, t).solveType(refResolver);
        }
        return this.trueExpr.getType();
    }
}

