/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.expr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mulesoft.expr.AssignmentExpression;
import mulesoft.expr.ExpressionAST;
import mulesoft.expr.RefTypeSolver;
import mulesoft.expr.exception.IllegalOperationException;
import mulesoft.expr.visitor.ExpressionVisitor;
import mulesoft.type.EnumType;
import mulesoft.type.Kind;
import mulesoft.type.Type;
import mulesoft.type.Types;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListExpression
extends ExpressionAST
implements Iterable<ExpressionAST> {
    private final List<ExpressionAST> expressions = new ArrayList<ExpressionAST>();
    private Type listType = null;

    public ListExpression(@Nullable Type listType) {
        this.listType = listType;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void acceptOperands(ExpressionVisitor<?> visitor) {
        for (ExpressionAST expr : this.expressions) {
            expr.acceptOperands(visitor);
        }
    }

    public void add(ExpressionAST expressionAST) {
        this.expressions.add(expressionAST);
    }

    @Override
    public Iterator<ExpressionAST> iterator() {
        return this.expressions.iterator();
    }

    @Override
    @NotNull
    public ExpressionAST solveType(@NotNull RefTypeSolver refResolver) {
        for (ExpressionAST expr : this.expressions) {
            expr.solveType(refResolver);
        }
        return super.solveType(refResolver);
    }

    @Override
    public String getName() {
        return "list";
    }

    public int getSize() {
        return this.expressions.size();
    }

    @Override
    @NotNull
    protected Type doSolveType(RefTypeSolver refResolver) {
        Type type = this.listType;
        for (ExpressionAST expr : this.expressions) {
            Type nextType = expr.doSolveType(refResolver);
            if (type == null) {
                type = nextType;
                continue;
            }
            if (AssignmentExpression.hasValidType(nextType, type) || type.getKind() == Kind.ANY) continue;
            throw new IllegalOperationException(expr, type, nextType);
        }
        if (type == null) {
            throw new IllegalOperationException(this);
        }
        return Types.arrayType((Type)type);
    }

    void replace(ExpressionAST expr, ExpressionAST solvedExpr) {
        this.expressions.set(this.expressions.indexOf(expr), solvedExpr);
    }

    Type getListType() {
        return this.listType;
    }

    public static class AssignmentListExpression
    extends ListExpression {
        private final Type assignmentType;
        private final boolean checkSameType;

        public AssignmentListExpression(@Nullable Type listType, @Nullable Type assignmentType, boolean sameType) {
            super(listType);
            this.assignmentType = assignmentType;
            this.checkSameType = sameType;
        }

        @Override
        @NotNull
        public ExpressionAST solveType(@NotNull RefTypeSolver refResolver) {
            for (ExpressionAST expr : this) {
                if (expr instanceof AssignmentExpression && this.assignmentType != null) {
                    expr.setTargetType(this.assignmentType);
                }
                expr.solveType(refResolver);
            }
            return super.solveType(refResolver);
        }

        @Override
        @NotNull
        protected Type doSolveType(RefTypeSolver refResolver) {
            if (this.checkSameType) {
                return super.doSolveType(refResolver);
            }
            for (ExpressionAST expr : this) {
                expr.doSolveType(refResolver);
            }
            return Types.arrayType((Type)Types.anyType());
        }

        @Override
        @NotNull
        ExpressionAST solveEnumRef(EnumType enumType) {
            for (ExpressionAST expr : this) {
                this.replace(expr, expr.solveEnumRef(enumType));
            }
            return this;
        }
    }
}

