/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.expr;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mulesoft.code.Instruction;
import mulesoft.common.collections.Maps;
import mulesoft.common.core.Suppliers;
import mulesoft.common.core.Tuple;
import mulesoft.expr.ConversionOp;
import mulesoft.expr.ExpressionAST;
import mulesoft.expr.Ref;
import mulesoft.expr.RefTypeSolver;
import mulesoft.expr.exception.IllegalOperationException;
import mulesoft.expr.visitor.ExpressionVisitor;
import mulesoft.type.Kind;
import mulesoft.type.Type;
import mulesoft.type.Types;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnaryExpression
extends ExpressionAST {
    @NotNull
    ExpressionAST operand;
    @NotNull
    private final Operator operator;
    private static final Map<String, Operator> idToEnum = new HashMap<String, Operator>();

    public UnaryExpression(@NotNull Operator operator, @NotNull ExpressionAST operand) {
        this(operator, operand, Suppliers.empty());
    }

    UnaryExpression(@NotNull Operator operator, @NotNull ExpressionAST operand, @NotNull Supplier<Type> targetType) {
        super(null, targetType);
        this.operand = operand;
        this.operator = operator;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public final <T> T acceptOperand(ExpressionVisitor<T> visitor) {
        return this.operand.accept(visitor);
    }

    @Override
    public final void acceptOperands(ExpressionVisitor<?> visitor) {
        this.acceptOperand(visitor);
    }

    @Override
    public String getName() {
        return this.operator.toString();
    }

    @NotNull
    public ExpressionAST getOperand() {
        return this.operand;
    }

    @Override
    @NotNull
    protected Type doSolveType(RefTypeSolver refResolver) {
        Type retType;
        if (this.operator.isAggregate() && this.operand instanceof Ref) {
            ((Ref)this.operand).setCol(true);
        }
        Type t = this.operand.solveType(refResolver).getType();
        if (this.operator.isAggregate()) {
            t = Types.elementType((Type)t);
        }
        if ((retType = this.operator.returnType(t)) == null) {
            throw new IllegalOperationException(this);
        }
        this.instruction = this.operator.code(t);
        if (this.instruction == null) {
            throw new IllegalOperationException(this);
        }
        return retType;
    }

    @Nullable
    public static UnaryExpression fromId(String name, @NotNull ExpressionAST operand) {
        Operator op = idToEnum.get(name);
        return op == null ? ConversionOp.fromTypeName(name, operand) : new UnaryExpression(op, operand);
    }

    static {
        for (Operator op : Operator.values()) {
            idToEnum.put(op.getId(), op);
        }
    }

    public static enum Operator {
        MINUS("-", false){

            @Override
            Instruction code(Type t) {
                return (Instruction)minus.get(t.getKind());
            }
        }
        ,
        PLUS("+", false){

            @Override
            Instruction code(Type t) {
                return Instruction.NOP;
            }
        }
        ,
        NOT("!", false){

            @Override
            Instruction code(Type t) {
                return t == Types.booleanType() ? Instruction.NOT : null;
            }
        }
        ,
        SIZE("size", false){

            @Override
            Instruction code(Type t) {
                return Instruction.SIZE;
            }

            @Override
            Type returnType(Type t) {
                return Types.intType();
            }
        }
        ,
        SUM("sum", true){

            @Override
            Instruction code(Type t) {
                return (Instruction)sum.get(t.getKind());
            }

            @Override
            Type returnType(Type t) {
                return t.isNumber() ? super.returnType(t) : Types.intType();
            }
        }
        ,
        AVG("avg", true){

            @Override
            Instruction code(Type t) {
                return (Instruction)avg.get(t.getKind());
            }
        }
        ,
        COUNT("count", true){

            @Override
            Instruction code(Type t) {
                return Instruction.COUNT;
            }

            @Override
            Type returnType(Type t) {
                return Types.intType();
            }
        }
        ,
        ROWS("rows", true){

            @Override
            Instruction code(Type t) {
                return Instruction.ROWS;
            }

            @Override
            Type returnType(Type t) {
                return Types.intType();
            }
        }
        ,
        MIN("min", true){

            @Override
            Instruction code(Type t) {
                return Instruction.MIN;
            }
        }
        ,
        MAX("max", true){

            @Override
            Instruction code(Type t) {
                return Instruction.MAX;
            }
        }
        ,
        CAST("cast", false){

            @Override
            Instruction code(Type t) {
                return Instruction.NOP;
            }
        };

        private final boolean aggregate;
        private final String text;
        private static final EnumMap<Kind, Instruction> sum;
        private static final EnumMap<Kind, Instruction> avg;
        private static final EnumMap<Kind, Instruction> minus;

        private Operator(String s, boolean b) {
            this.text = s;
            this.aggregate = b;
        }

        public String toString() {
            return this.text;
        }

        public String getId() {
            return this.text;
        }

        abstract Instruction code(Type var1);

        Type returnType(Type t) {
            return t;
        }

        boolean isAggregate() {
            return this.aggregate;
        }

        static {
            sum = Maps.enumMap((Tuple)Tuple.tuple((Object)Kind.BOOLEAN, (Object)Instruction.SUM_BOOL), (Tuple[])new Tuple[]{Tuple.tuple((Object)Kind.INT, (Object)Instruction.SUM_INT), Tuple.tuple((Object)Kind.REAL, (Object)Instruction.SUM_REAL), Tuple.tuple((Object)Kind.DECIMAL, (Object)Instruction.SUM_DEC)});
            avg = Maps.enumMap((Tuple)Tuple.tuple((Object)Kind.INT, (Object)Instruction.AVG_INT), (Tuple[])new Tuple[]{Tuple.tuple((Object)Kind.REAL, (Object)Instruction.AVG_REAL), Tuple.tuple((Object)Kind.DECIMAL, (Object)Instruction.AVG_DEC)});
            minus = Maps.enumMap((Tuple)Tuple.tuple((Object)Kind.INT, (Object)Instruction.MINUS_INT), (Tuple[])new Tuple[]{Tuple.tuple((Object)Kind.REAL, (Object)Instruction.MINUS_REAL), Tuple.tuple((Object)Kind.DECIMAL, (Object)Instruction.MINUS_DEC)});
        }
    }
}

