/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.expr.exception;

import mulesoft.code.Fun;
import mulesoft.common.core.StrBuilder;
import mulesoft.expr.BinaryExpression;
import mulesoft.expr.ExpressionAST;
import mulesoft.expr.ForbiddenExpression;
import mulesoft.expr.FunctionCallNode;
import mulesoft.expr.ListExpression;
import mulesoft.expr.UnaryExpression;
import mulesoft.type.Type;

public class IllegalOperationException
extends RuntimeException {
    private final ExpressionAST expr;
    private static final long serialVersionUID = -8646118348003236987L;

    public IllegalOperationException(BinaryExpression expr) {
        super(new MsgBuilder(expr).types(expr.getLeft().getType(), expr.getRight().getType()).build());
        this.expr = expr;
    }

    public IllegalOperationException(UnaryExpression expr) {
        super(new MsgBuilder(expr).types(expr.getOperand().getType()).build());
        this.expr = expr;
    }

    public IllegalOperationException(ListExpression expr) {
        super("List must contain at least one value");
        this.expr = expr;
    }

    public IllegalOperationException(ForbiddenExpression expr, String msg) {
        super(msg);
        this.expr = expr;
    }

    public IllegalOperationException(ExpressionAST expr, Type expected, Type found) {
        super("Incompatible types, required '" + expected + "' but found '" + found + "'");
        this.expr = expr;
    }

    public IllegalOperationException(FunctionCallNode expr, Fun<?> found, Type[] args) {
        super(new MsgBuilder(expr, found, args).build());
        this.expr = expr;
    }

    public String getErrorMessage() {
        return super.getMessage();
    }

    public ExpressionAST getExpr() {
        return this.expr;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + ", in expression " + this.expr;
    }

    private static class MsgBuilder {
        private final StrBuilder builder = new StrBuilder();

        private MsgBuilder(ExpressionAST expr) {
            this.builder.append("Operator '").append(expr.getName()).append("' can't be applied to ");
        }

        private MsgBuilder(FunctionCallNode expr, Fun<?> found, Type[] args) {
            this.builder.append("Function '").append(expr.getName()).append(found == null ? "' not found" : "' can't be applied to ");
            if (found != null) {
                this.types(args);
            }
        }

        public String build() {
            return this.builder.toString();
        }

        public MsgBuilder types(Type ... o) {
            this.builder.startCollection(",");
            for (Type t : o) {
                this.builder.appendElement((Object)"'").append((Object)t).append("'");
            }
            return this;
        }
    }
}

