/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.expr.visitor;

import java.util.ArrayList;
import java.util.List;
import mulesoft.code.Binder;
import mulesoft.code.Code;
import mulesoft.code.CompiledExpression;
import mulesoft.code.Constant;
import mulesoft.code.Evaluator;
import mulesoft.code.ForbiddenAccess;
import mulesoft.code.FunctionCall;
import mulesoft.code.Instruction;
import mulesoft.code.Jump;
import mulesoft.code.ListCode;
import mulesoft.code.ReadOnlyAccess;
import mulesoft.code.RefAccess;
import mulesoft.code.UpdateAccess;
import mulesoft.expr.AssignmentExpression;
import mulesoft.expr.BinaryExpression;
import mulesoft.expr.ConstantExpression;
import mulesoft.expr.ConversionOp;
import mulesoft.expr.Expression;
import mulesoft.expr.ExpressionAST;
import mulesoft.expr.ForbiddenExpression;
import mulesoft.expr.FunctionCallNode;
import mulesoft.expr.IfExpression;
import mulesoft.expr.ListExpression;
import mulesoft.expr.ReadOnlyExpression;
import mulesoft.expr.Ref;
import mulesoft.expr.RefContextMapper;
import mulesoft.expr.RefTypeSolver;
import mulesoft.expr.UnaryExpression;
import mulesoft.expr.UpdateExpression;
import mulesoft.expr.Value;
import mulesoft.expr.exception.IllegalOperationException;
import mulesoft.expr.visitor.ExpressionVisitor;
import mulesoft.type.Kind;
import mulesoft.type.Type;
import org.jetbrains.annotations.Nullable;

public class CodeGeneratorVisitor
extends ExpressionVisitor.Default<Boolean> {
    private final List<Code> code;
    private final RefContextMapper refMapper;

    private CodeGeneratorVisitor(RefContextMapper refMapper) {
        this.refMapper = refMapper;
        this.code = new ArrayList<Code>();
    }

    @Override
    public Boolean visit(Ref e) {
        if (e.isFilterRef()) {
            this.code((Code)new Constant(Kind.REFERENCE, (Object)e.getName()));
        } else {
            this.code((Code)new RefAccess(this.refMapper.doMap(e.getName()), e.isCol()));
        }
        return false;
    }

    @Override
    public Boolean visit(ForbiddenExpression e) {
        this.code((Code)new ForbiddenAccess(e.getPermission()));
        return false;
    }

    @Override
    public Boolean visit(UpdateExpression e) {
        this.code((Code)new UpdateAccess());
        return false;
    }

    @Override
    public Boolean visit(ReadOnlyExpression e) {
        this.code((Code)new ReadOnlyAccess());
        return false;
    }

    @Override
    public Boolean visit(Value e) {
        this.code((Code)new Constant(e.getType().getKind(), e.getValue()));
        return true;
    }

    @Override
    public Boolean visit(FunctionCallNode e) {
        boolean result = e.canBeConstant();
        for (ExpressionAST expr : e.getArguments()) {
            if (expr.accept(this).booleanValue()) continue;
            result = false;
        }
        this.code((Code)new FunctionCall(e.getName()));
        return result;
    }

    @Override
    public Boolean visit(BinaryExpression e) {
        boolean r;
        boolean l = e.acceptLeft(this);
        if (e.isShortCircuit()) {
            int instruction = this.reserve();
            r = e.acceptRight(this);
            this.code(instruction, (Code)new Jump(e.getCode(), this.currentAddress()));
        } else {
            r = e.acceptRight(this);
            this.code(e.getCode());
        }
        return l && r;
    }

    @Override
    public Boolean visit(IfExpression ifExpr) {
        boolean c = ifExpr.acceptCondition(this);
        int ifInstruction = this.reserve();
        boolean t = ifExpr.acceptThen(this);
        int elseInstruction = this.reserve();
        this.code(ifInstruction, (Code)new Jump((Code)Instruction.IF, this.currentAddress()));
        boolean e = ifExpr.acceptElse(this);
        this.code(elseInstruction, (Code)new Jump((Code)Instruction.ELSE, this.currentAddress()));
        return c && t && e;
    }

    @Override
    @Nullable
    public Boolean visit(ListExpression e) {
        boolean result = true;
        for (ExpressionAST expr : e) {
            result &= expr.accept(this).booleanValue();
        }
        this.code((Code)new ListCode(e.getSize()));
        return result;
    }

    @Override
    @Nullable
    public Boolean visit(AssignmentExpression e) {
        boolean result = e.getFieldExpr().accept(this) & e.getValueExpr().accept(this);
        if (e.hasWhen()) {
            result &= ((ExpressionAST)e.getWhenExpr().get()).accept(this).booleanValue();
        } else {
            this.code((Code)new Constant(Kind.BOOLEAN, (Object)true));
        }
        this.code((Code)new Constant(Kind.BOOLEAN, (Object)e.isEquals()));
        this.code(e.getCode());
        return result;
    }

    @Override
    public Boolean visit(UnaryExpression e) {
        boolean result = e.acceptOperand(this);
        this.code(e.getCode());
        return result;
    }

    @Override
    public Boolean visit(ConversionOp e) {
        boolean result = e.acceptOperand(this);
        if (e.getScale().isPresent()) {
            this.code((Code)new Constant(Kind.INT, e.getScale().get()));
        }
        this.code(e.getCode());
        return result;
    }

    private void code(Code op) {
        this.code.add(op);
    }

    private void code(int address, Code op) {
        this.code.set(address, op);
    }

    private int currentAddress() {
        return this.code.size();
    }

    private int reserve() {
        this.code.add(null);
        return this.code.size() - 1;
    }

    public static Expression.Implementation compile(ExpressionAST e, RefTypeSolver refResolver) {
        return CodeGeneratorVisitor.compile(e, RefContextMapper.none((RefTypeSolver)refResolver));
    }

    public static Expression.Implementation compile(ExpressionAST e, RefContextMapper refMapper) {
        CodeGeneratorVisitor visitor = new CodeGeneratorVisitor(refMapper);
        ExpressionAST expression = e.solveType((RefTypeSolver)refMapper);
        boolean constant = expression.accept(visitor);
        CompiledExpression c = new CompiledExpression(expression.getType(), visitor.code);
        return constant ? CodeGeneratorVisitor.createConstant(e, c) : c;
    }

    private static Expression.Implementation createConstant(ExpressionAST e, CompiledExpression c) {
        c.bind(Binder.EMPTY);
        try {
            Object result = c.evaluate(new Evaluator(), null);
            return ConstantExpression.createConstantExpression((Type)c.getType(), (Object)result);
        }
        catch (NumberFormatException constantConversionFailed) {
            ConversionOp conversion = (ConversionOp)e;
            throw new IllegalOperationException(conversion, conversion.getTargetType(), conversion.getOperand().getType());
        }
    }
}

