/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.expr.visitor;

import mulesoft.common.collections.Colls;
import mulesoft.common.core.StrBuilder;
import mulesoft.common.core.Strings;
import mulesoft.expr.AssignmentExpression;
import mulesoft.expr.BinaryExpression;
import mulesoft.expr.ConversionOp;
import mulesoft.expr.ExpressionAST;
import mulesoft.expr.ForbiddenExpression;
import mulesoft.expr.FunctionCallNode;
import mulesoft.expr.IfExpression;
import mulesoft.expr.ListExpression;
import mulesoft.expr.Ref;
import mulesoft.expr.UnaryExpression;
import mulesoft.expr.UpdateExpression;
import mulesoft.expr.Value;
import mulesoft.expr.visitor.ExpressionVisitor;
import org.jetbrains.annotations.Nullable;

public class ToStringVisitor
extends ExpressionVisitor.Default<String> {
    @Override
    public String visit(Ref e) {
        return e.getName();
    }

    @Override
    public String visit(Value e) {
        return e.toString();
    }

    @Override
    public String visit(UnaryExpression e) {
        return e.getName() + "(" + e.acceptOperand(this) + ")";
    }

    @Override
    public String visit(ForbiddenExpression e) {
        return e.getName() + "(" + e.getPermission() + ")";
    }

    @Override
    public String visit(UpdateExpression e) {
        return e.getName();
    }

    @Override
    public String visit(ConversionOp e) {
        return e.isImplicit() ? e.acceptOperand(this) : e.getName() + "(" + e.acceptOperand(this) + ")";
    }

    @Override
    public String visit(FunctionCallNode e) {
        return this.asMethodCall(e, e.getArguments());
    }

    @Override
    public String visit(BinaryExpression e) {
        return "(" + e.acceptLeft(this) + " " + e.getName() + " " + e.acceptRight(this) + ")";
    }

    @Override
    public String visit(IfExpression e) {
        return e.acceptCondition(this) + " ? " + e.acceptThen(this) + " : " + e.acceptElse(this);
    }

    @Override
    @Nullable
    public String visit(ListExpression e) {
        String list = Strings.join((Iterable)Colls.map((Iterable)e, expressionAST -> expressionAST.accept(this)), (char)',');
        return "(" + list + ")";
    }

    @Override
    @Nullable
    public String visit(AssignmentExpression e) {
        return e.getFieldExpr().accept(this) + (e.isEquals() ? " = " : " != ") + e.getValueExpr().accept(this) + (e.hasWhen() ? " when " + ((ExpressionAST)e.getWhenExpr().get()).accept(this) : "");
    }

    private String asMethodCall(ExpressionAST e, Iterable<ExpressionAST> children) {
        StrBuilder r = new StrBuilder();
        for (ExpressionAST expression : children) {
            r.appendElement((Object)expression.accept(this), ", ");
        }
        return this.asMethodName(e) + "(" + r.toString() + ")";
    }

    private String asMethodName(ExpressionAST e) {
        return e.getName();
    }

    public static String generate(ExpressionAST expr) {
        String result = expr.accept(new ToStringVisitor());
        return expr instanceof BinaryExpression ? result.substring(1, result.length() - 1) : result;
    }
}

