/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.lexer;

import mulesoft.lexer.CharStream;
import mulesoft.parser.Position;
import org.jetbrains.annotations.NotNull;

public class CharSequenceStream
extends CharStream
implements CharSequence {
    private int column;
    private final CharSequence data;
    private final int endOffset;
    private int line = 1;
    private int p;
    private final String sourceName;
    private final int startOffset;
    private int tabSpaces = 4;

    public CharSequenceStream() {
        this("", "");
    }

    public CharSequenceStream(String sourceName, CharSequence input) {
        this(sourceName, input, 0, input.length());
    }

    public CharSequenceStream(String sourceName, CharSequence input, int startOffset, int endOffset) {
        this.data = input;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.p = startOffset;
        this.tabSpaces = 4;
        this.sourceName = sourceName;
    }

    @Override
    public char charAt(int index) {
        assert (index >= this.startOffset && index < this.endOffset);
        return this.data.charAt(index);
    }

    @Override
    public void consume() {
        if (this.p < this.endOffset) {
            ++this.column;
            char c = this.data.charAt(this.p);
            if (c == '\n') {
                ++this.line;
                this.column = 0;
            } else if (c == '\t') {
                while (this.column % this.tabSpaces != 1) {
                    ++this.column;
                }
            }
            ++this.p;
        }
    }

    @Override
    public int currentChar() {
        return this.lookAhead(0);
    }

    @Override
    public int index() {
        return this.p;
    }

    @Override
    public int length() {
        return this.endOffset - this.startOffset;
    }

    @Override
    public int lookAhead(int i) {
        assert (i >= 0);
        return this.p + i < this.endOffset ? (int)this.data.charAt(this.p + i) : -1;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        assert (start >= this.startOffset && end <= this.endOffset && start <= end);
        return this.data.subSequence(start, end);
    }

    @Override
    @NotNull
    public String toString() {
        return this.data.subSequence(this.startOffset, this.endOffset).toString();
    }

    @Override
    public Position getPosition() {
        return Position.LineColumnPosition.createPosition(this.sourceName, this.line, this.column);
    }

    @Override
    public String getSourceName() {
        return this.sourceName;
    }
}

