/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.lexer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import mulesoft.common.util.CharArraySequence;
import mulesoft.lexer.CharSequenceStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileStream
extends CharSequenceStream {
    public FileStream(@NotNull File file) throws IOException {
        super(file.getPath(), FileStream.load(file, null));
    }

    public FileStream(@NotNull String file) throws IOException {
        super(file, FileStream.load(new File(file), null));
    }

    public FileStream(@NotNull File file, @NotNull String encoding) throws IOException {
        super(file.getPath(), FileStream.load(file, encoding));
    }

    private static CharSequence load(@NotNull File file, @Nullable String encoding) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try (InputStreamReader isr = encoding == null ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, encoding);){
            char[] data = new char[(int)file.length()];
            int length = isr.read(data);
            CharArraySequence charArraySequence = new CharArraySequence(data, 0, length);
            return charArraySequence;
        }
    }
}

