/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.lexer;

import java.util.SortedMap;
import mulesoft.lexer.CharSequenceStream;
import mulesoft.lexer.CharStream;
import mulesoft.lexer.Lexer;
import mulesoft.lexer.TokenType;
import mulesoft.lexer.Tokens;
import mulesoft.parser.Position;
import org.jetbrains.annotations.NotNull;

public class LexerImpl<T extends TokenType<T>>
implements Lexer<T> {
    @NotNull
    private T currentToken;
    private int currentTokenEnd;
    private int currentTokenStart;
    private int state;
    @NotNull
    private CharStream stream;
    @NotNull
    private final Tokens<T> tokens;

    public LexerImpl(Tokens<T> ts) {
        this(new CharSequenceStream(), ts);
    }

    private LexerImpl(@NotNull CharStream cs, @NotNull Tokens<T> ts) {
        this.stream = cs;
        this.tokens = ts;
        this.resetStream(cs);
    }

    @Override
    public final void advance() {
        this.currentTokenStart = this.stream.index();
        this.currentToken = this.findNextToken();
        this.currentTokenEnd = this.stream.index();
    }

    @Override
    public Lexer<T> resetStream(CharStream cs) {
        this.stream = cs;
        this.state = 0;
        this.advance();
        return this;
    }

    @Override
    @NotNull
    public Position getCurrentPosition() {
        return this.stream.getPosition();
    }

    @Override
    @NotNull
    public T getCurrentToken() {
        return this.currentToken;
    }

    @Override
    public int getCurrentTokenEnd() {
        return this.currentTokenEnd;
    }

    @Override
    public int getCurrentTokenStart() {
        return this.currentTokenStart;
    }

    @Override
    public final CharSequence getCurrentTokenText() {
        return this.stream.subSequence(this.currentTokenStart, this.stream.index());
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void setState(int state) {
        this.state = state;
    }

    protected T caseInsensitiveIdentifier() {
        while (Character.isJavaIdentifierPart(this.currentChar())) {
            this.consume();
        }
        return this.tokens.findKeyword(this.getCurrentTokenText().toString().toLowerCase());
    }

    protected T octalNumber(T octLong, T octInt) {
        this.match(48);
        this.matchDigits(8);
        return this.matchLongSuffix(octLong, octInt);
    }

    private T badChar() {
        this.consume();
        return this.tokens.getBadChar();
    }

    private T comment() {
        boolean doc;
        boolean bl = doc = this.currentChar() == 42;
        while (!this.match(-1) && !this.match(42, 47)) {
            this.consume();
        }
        return doc ? this.tokens.getDocumentation() : this.tokens.getComment();
    }

    private void consume() {
        this.stream.consume();
    }

    private void consume(int i) {
        for (int j = 0; j < i; ++j) {
            this.stream.consume();
        }
    }

    private int currentChar() {
        return this.stream.currentChar();
    }

    @NotNull
    private T findNextToken() {
        int chr = this.currentChar();
        switch (chr) {
            case -1: {
                return this.tokens.getEofToken();
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: {
                return this.whiteSpace();
            }
            case 33: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 91: 
            case 93: 
            case 123: 
            case 124: 
            case 125: {
                return this.operator(chr);
            }
            case 34: {
                int c1 = this.lookAhead(1);
                int c2 = this.lookAhead(2);
                return c1 == 34 && c2 == 34 ? this.multiLineString(chr) : this.string(chr);
            }
            case 47: {
                int a = this.lookAhead(1);
                if (a == 42 || a == 47) {
                    this.consume();
                    this.consume();
                }
                return a == 42 ? this.comment() : (a == 47 ? this.lineComment() : this.operator(47));
            }
            case 48: {
                int c = this.lookAhead(1);
                return c == 120 || c == 88 ? this.hexadecimalNumber() : (c != 46 ? this.octalNumber() : this.number());
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.number();
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                return this.identifier();
            }
        }
        return Character.isJavaIdentifierStart(chr) ? this.identifier() : (Character.isDigit(chr) ? this.number() : (Character.isWhitespace(chr) ? this.whiteSpace() : this.badChar()));
    }

    private T hexadecimalNumber() {
        this.match(48);
        T hexInt = this.tokens.getHexInt();
        T hexLong = this.tokens.getHexLong();
        if (hexInt == null && hexLong == null) {
            return this.tokens.getDecInt();
        }
        this.matchAny(120, 88);
        this.matchDigits(16);
        return hexLong == null ? hexInt : this.matchLongSuffix(hexLong, hexInt);
    }

    private T identifier() {
        while (Character.isJavaIdentifierPart(this.currentChar())) {
            this.consume();
        }
        return this.tokens.findKeyword(this.getCurrentTokenText().toString());
    }

    private T lineComment() {
        boolean doc;
        boolean bl = doc = this.currentChar() == 45;
        while (!this.matchAny(10, -1)) {
            this.consume();
        }
        return doc ? this.tokens.getDocumentation() : this.tokens.getLineComment();
    }

    private int lookAhead(int i) {
        return this.stream.lookAhead(i);
    }

    private boolean match(int c) {
        return this.stream.match(c);
    }

    private boolean match(int ... cs) {
        return this.stream.match(cs);
    }

    private boolean matchAny(int ... cs) {
        return this.stream.matchAny(cs);
    }

    private void matchDigits(int radix) {
        while (Character.digit(this.currentChar(), radix) != -1) {
            this.consume();
        }
    }

    private T matchLongSuffix(T longToken, T intToken) {
        return this.match(108, 76) ? longToken : intToken;
    }

    private T multiLineString(int quoteChar) {
        int chr;
        this.consume(3);
        while ((chr = this.currentChar()) != -1) {
            if (chr == quoteChar && this.lookAhead(1) == 34 && this.lookAhead(2) == 34) {
                this.consume(3);
                break;
            }
            this.consume();
        }
        return this.tokens.getStringLiteral();
    }

    private T number() {
        T intToken = this.tokens.getDecInt();
        T doubleToken = this.tokens.getDouble();
        this.matchDigits(10);
        T t = intToken;
        if (this.match(46)) {
            this.matchDigits(10);
            t = this.tokens.getFixedDecimal();
            if (t == null) {
                t = doubleToken;
            }
            if (this.match(101, 69)) {
                this.match(43, 45);
                this.matchDigits(10);
                t = doubleToken;
            }
        }
        if (this.match(102, 70)) {
            t = this.tokens.getFloat();
            if (t == null) {
                t = doubleToken;
            }
        } else if (this.match(100, 68)) {
            t = doubleToken;
        } else if (t == intToken && this.tokens.getDecLong() != null && this.match(108, 76)) {
            t = this.tokens.getDecLong();
        }
        return t;
    }

    private T octalNumber() {
        this.match(48);
        T octInt = this.tokens.getOctInt();
        T octLong = this.tokens.getOctLong();
        if (octInt == null && octLong == null) {
            return this.tokens.getDecInt();
        }
        this.matchDigits(8);
        return octLong == null ? octInt : this.matchLongSuffix(octLong, octInt);
    }

    private T operator(int chr) {
        String op;
        T t;
        int next;
        this.consume();
        SortedMap<String, T> m = this.tokens.findOperator(chr);
        if (m.isEmpty()) {
            return this.tokens.getBadChar();
        }
        if ((m.size() > 1 || m.firstKey().length() > 1) && (next = this.currentChar()) != -1 && (t = this.tokens.findOperator(op = new String(new char[]{(char)chr, (char)next}))) != null) {
            this.consume();
            return t;
        }
        return (T)((TokenType)m.values().iterator().next());
    }

    private T string(int quoteChar) {
        this.match(quoteChar);
        while (!this.matchAny(quoteChar, 10, -1)) {
            int c;
            if (this.currentChar() == 92 && (c = this.lookAhead(1)) != -1 && c != 10) {
                this.consume();
            }
            this.consume();
        }
        return this.tokens.getStringLiteral();
    }

    private T whiteSpace() {
        while (Character.isWhitespace(this.currentChar())) {
            this.consume();
        }
        return this.tokens.getWhiteSpaceToken();
    }
}

