/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.lexer;

import mulesoft.common.core.Strings;
import mulesoft.lexer.TokenKindType;
import mulesoft.parser.Highlight;
import org.jetbrains.annotations.NotNull;

public enum TokenKind implements TokenKindType
{
    EMPTY,
    WHITE_SPACE,
    BAD_CHAR,
    NODE,
    IDENTIFIER,
    IGNORABLE,
    OPERATOR(Highlight.OPERATOR_H),
    KEYWORD(Highlight.KEYWORD_H),
    COMMENT(Highlight.COMMENT_H),
    NUMBER(Highlight.NUMBER_H),
    STRING(Highlight.STRING_H),
    CTX_KEYWORD(Highlight.KEYWORD_H),
    DOCUMENTATION(Highlight.DOCUMENTATION_H);

    private final Highlight highlight;
    public static final char MAX_ISO_CHAR = '\u00ff';

    private TokenKind() {
        this(Highlight.PLAIN_H);
    }

    private TokenKind(Highlight hi) {
        this.highlight = hi;
    }

    public String description(@NotNull String tokenText) {
        switch (this) {
            case NUMBER: {
                return tokenText;
            }
            case CTX_KEYWORD: 
            case KEYWORD: 
            case IDENTIFIER: {
                return "'" + tokenText + "'";
            }
            case STRING: {
                return "\"" + tokenText + "\"";
            }
            case NODE: {
                return "[" + tokenText.toLowerCase() + "]";
            }
            case WHITE_SPACE: {
                return "' '";
            }
            case OPERATOR: {
                return "'" + tokenText.toLowerCase() + "'";
            }
            case EMPTY: 
            case IGNORABLE: 
            case DOCUMENTATION: 
            case COMMENT: {
                return "<" + tokenText.toLowerCase() + ">";
            }
            case BAD_CHAR: {
                if (tokenText.length() != 1) {
                    return "<bad_char>";
                }
                return "'" + Strings.encodeChar((char)tokenText.charAt(0)) + "'";
            }
        }
        return "";
    }

    public TokenKindType withHighlight(final Highlight hi) {
        return new TokenKindType(){

            @Override
            @NotNull
            public TokenKind getTokenKind() {
                return TokenKind.this;
            }

            @Override
            @NotNull
            public Highlight getHighlight() {
                return hi;
            }
        };
    }

    public boolean isKeyword() {
        return this == KEYWORD;
    }

    public boolean isIgnorable() {
        return this == IGNORABLE || this == WHITE_SPACE || this == COMMENT;
    }

    public boolean isWhiteSpace() {
        return this == COMMENT || this == WHITE_SPACE;
    }

    @Override
    @NotNull
    public Highlight getHighlight() {
        return this.highlight;
    }

    public boolean isIdentifier() {
        return this == IDENTIFIER;
    }

    @Override
    @NotNull
    public TokenKind getTokenKind() {
        return this;
    }
}

