/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.lexer;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import mulesoft.common.Predefined;
import mulesoft.lexer.Lexer;
import mulesoft.lexer.LexerImpl;
import mulesoft.lexer.TokenType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Tokens<T extends TokenType<T>> {
    @NotNull
    protected final Map<String, T> keywordMap = new HashMap<String, T>();
    @NotNull
    private final T badChar;
    @NotNull
    private final T comment;
    @NotNull
    private final T documentation;
    @NotNull
    private final T eofToken;
    @NotNull
    private final T identifier;
    @NotNull
    private final T ignorableToken;
    @NotNull
    private final TreeMap<String, T> operatorMap = new TreeMap();
    @NotNull
    private final T stringLiteral;
    @NotNull
    private final T wsToken;

    protected Tokens(@NotNull Class<T> tokenClass) {
        TokenType eof = null;
        TokenType bad = null;
        TokenType ws = null;
        TokenType string = null;
        TokenType id = null;
        TokenType comm = null;
        TokenType doc = null;
        TokenType ignorable = null;
        block15: for (TokenType token : (TokenType[])tokenClass.getEnumConstants()) {
            switch (token.getKind()) {
                case CTX_KEYWORD: {
                    continue block15;
                }
                case KEYWORD: {
                    this.keywordMap.put(token.getText(), token.target());
                    continue block15;
                }
                case NUMBER: {
                    continue block15;
                }
                case IDENTIFIER: {
                    id = token;
                    continue block15;
                }
                case STRING: {
                    string = token;
                    continue block15;
                }
                case DOCUMENTATION: {
                    doc = token;
                    continue block15;
                }
                case COMMENT: {
                    if (token == this.getLineComment()) continue block15;
                    comm = token;
                    continue block15;
                }
                case NODE: {
                    continue block15;
                }
                case OPERATOR: {
                    this.operatorMap.put(token.getText(), token.target());
                    continue block15;
                }
                case EMPTY: {
                    eof = token;
                    continue block15;
                }
                case WHITE_SPACE: {
                    ws = token;
                    continue block15;
                }
                case BAD_CHAR: {
                    bad = token;
                    continue block15;
                }
                case IGNORABLE: {
                    ignorable = token;
                }
            }
        }
        if (eof == null || bad == null || ws == null || string == null || id == null || comm == null || doc == null) {
            throw new IllegalStateException("Incomplete Token Set");
        }
        this.eofToken = eof;
        this.wsToken = ws;
        this.stringLiteral = string;
        this.identifier = id;
        this.badChar = bad;
        this.comment = comm;
        this.documentation = doc;
        this.ignorableToken = ignorable;
    }

    @NotNull
    public T findKeyword(@NotNull String name) {
        return (T)((TokenType)Predefined.notNull(this.keywordMap.get(name), this.identifier));
    }

    @NotNull
    public final SortedMap<String, T> findOperator(int c) {
        String from = String.valueOf((char)c);
        String to = String.valueOf((char)(c + 1));
        return this.operatorMap.subMap(from, to);
    }

    @Nullable
    public final T findOperator(String str) {
        return (T)((TokenType)this.operatorMap.get(str));
    }

    public Lexer<T> lexer() {
        return new LexerImpl(this);
    }

    @NotNull
    public final T getBadChar() {
        return this.badChar;
    }

    @NotNull
    public final T getComment() {
        return this.comment;
    }

    @NotNull
    public abstract T getDecInt();

    @Nullable
    public T getDecLong() {
        return null;
    }

    @NotNull
    public final T getDocumentation() {
        return this.documentation;
    }

    @NotNull
    public abstract T getDouble();

    @NotNull
    public final T getEofToken() {
        return this.eofToken;
    }

    @Nullable
    public T getFixedDecimal() {
        return null;
    }

    @Nullable
    public T getFloat() {
        return null;
    }

    @Nullable
    public T getHexInt() {
        return null;
    }

    @Nullable
    public T getHexLong() {
        return null;
    }

    @NotNull
    public final T getIgnorableToken() {
        return this.ignorableToken;
    }

    @Nullable
    public T getLineComment() {
        return null;
    }

    @Nullable
    public T getOctInt() {
        return null;
    }

    @Nullable
    public T getOctLong() {
        return null;
    }

    @NotNull
    public final T getStringLiteral() {
        return this.stringLiteral;
    }

    @NotNull
    public final T getWhiteSpaceToken() {
        return this.wsToken;
    }
}

