/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.parser;

import java.io.PrintWriter;
import java.util.function.Function;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Strings;
import mulesoft.lexer.TokenType;
import mulesoft.parser.Position;
import org.jetbrains.annotations.NotNull;

public interface ASTNode<N extends ASTNode<N, T>, T extends TokenType<T>>
extends Iterable<N> {
    public Seq<N> children();

    public Seq<N> children(@NotNull T var1);

    public boolean hasType(T var1);

    @NotNull
    public N getChild(int var1);

    public boolean isWhiteSpace();

    @NotNull
    public ASTNode<N, T> getEffectiveNode();

    public N getEmptyNode();

    @NotNull
    public Position getPosition();

    @NotNull
    public String getText();

    @NotNull
    public T getType();

    public boolean isEmpty();

    public static class Utils {
        public static final String INVALID_TOKEN_TYPE = "Invalid token type: ";

        private Utils() {
        }

        public static <N extends ASTNode<N, T>, T extends TokenType<T>> String asLispList(@NotNull ASTNode<N, T> node) {
            Seq<N> children = node.children();
            String text = node.getText();
            if (children.isEmpty()) {
                return text;
            }
            StringBuilder builder = new StringBuilder();
            builder.append("(").append(text);
            for (ASTNode child : children) {
                builder.append(" ");
                builder.append(Utils.asLispList(child));
            }
            builder.append(")");
            return builder.toString();
        }

        public static <N extends ASTNode<N, T>, T extends TokenType<T>> void assertType(@NotNull ASTNode<N, T> node, T type) {
            if (!node.hasType(type)) {
                throw new IllegalArgumentException(INVALID_TOKEN_TYPE + node.getType() + ", must be: " + type);
            }
        }

        public static <N extends ASTNode<N, T>, T extends TokenType<T>> Seq<N> children(@NotNull ASTNode<N, T> node, @NotNull T t) {
            return node.children().filter(e -> e != null && e.hasType(t));
        }

        public static Seq<String> childrenAsStrings(ASTNode<?, ?> node) {
            Seq children = (Seq)Predefined.cast(node.children());
            Function<ASTNode, String> getText = ASTNode::getText;
            return children.map(getText);
        }

        public static <N extends ASTNode<N, T>, T extends TokenType<T>> N firstAtom(N node) {
            N n = node;
            N child = n.getChild(0);
            while (!child.isEmpty()) {
                n = child;
                child = n.getChild(0);
            }
            return n;
        }

        public static <N extends ASTNode<N, T>, T extends TokenType<T>> void printTree(@NotNull ASTNode<N, T> node, PrintWriter out) {
            Utils.printTree(node, out, 0);
            out.flush();
        }

        public static <N extends ASTNode<N, T>, T extends TokenType<T>> int getChildAsInt(@NotNull ASTNode<N, T> t, int child) {
            N p = t.getChild(child);
            return p.getType().isEmpty() ? 0 : Integer.parseInt(p.getText());
        }

        private static <N extends ASTNode<N, T>, T extends TokenType<T>> void printTree(@NotNull ASTNode<N, T> node, PrintWriter out, int indent) {
            out.printf("%7s%s %s: %s\n", node.getPosition(), Strings.spaces((int)indent), node.getType(), node.getText());
            for (ASTNode child : node.children()) {
                Utils.printTree(child, out, indent + 4);
            }
        }
    }
}

