/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.parser;

import java.util.ArrayList;
import java.util.List;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.Stack;
import mulesoft.lexer.Lexer;
import mulesoft.lexer.TokenType;
import mulesoft.parser.ASTBuilder;
import mulesoft.parser.ASTNode;
import mulesoft.parser.Diagnostic;
import mulesoft.parser.ParserErrorListener;
import mulesoft.parser.Position;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractASTBuilder<N extends ASTNode<N, T>, T extends TokenType<T>>
implements ASTBuilder<T>,
ParserErrorListener {
    private int current;
    private final int last;
    @NotNull
    private final List<Diagnostic> messages;
    private final boolean skipWhiteSpace;
    @NotNull
    private final String sourceName;
    @NotNull
    private final Stack<NodeBuilder<N>> stack;
    @NotNull
    private final List<N> tokens;

    protected AbstractASTBuilder(@NotNull Lexer<T> lexer, @NotNull String sourceName, boolean skipWhiteSpace) {
        this.skipWhiteSpace = skipWhiteSpace;
        this.stack = Stack.createStack();
        this.tokens = this.slurpTokens(lexer);
        this.current = -1;
        this.messages = new ArrayList<Diagnostic>();
        this.last = this.tokens.size() - 1;
        this.sourceName = sourceName;
        this.advanceLexer();
    }

    @Override
    public void addChild() {
        this.addChild(this.getCurrent());
    }

    @Override
    public void advanceLexer() {
        while (this.current++ < this.last) {
            N n = this.getCurrent();
            if (n.isWhiteSpace()) continue;
            return;
        }
    }

    @Override
    public void beginNode() {
        this.stack.push(new NodeBuilder(this.getCurrentPosition()));
    }

    @Override
    public void discard() {
        this.advanceLexer();
    }

    @Override
    public void dropAllNodes() {
        while (this.stack.size() > 1) {
            this.dropNode();
        }
    }

    @Override
    public void dropNode() {
        NodeBuilder nb = (NodeBuilder)this.stack.pop();
        NodeBuilder top = (NodeBuilder)this.stack.peek();
        for (ASTNode n : nb.nodes) {
            top.add(n);
        }
    }

    @Override
    public void dupBeginNode() {
        NodeBuilder nb = (NodeBuilder)this.stack.pop();
        this.stack.push(new NodeBuilder(nb.position));
        this.stack.push((Object)nb);
    }

    @Override
    public void endAndPushNode(T token) {
        N n = this.buildAST(token, token.getDescription(""));
        NodeBuilder nb = new NodeBuilder(n.getPosition());
        nb.add(n);
        this.stack.push(nb);
    }

    @Override
    public void endNode(T token) {
        this.addChild(this.buildAST(token, token.getDescription("")));
    }

    @Override
    public boolean eof() {
        return this.current >= this.last;
    }

    @Override
    public final void error(Position position, String message) {
        this.messages.add(position.createMessage(message));
    }

    @Override
    @NotNull
    public T lookAhead(int position) {
        int j;
        int i = position;
        if (this.skipWhiteSpace) {
            j += i;
        } else {
            for (j = this.current; i > 0 && j < this.last; ++j) {
                if (((ASTNode)this.tokens.get(j)).isWhiteSpace()) continue;
                --i;
            }
        }
        return j < this.last ? ((ASTNode)this.tokens.get(j)).getType() : this.getCurrent().getEmptyNode().getType();
    }

    @Override
    @NotNull
    public Position getCurrentPosition() {
        return this.getCurrent().getPosition();
    }

    @Override
    @NotNull
    public String getCurrentText() {
        return this.getCurrent().getText();
    }

    @NotNull
    public List<Diagnostic> getMessages() {
        return this.messages;
    }

    @Override
    public boolean isCompletion() {
        return false;
    }

    @Override
    public long getOffset() {
        return this.getCurrentPosition().getOffset();
    }

    @NotNull
    public String getSourceName() {
        return this.sourceName;
    }

    @Override
    @NotNull
    public T getTokenType() {
        return this.getCurrent().getType();
    }

    protected N buildAST(T token, String text) {
        NodeBuilder n = (NodeBuilder)this.stack.pop();
        return this.createNode(token, text, n.position, n.nodes);
    }

    protected abstract N createNode(T var1, String var2, Position var3);

    protected abstract N createNode(T var1, String var2, Position var3, List<N> var4);

    private void addChild(N n) {
        ((NodeBuilder)this.stack.peek()).add(n);
    }

    private List<N> slurpTokens(Lexer<T> l) {
        ArrayList<N> result = new ArrayList<N>();
        while (true) {
            T token = l.getCurrentToken();
            if (!this.skipWhiteSpace || !token.isWhiteSpace()) {
                result.add(this.createNode(token, l.getCurrentTokenText().toString(), l.getCurrentPosition()));
            }
            if (token.isEmpty()) {
                return result;
            }
            l.advance();
        }
    }

    private N getCurrent() {
        return (N)((ASTNode)this.tokens.get(this.current));
    }

    static class NodeBuilder<N> {
        private final List<N> nodes;
        private final Position position;

        private NodeBuilder(Position position) {
            this.position = position;
            this.nodes = new ArrayList<N>(2);
        }

        public String toString() {
            return Colls.mkString(this.nodes);
        }

        private void add(N n) {
            this.nodes.add(n);
        }
    }
}

