/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.parser;

import java.util.List;
import mulesoft.common.Predefined;
import mulesoft.common.collections.BaseSeq;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableIterator;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.Seq;
import mulesoft.lexer.TokenType;
import mulesoft.parser.ASTNode;
import mulesoft.parser.Position;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractASTNode<N extends ASTNode<N, T>, T extends TokenType<T>>
extends BaseSeq<N>
implements ASTNode<N, T> {
    @NotNull
    private final ImmutableList<N> children;
    @NotNull
    private final Position position;
    @NotNull
    private final String text;
    @NotNull
    private final T type;

    protected AbstractASTNode(@NotNull T type, @NotNull String text, @NotNull Position position) {
        this.type = type;
        this.position = position;
        this.text = text;
        this.children = Colls.emptyList();
    }

    protected AbstractASTNode(@NotNull T type, @NotNull String text, @NotNull Position position, @NotNull List<N> children) {
        this.type = type;
        this.position = position;
        this.text = text;
        this.children = Colls.immutable(children);
    }

    @Override
    public final Seq<N> children() {
        return this.children;
    }

    @Override
    public final Seq<N> children(@NotNull T t) {
        return ASTNode.Utils.children(this, t);
    }

    @Override
    public boolean hasType(T token) {
        return Predefined.equal(this.getType(), token);
    }

    @Override
    @NotNull
    public ImmutableIterator<N> iterator() {
        return this.children.iterator();
    }

    public String toString() {
        return this.getText();
    }

    @Override
    @NotNull
    public N getChild(int n) {
        return (N)(n < 0 || n >= this.children.size() ? this.getEmptyNode() : (ASTNode)this.children.get(n));
    }

    @Override
    public boolean isWhiteSpace() {
        return this.type.isWhiteSpace();
    }

    @Override
    @NotNull
    public ASTNode<N, T> getEffectiveNode() {
        return this;
    }

    @Override
    @NotNull
    public Position getPosition() {
        return this.position;
    }

    @Override
    @NotNull
    public String getText() {
        return this.text;
    }

    @Override
    @NotNull
    public T getType() {
        return this.type;
    }

    @Override
    public boolean isEmpty() {
        return this.getType().isEmpty();
    }
}

