/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.parser;

import mulesoft.common.collections.ImmutableList;
import mulesoft.lexer.TokenType;
import mulesoft.parser.ASTBuilder;
import mulesoft.parser.LoopException;
import mulesoft.parser.Parser;
import mulesoft.parser.ParserCommonMessages;
import mulesoft.parser.ParserErrorListener;
import mulesoft.parser.Position;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractParser<T extends TokenType<T>>
implements Parser {
    @NotNull
    private final ASTBuilder<T> astBuilder;
    @NotNull
    private ParserErrorListener errorListener;
    private long lastPosition;

    protected AbstractParser(@NotNull ASTBuilder<T> astBuilder, @NotNull ParserErrorListener listener) {
        this.astBuilder = astBuilder;
        this.lastPosition = -1L;
        this.errorListener = listener;
    }

    public void beginTree() {
        this.astBuilder.beginNode();
    }

    public final void discard() {
        this.astBuilder.discard();
    }

    public void dropTree() {
        this.astBuilder.dropNode();
    }

    public void dupBeginTree() {
        this.astBuilder.dupBeginNode();
    }

    public void endAndPushTree(T token) {
        this.astBuilder.endAndPushNode(token);
    }

    public void endTree(T token) {
        this.astBuilder.endNode(token);
    }

    public final T getCurrent() {
        return this.astBuilder.getTokenType();
    }

    public final void setErrorListener(@NotNull ParserErrorListener listener) {
        this.errorListener = listener;
    }

    @SafeVarargs
    protected final void advanceTo(T ... tokens) {
        while (!this.eof() && !this.currentAnyOf((TokenType[])tokens)) {
            this.astBuilder.advanceLexer();
        }
    }

    protected void advanceToEof() {
        while (!this.eof()) {
            this.astBuilder.advanceLexer();
        }
    }

    protected boolean ahead(T tokenType, int i) {
        return this.astBuilder.lookAhead(i) == tokenType;
    }

    protected void checkCompletion() {
        if (this.isCompletion()) {
            this.discard();
        }
    }

    protected final void consume() {
        this.astBuilder.addChild();
        this.astBuilder.advanceLexer();
    }

    protected final boolean current(T tokenType) {
        return this.getCurrent() == tokenType;
    }

    @SafeVarargs
    protected final boolean currentAnyOf(T ... tokenType) {
        if (this.eof()) {
            return false;
        }
        for (T t : tokenType) {
            if (this.getCurrent() != t) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    protected final boolean currentAnyOfOrError(T ... tokenType) {
        for (T t : tokenType) {
            if (this.getCurrent() != t) continue;
            return true;
        }
        this.error(ParserCommonMessages.MSGS.expected(ParserCommonMessages.MSGS.anyOf(ImmutableList.fromArray((Object[])tokenType).toString()), this.getCurrentDescription()));
        return false;
    }

    protected final boolean currentByText(T tokenType) {
        T current = this.getCurrent();
        return current == tokenType || current.getKind().isIdentifier() && this.getCurrentText().equals(tokenType.getText());
    }

    @SafeVarargs
    protected final boolean currentByTextAnyOf(T ... tokenType) {
        if (this.eof()) {
            return false;
        }
        for (T t : tokenType) {
            T current = this.getCurrent();
            if (current != t && (!current.getKind().isIdentifier() || !this.getCurrentText().equals(t.getText()))) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    protected final boolean currentByTextAnyOfOrError(T ... tokenType) {
        if (this.currentByTextAnyOf((TokenType[])tokenType)) {
            return true;
        }
        this.error(ParserCommonMessages.MSGS.expected(ParserCommonMessages.MSGS.anyOf(ImmutableList.fromArray((Object[])tokenType).toString()), this.getCurrentDescription()));
        return false;
    }

    protected boolean currentByTextOrError(T tokenType) {
        if (this.currentByText(tokenType)) {
            return true;
        }
        this.error(ParserCommonMessages.MSGS.expected(tokenType.getDescription(""), this.getCurrentDescription()));
        if (!this.aheadByText(tokenType, 1)) {
            return false;
        }
        this.discard();
        return true;
    }

    protected boolean currentOrError(T tokenType) {
        if (this.current(tokenType)) {
            return true;
        }
        this.error(ParserCommonMessages.MSGS.expected(tokenType.getDescription(""), this.getCurrentDescription()));
        if (!this.ahead(tokenType, 1)) {
            return false;
        }
        this.discard();
        return true;
    }

    protected final boolean discard(T tokenType) {
        if (this.current(tokenType)) {
            this.discard();
            return true;
        }
        return false;
    }

    protected void discardOrError(T tokenType) {
        boolean b = this.currentOrError(tokenType);
        if (b) {
            this.discard();
        }
    }

    protected void dropAllTrees() {
        this.astBuilder.dropAllNodes();
    }

    protected final boolean eof() {
        return this.astBuilder.eof();
    }

    protected void error(Position position, String msg) {
        this.errorListener.error(position, msg);
    }

    protected T lookAhead(int i) {
        return this.astBuilder.lookAhead(i);
    }

    protected void loopCheck() {
        long current = this.getOffset();
        if (current == this.lastPosition) {
            throw new LoopException(this.astBuilder.getCurrentPosition());
        }
        this.lastPosition = current;
    }

    protected final boolean match(T tokenType) {
        boolean b = this.current(tokenType);
        if (b) {
            this.consume();
        }
        return b;
    }

    @SafeVarargs
    protected final boolean matchAnyOf(T ... tokens) {
        for (T token : tokens) {
            if (!this.current(token)) continue;
            this.consume();
            return true;
        }
        return false;
    }

    protected boolean matchOrError(T tokenType) {
        boolean b = this.currentOrError(tokenType);
        if (b) {
            this.consume();
        }
        return b;
    }

    protected boolean next(T token) {
        return this.astBuilder.lookAhead(1) == token;
    }

    protected final boolean notCurrent(T tokenType) {
        return !this.eof() && this.getCurrent() != tokenType;
    }

    @SafeVarargs
    protected final boolean notCurrentAnyOf(T ... tokenType) {
        if (this.eof()) {
            return false;
        }
        for (T t : tokenType) {
            if (this.getCurrent() != t) continue;
            return false;
        }
        return true;
    }

    protected final boolean parseList(@NotNull T listNode, @NotNull T leftToken, @Nullable T sepToken, @NotNull T rightToken, @NotNull Parser elementParser) {
        boolean b = this.current(leftToken);
        if (b) {
            this.beginTree();
            this.discardOrError(leftToken);
            while (this.notCurrent(rightToken)) {
                this.loopCheck();
                elementParser.parse();
                if (!this.notCurrent(rightToken) || sepToken == null) continue;
                this.currentOrError(sepToken);
                this.discard();
            }
            this.discardOrError(rightToken);
            this.endTree(listNode);
        }
        return b;
    }

    protected final void parseOptionalList(@NotNull T listNode, @NotNull T leftToken, @Nullable T sepToken, @NotNull T rightToken, @NotNull Parser elementParser) {
        if (!this.parseList(listNode, leftToken, sepToken, rightToken, elementParser)) {
            this.beginTree();
            elementParser.parse();
            this.endTree(listNode);
        }
    }

    protected void parseSimpleTree(T treeRoot, T content) {
        if (this.current(treeRoot)) {
            this.beginTree();
            this.discard(treeRoot);
            this.matchOrError(content);
            this.endTree(treeRoot);
        }
    }

    @SafeVarargs
    protected final void parseSimpleTree(T treeRoot, T ... contentAlternatives) {
        if (this.current(treeRoot)) {
            this.beginTree();
            this.discard(treeRoot);
            if (!this.matchAnyOf((TokenType[])contentAlternatives)) {
                this.unexpectedToken();
            }
            this.endTree(treeRoot);
        }
    }

    protected final void parseValues(T valuesNode, T sepToken, Parser elementParser) {
        this.beginTree();
        elementParser.parse();
        while (this.discard(sepToken)) {
            this.loopCheck();
            elementParser.parse();
        }
        this.endTree(valuesNode);
    }

    @SafeVarargs
    protected final void unexpectedAndAdvanceTo(T ... tokens) {
        this.unexpectedError();
        this.advanceTo((TokenType[])tokens);
    }

    protected void unexpectedError() {
        this.beginTree();
        this.endTree(this.getCurrent());
        this.error(this.astBuilder.getCurrentPosition(), ParserCommonMessages.MSGS.unexpected(this.getCurrentDescription()));
    }

    protected final void unexpectedToken() {
        this.unexpectedError();
        this.discard();
    }

    @SafeVarargs
    protected final T getAnyOf(T ... tokens) {
        for (T token : tokens) {
            if (!this.currentByText(token)) continue;
            return token;
        }
        return this.getCurrent();
    }

    @NotNull
    protected ASTBuilder<T> getAstBuilder() {
        return this.astBuilder;
    }

    @NotNull
    protected final String getCurrentText() {
        return this.astBuilder.getCurrentText();
    }

    @NotNull
    protected ParserErrorListener getErrorListener() {
        return this.errorListener;
    }

    protected boolean isCompletion() {
        return this.astBuilder.isCompletion();
    }

    private boolean aheadByText(T tokenType, int i) {
        T ahead = this.astBuilder.lookAhead(i);
        return ahead == tokenType || ahead.getKind().isIdentifier() && ahead.getText().equals(tokenType.getText());
    }

    private void error(String msg) {
        this.error(this.astBuilder.getCurrentPosition(), msg);
    }

    private String getCurrentDescription() {
        return this.getCurrent().getDescription(this.getCurrentText());
    }

    private long getOffset() {
        return this.astBuilder.getOffset();
    }
}

