/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.parser;

import mulesoft.common.Predefined;
import mulesoft.parser.Diagnostic;

public interface Position {
    public Diagnostic createMessage(String var1);

    public long getOffset();

    public static class OffsetPosition
    implements Position {
        private final long offset;
        public static final Position ZERO = OffsetPosition.createPosition(0L);

        private OffsetPosition(long offset) {
            this.offset = offset;
        }

        @Override
        public Diagnostic createMessage(String msg) {
            return new Diagnostic.Default(this, msg);
        }

        public boolean equals(Object o) {
            return o instanceof OffsetPosition && this.offset == ((OffsetPosition)o).offset;
        }

        public int hashCode() {
            return (int)this.offset;
        }

        public String toString() {
            return "(" + this.offset + ")";
        }

        @Override
        public long getOffset() {
            return this.offset;
        }

        public static Position createPosition(long offset) {
            return new OffsetPosition(offset);
        }
    }

    public static class LineColumnPosition
    implements Position {
        private final int column;
        private final int line;
        private final String sourceName;
        private static final long SALT = 20L;
        public static final Position ZERO = LineColumnPosition.createPosition("", 0, 0);

        private LineColumnPosition(String sourceName, int line, int column) {
            this.sourceName = Predefined.notNull((String)sourceName);
            this.line = line;
            this.column = column;
        }

        @Override
        public Diagnostic createMessage(final String msg) {
            return new Diagnostic.Default(this, msg){

                @Override
                public String getFormattedMessage() {
                    return sourceName + ":" + line + ": " + msg;
                }
            };
        }

        public boolean equals(Object o) {
            if (o instanceof LineColumnPosition) {
                LineColumnPosition that = (LineColumnPosition)o;
                return this.line == that.line && this.column == that.column && this.sourceName.equals(that.sourceName);
            }
            return false;
        }

        public int hashCode() {
            return (31 * this.line + this.column) * 31 + this.sourceName.hashCode();
        }

        public String toString() {
            return "(" + this.line + ", " + this.column + ")";
        }

        public int getColumn() {
            return this.column;
        }

        public int getLine() {
            return this.line;
        }

        @Override
        public long getOffset() {
            return this.line << 20 | this.column;
        }

        public String getSourceName() {
            return this.sourceName;
        }

        public static Position createPosition(String sourceName, int line, int column) {
            return new LineColumnPosition(sourceName, line, column);
        }
    }
}

