/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.mmcompiler;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Builder;
import mulesoft.common.core.Tuple;
import mulesoft.common.logging.Logger;
import mulesoft.common.util.FileFilters;
import mulesoft.common.util.Files;
import mulesoft.common.util.Resources;
import mulesoft.lexer.CharSequenceStream;
import mulesoft.lexer.FileStream;
import mulesoft.lexer.UrlStream;
import mulesoft.metadata.exception.BuilderError;
import mulesoft.mmcompiler.ast.MetaModelAST;
import mulesoft.mmcompiler.builder.BuilderErrorListener;
import mulesoft.mmcompiler.builder.BuilderFromAST;
import mulesoft.mmcompiler.parser.MetaModelCompiler;
import mulesoft.parser.Diagnostic;
import mulesoft.repository.ModelRepository;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelRepositoryLoader
implements Builder<ModelRepository> {
    private BuilderErrorListener errorListener = new BuilderErrorListener.Default();
    private final List<CharSequenceStream> modelStreams;
    private final ModelRepository repository;
    @NonNls
    public static final String META_MODEL_LIST = "META-INF/meta-model-files";
    private static final Logger logger = Logger.getLogger(ModelRepositoryLoader.class);

    public ModelRepositoryLoader(@NotNull ModelRepository seed) {
        this.repository = seed;
        this.modelStreams = new ArrayList<CharSequenceStream>();
    }

    public ModelRepositoryLoader(ClassLoader classLoader) {
        this(classLoader, new ModelRepository());
    }

    public ModelRepositoryLoader(@NotNull File path) {
        this(path, new ModelRepository());
    }

    public ModelRepositoryLoader(ClassLoader classLoader, @NotNull ModelRepository seed) {
        this(seed);
        this.loadStreams(classLoader);
    }

    public ModelRepositoryLoader(@NotNull File path, @NotNull ModelRepository seed) {
        this(seed);
        if (path.isDirectory()) {
            Files.list((File)path, (FileFilter)FileFilters.withExtension((String)"mm")).map(ModelRepositoryLoader::createStream).into(this.modelStreams);
        } else {
            this.modelStreams.add(ModelRepositoryLoader.createStream(path.getPath()));
        }
    }

    public void addModels(@NotNull File mmDir) {
        this.loadMetaData((Seq<CharSequenceStream>)Files.list((File)mmDir, (FileFilter)FileFilters.withExtension((String)"mm")).filter(mm -> this.repository.getModelsByFile(mm).isEmpty()).map(ModelRepositoryLoader::createStream));
    }

    public ModelRepository build() {
        return this.loadMetaData((Seq<CharSequenceStream>)Colls.seq(this.modelStreams));
    }

    public void loadStreams(ClassLoader classLoader) {
        for (String mm : Resources.readResources((ClassLoader)classLoader, (String)META_MODEL_LIST)) {
            UrlStream stream = ModelRepositoryLoader.createStream(classLoader, mm);
            if (stream != null) {
                this.modelStreams.add((CharSequenceStream)stream);
                continue;
            }
            logger.error("Cannot load MM Resource: " + mm);
        }
    }

    public ModelRepositoryLoader withErrorListener(BuilderErrorListener e) {
        this.errorListener = e;
        return this;
    }

    private ModelRepository loadMetaData(Seq<CharSequenceStream> streams) {
        BuilderFromAST builder = new BuilderFromAST(this.repository, this.errorListener);
        return builder.build((Iterable<Tuple<String, MetaModelAST>>)streams.map((Function)new Parse()));
    }

    public static ModelRepository loadFromClasspath() {
        ModelRepositoryLoader builder = new ModelRepositoryLoader(Thread.currentThread().getContextClassLoader());
        return builder.build();
    }

    @NotNull
    private static CharSequenceStream createStream(String value) {
        try {
            return new FileStream(value);
        }
        catch (IOException e) {
            logger.error("Cannot create stream for: " + value, (Throwable)e);
            throw new UncheckedIOException(e);
        }
    }

    @Nullable
    private static UrlStream createStream(ClassLoader classLoader, String mm) {
        URL url = classLoader.getResource(mm);
        try {
            if (url != null) {
                return new UrlStream(url, "UTF-8");
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        return null;
    }

    private class Parse
    implements Function<CharSequenceStream, Tuple<String, MetaModelAST>> {
        private Parse() {
        }

        @Override
        @Nullable
        public Tuple<String, MetaModelAST> apply(CharSequenceStream stream) {
            if (stream == null) {
                return null;
            }
            MetaModelCompiler mm = new MetaModelCompiler(stream, stream.getSourceName());
            MetaModelAST ast = mm.getAST();
            for (final Diagnostic error : mm.getMessages()) {
                ModelRepositoryLoader.this.errorListener.error(new BuilderError(){

                    public String getMessage() {
                        return error.getFormattedMessage();
                    }

                    @Nullable
                    public String getModelName() {
                        return null;
                    }
                });
            }
            return Tuple.tuple((Object)mm.getSourceName(), (Object)ast);
        }
    }
}

