/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.mmcompiler.ast;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Maps;
import mulesoft.common.core.Option;
import mulesoft.common.core.Tuple;
import mulesoft.common.util.JavaReservedWords;
import mulesoft.expr.BinaryExpression;
import mulesoft.expr.UnaryExpression;
import mulesoft.field.FieldOption;
import mulesoft.lexer.Lexer;
import mulesoft.lexer.TokenKind;
import mulesoft.lexer.TokenKindType;
import mulesoft.lexer.TokenType;
import mulesoft.lexer.Tokens;
import mulesoft.parser.Highlight;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum MMToken implements TokenType<MMToken>
{
    IGNORABLE((TokenKindType)TokenKind.IGNORABLE),
    EMPTY_TOKEN((TokenKindType)TokenKind.EMPTY),
    BAD_CHAR((TokenKindType)TokenKind.BAD_CHAR),
    WHITE_SPACE((TokenKindType)TokenKind.WHITE_SPACE),
    COMMENT((TokenKindType)TokenKind.COMMENT),
    LINE_COMMENT((TokenKindType)TokenKind.COMMENT),
    DOCUMENTATION((TokenKindType)TokenKind.DOCUMENTATION),
    HEX_INT((TokenKindType)TokenKind.NUMBER),
    DEC_INT((TokenKindType)TokenKind.NUMBER),
    FIXED_POINT_DECIMAL((TokenKindType)TokenKind.NUMBER),
    DOUBLE_LITERAL((TokenKindType)TokenKind.NUMBER, "float"),
    STRING_LITERAL((TokenKindType)TokenKind.STRING),
    IDENTIFIER((TokenKindType)TokenKind.IDENTIFIER),
    PLUS('+'),
    MINUS('-'),
    SLASH('/'),
    ASTERISK('*'),
    EQ('='),
    GT('>'),
    LT('<'),
    COLON(':'),
    SEMICOLON(';'),
    DOT('.'),
    COMMA(','),
    LEFT_BRACE('{'),
    RIGHT_BRACE('}'),
    LEFT_BRACKET('['),
    RIGHT_BRACKET(']'),
    LEFT_PAREN('('),
    RIGHT_PAREN(')'),
    QUESTION('?'),
    DOLLAR('$'),
    OR('|', '|'),
    AND('&', '&'),
    NOT('!'),
    IF('?'),
    FORBIDDEN((TokenKindType)TokenKind.OPERATOR, "forbidden"),
    IS_UPDATE((TokenKindType)TokenKind.OPERATOR, "isUpdate"),
    IS_READ_ONLY((TokenKindType)TokenKind.OPERATOR, "isReadOnly"),
    EQ_EQ('=', '='),
    NE('!', '='),
    GE('>', '='),
    LE('<', '='),
    PACKAGE((TokenKindType)TokenKind.KEYWORD),
    IMPORT((TokenKindType)TokenKind.KEYWORD),
    ENUM((TokenKindType)TokenKind.KEYWORD),
    NULL((TokenKindType)TokenKind.KEYWORD),
    TRUE((TokenKindType)TokenKind.KEYWORD),
    FALSE((TokenKindType)TokenKind.KEYWORD),
    DEFAULT((TokenKindType)TokenKind.KEYWORD),
    PROTECTED((TokenKindType)TokenKind.KEYWORD),
    EXTENDS((TokenKindType)TokenKind.KEYWORD),
    IMPLEMENTS((TokenKindType)TokenKind.KEYWORD),
    ENTITY((TokenKindType)TokenKind.CTX_KEYWORD),
    OF((TokenKindType)TokenKind.CTX_KEYWORD),
    CASE((TokenKindType)TokenKind.CTX_KEYWORD),
    DESCRIBED_BY((TokenKindType)TokenKind.CTX_KEYWORD),
    IMAGE((TokenKindType)TokenKind.CTX_KEYWORD),
    SEARCHABLE((TokenKindType)TokenKind.CTX_KEYWORD),
    FILTER((TokenKindType)TokenKind.CTX_KEYWORD),
    INDEX((TokenKindType)TokenKind.CTX_KEYWORD),
    UNIQUE((TokenKindType)TokenKind.CTX_KEYWORD),
    PRIMARY_KEY((TokenKindType)TokenKind.CTX_KEYWORD),
    DATABASE((TokenKindType)TokenKind.CTX_KEYWORD),
    PARAMETERS((TokenKindType)TokenKind.CTX_KEYWORD),
    PERMISSIONS((TokenKindType)TokenKind.CTX_KEYWORD),
    ERROR((TokenKindType)TokenKind.CTX_KEYWORD),
    WARNING((TokenKindType)TokenKind.CTX_KEYWORD),
    INFO((TokenKindType)TokenKind.CTX_KEYWORD),
    INLINE((TokenKindType)TokenKind.CTX_KEYWORD),
    POPUP((TokenKindType)TokenKind.CTX_KEYWORD),
    WHEN((TokenKindType)TokenKind.CTX_KEYWORD),
    USING((TokenKindType)TokenKind.CTX_KEYWORD),
    BY((TokenKindType)TokenKind.CTX_KEYWORD),
    TYPE((TokenKindType)TokenKind.CTX_KEYWORD),
    ON_LOAD((TokenKindType)TokenKind.CTX_KEYWORD),
    ON_DISPLAY((TokenKindType)TokenKind.CTX_KEYWORD),
    ON_ROUTE((TokenKindType)TokenKind.CTX_KEYWORD),
    ON_CANCEL((TokenKindType)TokenKind.CTX_KEYWORD),
    ON_SCHEDULE((TokenKindType)TokenKind.CTX_KEYWORD),
    WITH((TokenKindType)TokenKind.CTX_KEYWORD),
    LISTING((TokenKindType)TokenKind.CTX_KEYWORD),
    HANDLER((TokenKindType)TokenKind.CTX_KEYWORD),
    ROLE((TokenKindType)TokenKind.CTX_KEYWORD),
    MENU((TokenKindType)TokenKind.CTX_KEYWORD),
    LINK((TokenKindType)TokenKind.CTX_KEYWORD),
    SCHEMA((TokenKindType)TokenKind.CTX_KEYWORD),
    DEPRECABLE((TokenKindType)TokenKind.CTX_KEYWORD),
    AUDITABLE((TokenKindType)TokenKind.CTX_KEYWORD),
    REMOTABLE((TokenKindType)TokenKind.CTX_KEYWORD),
    OPTIMISTIC((TokenKindType)TokenKind.CTX_KEYWORD),
    BATCH_SIZE((TokenKindType)TokenKind.CTX_KEYWORD),
    VIEW((TokenKindType)TokenKind.CTX_KEYWORD),
    UPDATABLE((TokenKindType)TokenKind.CTX_KEYWORD),
    CACHE((TokenKindType)TokenKind.CTX_KEYWORD),
    TABLE((TokenKindType)TokenKind.CTX_KEYWORD),
    ALL((TokenKindType)TokenKind.CTX_KEYWORD),
    ISOLATED((TokenKindType)TokenKind.CTX_KEYWORD),
    TASK((TokenKindType)TokenKind.CTX_KEYWORD),
    SCHEDULE((TokenKindType)TokenKind.CTX_KEYWORD),
    PATTERN((TokenKindType)TokenKind.CTX_KEYWORD),
    TRANSACTION((TokenKindType)TokenKind.CTX_KEYWORD),
    NODE((TokenKindType)TokenKind.CTX_KEYWORD),
    CLUSTER((TokenKindType)TokenKind.CTX_KEYWORD),
    EXCLUSION_GROUP((TokenKindType)TokenKind.CTX_KEYWORD),
    LIFECYCLE((TokenKindType)TokenKind.CTX_KEYWORD),
    PROCESSOR((TokenKindType)TokenKind.CTX_KEYWORD),
    RUNNABLE((TokenKindType)TokenKind.CTX_KEYWORD),
    IMPORTER((TokenKindType)TokenKind.CTX_KEYWORD),
    EACH((TokenKindType)TokenKind.CTX_KEYWORD),
    NONE((TokenKindType)TokenKind.CTX_KEYWORD),
    DEPENDS_ON((TokenKindType)TokenKind.CTX_KEYWORD),
    SERVER((TokenKindType)TokenKind.CTX_KEYWORD),
    CLIENT((TokenKindType)TokenKind.CTX_KEYWORD),
    AS((TokenKindType)TokenKind.CTX_KEYWORD),
    BODY((TokenKindType)TokenKind.CTX_KEYWORD),
    UNRESTRICTED((TokenKindType)TokenKind.CTX_KEYWORD),
    SECURE_BY((TokenKindType)TokenKind.CTX_KEYWORD),
    RAISE((TokenKindType)TokenKind.CTX_KEYWORD),
    INTERNAL((TokenKindType)TokenKind.CTX_KEYWORD),
    NOTIFY((TokenKindType)TokenKind.CTX_KEYWORD),
    PROJECT((TokenKindType)TokenKind.CTX_KEYWORD),
    AFTER((TokenKindType)TokenKind.CTX_KEYWORD),
    LABELED_ID((TokenKindType)TokenKind.NODE),
    ASSIGNMENT_LIST((TokenKindType)TokenKind.NODE),
    INNER_ASSIGNMENT_LIST((TokenKindType)TokenKind.NODE),
    LIST((TokenKindType)TokenKind.NODE),
    ARG_LIST((TokenKindType)TokenKind.NODE),
    FIELD((TokenKindType)TokenKind.NODE),
    ENUM_FIELD((TokenKindType)TokenKind.NODE),
    ASSIGNMENT((TokenKindType)TokenKind.NODE),
    ASSIGNMENT_FIELD((TokenKindType)TokenKind.NODE),
    AGGREGATE((TokenKindType)TokenKind.NODE),
    ENUM_VALUE((TokenKindType)TokenKind.NODE),
    FILE((TokenKindType)TokenKind.NODE),
    FIELD_REF(TokenKind.NODE.withHighlight(Highlight.FIELD_REF_H)),
    FILTER_REF(TokenKind.NODE.withHighlight(Highlight.FIELD_REF_H)),
    PERMISSION_REF(TokenKind.NODE.withHighlight(Highlight.REFERENCE_H)),
    WIDGET_FIELD((TokenKindType)TokenKind.NODE),
    INVOKE((TokenKindType)TokenKind.NODE),
    UNARY_MINUS((TokenKindType)TokenKind.NODE),
    FILE_TYPE((TokenKindType)TokenKind.NODE, true),
    CHECK_TYPE((TokenKindType)TokenKind.NODE, true),
    BUTTON_TYPE((TokenKindType)TokenKind.NODE, true),
    TOGGLE_BUTTON_TYPE((TokenKindType)TokenKind.NODE, true),
    TAB_TYPE((TokenKindType)TokenKind.NODE, true),
    POPOVER_TYPE((TokenKindType)TokenKind.NODE, true),
    MAIL_VALIDATION_TYPE((TokenKindType)TokenKind.NODE, true),
    RATING_TYPE((TokenKindType)TokenKind.NODE, true),
    MAP_TYPE((TokenKindType)TokenKind.NODE, true),
    DATE_TYPE((TokenKindType)TokenKind.NODE, true),
    MASK((TokenKindType)TokenKind.NODE, true),
    QUERY_MODE((TokenKindType)TokenKind.NODE, true),
    ICON((TokenKindType)TokenKind.NODE, true),
    EXPORT_TYPE((TokenKindType)TokenKind.NODE, true),
    HTTP_METHOD((TokenKindType)TokenKind.NODE, true),
    MENU_ELEMENT((TokenKindType)TokenKind.NODE),
    ROLE_ELEMENT((TokenKindType)TokenKind.NODE),
    ROLE_PERMISSION((TokenKindType)TokenKind.NODE),
    ROUTE((TokenKindType)TokenKind.NODE),
    TASK_PHASE((TokenKindType)TokenKind.NODE),
    PATH((TokenKindType)TokenKind.NODE),
    PART((TokenKindType)TokenKind.NODE),
    CLASS((TokenKindType)TokenKind.NODE),
    INTERPOLATION((TokenKindType)TokenKind.NODE),
    REFERENCE(TokenKind.NODE.withHighlight(Highlight.REFERENCE_H)),
    TYPE_REF((TokenKindType)TokenKind.NODE),
    ENTITY_REF(TokenKind.NODE.withHighlight(Highlight.KEYWORD_H)),
    TYPE_NODE((TokenKindType)TokenKind.NODE),
    WIDGET_TYPE(TokenKind.NODE.withHighlight(Highlight.WIDGET_H)),
    MODIFIERS(TokenKind.NODE.withHighlight(Highlight.KEYWORD_H)),
    OPTION(TokenKind.NODE.withHighlight(Highlight.OPTION_H)),
    CHECK(TokenKind.NODE.withHighlight(Highlight.KEYWORD_H)),
    MODEL(TokenKind.NODE.withHighlight(Highlight.KEYWORD_H)),
    ENUM_REF(TokenKind.NODE.withHighlight(Highlight.KEYWORD_H)),
    ENUM_FIELD_REF(TokenKind.NODE.withHighlight(Highlight.REFERENCE_H)),
    STRUCT_REF((TokenKindType)TokenKind.NODE),
    FORM_REF((TokenKindType)TokenKind.NODE, true),
    WIDGET_DEF_REF((TokenKindType)TokenKind.NODE, true),
    METHOD_REF(TokenKind.NODE.withHighlight(Highlight.REFERENCE_H), true),
    DATAOBJECT_REF(TokenKind.NODE.withHighlight(Highlight.KEYWORD_H)),
    TASK_REF(TokenKind.NODE.withHighlight(Highlight.REFERENCE_H)),
    PARAMETER(TokenKind.NODE.withHighlight(Highlight.REFERENCE_H)),
    MODEL_OPTIONS((TokenKindType)TokenKind.NODE),
    AFTER_SEARCHABLE((TokenKindType)TokenKind.NODE),
    TASK_TYPE((TokenKindType)TokenKind.NODE);

    @NotNull
    private final Highlight highlight;
    @NotNull
    private final TokenKind kind;
    @NotNull
    private final String text;
    private final boolean wrapper;
    private static final Tokens<MMToken> tokens;
    private static final Map<FieldOption, MMToken> nodeForOption;
    private static final EnumMap<MMToken, BinaryExpression.Operator> binaryOp;
    private static final EnumMap<MMToken, UnaryExpression.Operator> unaryOp;
    private static final EnumSet<MMToken> LITERALS;

    private MMToken(TokenKindType kind) {
        this(kind, "", false);
    }

    private MMToken(char ... cs) {
        this((TokenKindType)TokenKind.OPERATOR, new String(cs), false);
    }

    private MMToken(TokenKindType kind, boolean wrapper) {
        this(kind, "", wrapper);
    }

    private MMToken(TokenKindType kind, String text) {
        this(kind, text, false);
    }

    private MMToken(TokenKindType kind, String text, boolean wrapper) {
        this.kind = kind.getTokenKind();
        this.text = Predefined.isNotEmpty((String)text) ? text : (kind == TokenKind.KEYWORD || kind == TokenKind.CTX_KEYWORD ? this.name().toLowerCase() : this.name());
        this.highlight = kind.getHighlight();
        this.wrapper = wrapper;
    }

    @Nullable
    public BinaryExpression.Operator binaryOperator() {
        return binaryOp.get((Object)this);
    }

    @NotNull
    public MMToken target() {
        return this;
    }

    @Nullable
    public UnaryExpression.Operator unaryOperator() {
        return unaryOp.get((Object)this);
    }

    public boolean isKeyword() {
        return this.kind == TokenKind.KEYWORD;
    }

    @NotNull
    public String getDescription(String s) {
        return this.kind.description(Predefined.isNotEmpty((String)s) ? s : this.text);
    }

    public boolean isIgnorable() {
        return this.getKind().isIgnorable();
    }

    public boolean isWhiteSpace() {
        return this.kind.isWhiteSpace();
    }

    @NotNull
    public Highlight getHighlight() {
        return this.highlight;
    }

    @NotNull
    public TokenKind getKind() {
        return this.kind;
    }

    public boolean isLiteral() {
        return this.kind == TokenKind.NUMBER || LITERALS.contains((Object)this);
    }

    public boolean isWrapper() {
        return this.wrapper;
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    public boolean isEmpty() {
        return this == EMPTY_TOKEN;
    }

    public static Lexer<MMToken> lexer() {
        return tokens.lexer();
    }

    @NotNull
    public static Option<MMToken> nodeFor(@NotNull FieldOption option) {
        return Option.ofNullable((Object)((Object)nodeForOption.get(option)));
    }

    public static Tokens<MMToken> tokens() {
        return tokens;
    }

    static {
        tokens = new Tokens<MMToken>(MMToken.class){

            public MMToken getHexInt() {
                return HEX_INT;
            }

            @NotNull
            public MMToken getDecInt() {
                return DEC_INT;
            }

            public MMToken getFixedDecimal() {
                return FIXED_POINT_DECIMAL;
            }

            @NotNull
            public MMToken getDouble() {
                return DOUBLE_LITERAL;
            }

            public MMToken getLineComment() {
                return LINE_COMMENT;
            }

            @NotNull
            public MMToken findKeyword(@NotNull String name) {
                MMToken value = (MMToken)((Object)this.keywordMap.get(name));
                return value != null ? value : (JavaReservedWords.isReserved((String)name) ? NULL : IDENTIFIER);
            }
        };
        nodeForOption = Maps.enumMap((Tuple)Tuple.tuple((Object)FieldOption.SUBFORM_ID, (Object)((Object)FORM_REF)), (Tuple[])new Tuple[]{Tuple.tuple((Object)FieldOption.ON_NEW_FORM, (Object)((Object)FORM_REF)), Tuple.tuple((Object)FieldOption.LINK_FORM, (Object)((Object)FORM_REF)), Tuple.tuple((Object)FieldOption.FORM, (Object)((Object)FORM_REF)), Tuple.tuple((Object)FieldOption.WIDGET_DEF, (Object)((Object)WIDGET_DEF_REF)), Tuple.tuple((Object)FieldOption.TASK, (Object)((Object)TASK_REF)), Tuple.tuple((Object)FieldOption.ON_NEW, (Object)((Object)METHOD_REF)), Tuple.tuple((Object)FieldOption.ON_SUGGEST, (Object)((Object)METHOD_REF)), Tuple.tuple((Object)FieldOption.ON_SUGGEST_SYNC, (Object)((Object)METHOD_REF)), Tuple.tuple((Object)FieldOption.ON_CLICK, (Object)((Object)METHOD_REF)), Tuple.tuple((Object)FieldOption.ON_SELECTION, (Object)((Object)METHOD_REF)), Tuple.tuple((Object)FieldOption.ON_CHANGE, (Object)((Object)METHOD_REF)), Tuple.tuple((Object)FieldOption.ON_BLUR, (Object)((Object)METHOD_REF)), Tuple.tuple((Object)FieldOption.ON_NEW_LOCATION, (Object)((Object)METHOD_REF)), Tuple.tuple((Object)FieldOption.ON_UI_CHANGE, (Object)((Object)METHOD_REF)), Tuple.tuple((Object)FieldOption.ON_LOAD, (Object)((Object)METHOD_REF)), Tuple.tuple((Object)FieldOption.ON_DISPLAY, (Object)((Object)METHOD_REF)), Tuple.tuple((Object)FieldOption.ON_INIT, (Object)((Object)METHOD_REF)), Tuple.tuple((Object)FieldOption.ON_STOP, (Object)((Object)METHOD_REF)), Tuple.tuple((Object)FieldOption.ON_CANCEL, (Object)((Object)METHOD_REF)), Tuple.tuple((Object)FieldOption.ON_SCHEDULE, (Object)((Object)METHOD_REF)), Tuple.tuple((Object)FieldOption.HANDLER, (Object)((Object)HANDLER)), Tuple.tuple((Object)FieldOption.FILE_TYPE, (Object)((Object)FILE_TYPE)), Tuple.tuple((Object)FieldOption.CHECK_TYPE, (Object)((Object)CHECK_TYPE)), Tuple.tuple((Object)FieldOption.MASK, (Object)((Object)MASK)), Tuple.tuple((Object)FieldOption.ICON, (Object)((Object)ICON)), Tuple.tuple((Object)FieldOption.QUERY_MODE, (Object)((Object)QUERY_MODE)), Tuple.tuple((Object)FieldOption.EXPORT_TYPE, (Object)((Object)EXPORT_TYPE)), Tuple.tuple((Object)FieldOption.ICON_SELECTED, (Object)((Object)ICON)), Tuple.tuple((Object)FieldOption.METHOD, (Object)((Object)HTTP_METHOD)), Tuple.tuple((Object)FieldOption.BUTTON_TYPE, (Object)((Object)BUTTON_TYPE)), Tuple.tuple((Object)FieldOption.TOGGLE_BUTTON_TYPE, (Object)((Object)TOGGLE_BUTTON_TYPE)), Tuple.tuple((Object)FieldOption.DATE_TYPE, (Object)((Object)DATE_TYPE)), Tuple.tuple((Object)FieldOption.TAB_TYPE, (Object)((Object)TAB_TYPE)), Tuple.tuple((Object)FieldOption.POPOVER_TYPE, (Object)((Object)POPOVER_TYPE)), Tuple.tuple((Object)FieldOption.MAIL_VALIDATION_TYPE, (Object)((Object)MAIL_VALIDATION_TYPE)), Tuple.tuple((Object)FieldOption.RATING_TYPE, (Object)((Object)RATING_TYPE)), Tuple.tuple((Object)FieldOption.MAP_TYPE, (Object)((Object)MAP_TYPE))});
        binaryOp = Maps.enumMap((Tuple)Tuple.tuple((Object)((Object)OR), (Object)BinaryExpression.Operator.OR), (Tuple[])new Tuple[]{Tuple.tuple((Object)((Object)AND), (Object)BinaryExpression.Operator.AND), Tuple.tuple((Object)((Object)EQ_EQ), (Object)BinaryExpression.Operator.EQ), Tuple.tuple((Object)((Object)NE), (Object)BinaryExpression.Operator.NE), Tuple.tuple((Object)((Object)GE), (Object)BinaryExpression.Operator.GE), Tuple.tuple((Object)((Object)GT), (Object)BinaryExpression.Operator.GT), Tuple.tuple((Object)((Object)LE), (Object)BinaryExpression.Operator.LE), Tuple.tuple((Object)((Object)LT), (Object)BinaryExpression.Operator.LT), Tuple.tuple((Object)((Object)PLUS), (Object)BinaryExpression.Operator.ADD), Tuple.tuple((Object)((Object)MINUS), (Object)BinaryExpression.Operator.SUB), Tuple.tuple((Object)((Object)ASTERISK), (Object)BinaryExpression.Operator.MUL), Tuple.tuple((Object)((Object)SLASH), (Object)BinaryExpression.Operator.DIV)});
        unaryOp = Maps.enumMap((Tuple)Tuple.tuple((Object)((Object)NOT), (Object)UnaryExpression.Operator.NOT), (Tuple[])new Tuple[]{Tuple.tuple((Object)((Object)UNARY_MINUS), (Object)UnaryExpression.Operator.MINUS), Tuple.tuple((Object)((Object)PLUS), (Object)UnaryExpression.Operator.PLUS)});
        LITERALS = EnumSet.of(NULL, STRING_LITERAL, TRUE, FALSE);
    }
}

