/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.mmcompiler.builder;

import java.io.PrintWriter;
import mulesoft.common.logging.Logger;
import mulesoft.metadata.exception.BuilderError;
import mulesoft.mmcompiler.ast.MetaModelAST;

public interface BuilderErrorListener {
    public void error(BuilderError var1);

    public void error(MetaModelAST var1, BuilderError var2);

    public boolean hasErrors();

    public static class Silent
    implements BuilderErrorListener {
        private int errors = 0;

        @Override
        public void error(BuilderError error) {
            ++this.errors;
        }

        @Override
        public void error(MetaModelAST node, BuilderError error) {
            ++this.errors;
        }

        @Override
        public boolean hasErrors() {
            return this.errors > 0;
        }
    }

    public static class DefaultWriter
    extends Silent {
        final PrintWriter writer;

        public DefaultWriter(PrintWriter writer) {
            this.writer = writer;
        }

        @Override
        public void error(BuilderError error) {
            super.error(error);
            this.writer.println(" error:  " + error.getMessage());
        }

        @Override
        public void error(MetaModelAST node, BuilderError error) {
            super.error(error);
            this.writer.println(node.getPosition().createMessage(error.getMessage()).getFormattedMessage());
        }
    }

    public static class Default
    extends Silent {
        private static final Logger logger = Logger.getLogger(Default.class);

        @Override
        public void error(BuilderError error) {
            super.error(error);
            logger.error(error.getMessage());
        }

        @Override
        public void error(MetaModelAST node, BuilderError error) {
            super.error(error);
            logger.error(node.getPosition().createMessage(error.getMessage()).getFormattedMessage());
        }
    }
}

