/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.mmcompiler.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Option;
import mulesoft.common.core.QName;
import mulesoft.common.core.StrBuilder;
import mulesoft.common.core.Tuple;
import mulesoft.common.logging.Logger;
import mulesoft.expr.exception.IllegalOperationException;
import mulesoft.metadata.common.ModelLinkerImpl;
import mulesoft.metadata.exception.BuilderError;
import mulesoft.metadata.exception.BuilderErrorException;
import mulesoft.metadata.exception.BuilderErrors;
import mulesoft.mmcompiler.ast.MMToken;
import mulesoft.mmcompiler.ast.MetaModelAST;
import mulesoft.mmcompiler.builder.BuilderErrorListener;
import mulesoft.mmcompiler.builder.EntityMaker;
import mulesoft.mmcompiler.builder.EnumMaker;
import mulesoft.mmcompiler.builder.Maker;
import mulesoft.mmcompiler.builder.QContext;
import mulesoft.mmcompiler.builder.TypeMaker;
import mulesoft.mmcompiler.builder.ViewMaker;
import mulesoft.mmcompiler.parser.ExpressionCompiler;
import mulesoft.repository.ModelRepository;
import mulesoft.type.MetaModel;
import mulesoft.type.ModelType;
import mulesoft.type.Names;
import mulesoft.type.exception.IllegalReferenceException;
import mulesoft.type.exception.UnresolvedTypeReferenceException;
import org.jetbrains.annotations.NotNull;

public class BuilderFromAST {
    @NotNull
    private final List<MetaModel> deletedModels;
    @NotNull
    private final BuilderErrorListener errorListener;
    @NotNull
    private final ModelLinkerImpl linker;
    @NotNull
    private final ModelRepository repository;
    @NotNull
    private final Map<QName, Tuple<MetaModel, MetaModelAST>> unresolvedModels;
    @NotNull
    private final List<ViewMaker> views;
    private static final Logger logger = Logger.getLogger(BuilderFromAST.class);

    public BuilderFromAST(@NotNull ModelRepository repository, @NotNull BuilderErrorListener errorListener) {
        this.repository = repository;
        this.errorListener = errorListener;
        this.unresolvedModels = new LinkedHashMap<QName, Tuple<MetaModel, MetaModelAST>>();
        this.views = new ArrayList<ViewMaker>();
        this.deletedModels = new ArrayList<MetaModel>();
        this.linker = new ModelLinkerImpl(repository);
    }

    public ModelRepository build(Iterable<Tuple<String, MetaModelAST>> trees) {
        for (Tuple<String, MetaModelAST> ast : trees) {
            this.buildEnumEntitiesAndTypes((String)ast.first(), (MetaModelAST)ast.second());
        }
        this.buildViews();
        this.linkModels();
        this.linker.setLastStage(true);
        this.linkModels();
        this.linker.setLastStage(false);
        this.linker.setLastStage(true);
        this.linkModels();
        this.updateReferences();
        return this.repository;
    }

    public ModelRepository build(String sourceName, MetaModelAST root) {
        return this.build((Iterable<Tuple<String, MetaModelAST>>)Colls.listOf((Object)Tuple.tuple((Object)sourceName, (Object)root)));
    }

    void addModel(MetaModel model, MetaModelAST id) {
        if (!this.link(model, id)) {
            this.unresolvedModels.put(model.getKey(), (Tuple<MetaModel, MetaModelAST>)Tuple.tuple((Object)model, (Object)id));
        }
        this.repository.add(model);
    }

    @NotNull
    BuilderErrorListener getErrorListener() {
        return this.errorListener;
    }

    @NotNull
    ModelRepository getRepository() {
        return this.repository;
    }

    private void buildEnumEntitiesAndTypes(String source, MetaModelAST root) {
        this.deletedModels.addAll((Collection<MetaModel>)this.repository.deleteAll(source));
        QContext context = this.retrieveQualificationContext(root);
        root.children(MMToken.TYPE).forEach(t -> new TypeMaker((MetaModelAST)t, this, source, context).make());
        root.children(MMToken.ENUM).forEach(t -> new EnumMaker((MetaModelAST)t, this, source, context).make());
        root.children(MMToken.ENTITY).forEach(t -> new EntityMaker((MetaModelAST)t, this, source, context).make());
        root.children(MMToken.VIEW).map(t -> new ViewMaker((MetaModelAST)t, this, source, context)).into(this.views);
    }

    private void buildViews() {
        this.views.forEach(Maker::make);
    }

    private void error(MetaModelAST node, BuilderError e) {
        this.getErrorListener().error(node, e);
    }

    private boolean link(MetaModel model, MetaModelAST node) {
        try {
            return this.linker.link(model);
        }
        catch (ExpressionCompiler.InvalidExpression e) {
            this.error(e.getExpressionAst(), e.getBuilderError());
        }
        catch (BuilderErrorException e) {
            this.error(node, e.getBuilderError());
        }
        catch (UnresolvedTypeReferenceException e) {
            this.error(node, BuilderErrors.createError((String)e.getMessage(), (String)e.getReference()));
        }
        catch (IllegalOperationException e) {
            this.error(node, (BuilderError)BuilderErrors.invalidExpression((String)e.getErrorMessage(), (String)node.getText()));
        }
        catch (IllegalReferenceException e) {
            this.error(node, BuilderErrors.createError((String)e.getMessage(), (String)node.getText()));
        }
        return false;
    }

    private void linkModels() {
        Iterator<Tuple<MetaModel, MetaModelAST>> iterator = this.unresolvedModels.values().iterator();
        while (iterator.hasNext()) {
            Tuple<MetaModel, MetaModelAST> t = iterator.next();
            MetaModel metaModel = (MetaModel)t.first();
            if (!this.link(metaModel, (MetaModelAST)t.second())) continue;
            iterator.remove();
        }
    }

    private List<String> retrieveImports(MetaModelAST root) {
        ArrayList<String> result = new ArrayList<String>();
        for (MetaModelAST child : root.children(MMToken.IMPORT)) {
            result.add(BuilderFromAST.retrieveReferenceQualifiedId(child));
        }
        return result;
    }

    private String retrievePackageId(MetaModelAST ast) {
        MetaModelAST packageNode = (MetaModelAST)ast.getChild(0);
        return packageNode.hasType(MMToken.PACKAGE) ? BuilderFromAST.retrieveReferenceQualifiedId(packageNode) : "";
    }

    private QContext retrieveQualificationContext(MetaModelAST root) {
        String packageId = this.retrievePackageId(root);
        String schemaId = this.retrieveSchemaId(root, packageId);
        List<String> imports = this.retrieveImports(root);
        return new QContext(packageId, schemaId, imports);
    }

    private String retrieveSchemaId(MetaModelAST root, String packageId) {
        String result = "";
        Option first = root.children(MMToken.SCHEMA).getFirst();
        if (first.isPresent()) {
            MetaModelAST schemaTree = (MetaModelAST)first.get();
            result = ((MetaModelAST)schemaTree.getChild(0)).getText();
        }
        return Names.validateSchemaId((String)result, (String)packageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateReferences() {
        try {
            for (MetaModel model : this.deletedModels) {
                Seq usages = model.getUsages();
                for (MetaModel usage : usages) {
                    this.linker.link(usage);
                }
                if (!this.repository.getModel(model.getKey()).isEmpty()) continue;
                for (MetaModel m : model.getReferences()) {
                    ((ModelType)m).removeUsage(model);
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        finally {
            this.deletedModels.clear();
        }
    }

    public static String retrieveReferenceQualifiedId(MetaModelAST t) {
        StrBuilder result = new StrBuilder();
        BuilderFromAST.retrieveReferenceQualifiedId(t, result);
        return result.toString();
    }

    private static void retrieveReferenceQualifiedId(MetaModelAST t, StrBuilder result) {
        Iterator iterator = t.iterator();
        while (iterator.hasNext()) {
            MetaModelAST node = (MetaModelAST)iterator.next();
            if (node.hasType(MMToken.REFERENCE)) {
                BuilderFromAST.retrieveReferenceQualifiedId(node, result);
                continue;
            }
            if (node.hasType(MMToken.IDENTIFIER)) {
                result.appendElement((Object)node.getText(), ".");
                continue;
            }
            throw Predefined.unreachable();
        }
    }
}

