/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.mmcompiler.builder;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableIterator;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Option;
import mulesoft.common.core.Strings;
import mulesoft.common.core.Tuple;
import mulesoft.field.FieldOption;
import mulesoft.field.ModelField;
import mulesoft.field.TypeField;
import mulesoft.lexer.TokenType;
import mulesoft.metadata.entity.CompositeBuilder;
import mulesoft.metadata.entity.CompositeFieldBuilder;
import mulesoft.metadata.entity.DbObjectBuilder;
import mulesoft.metadata.entity.SearchFieldBuilder;
import mulesoft.metadata.exception.BuilderError;
import mulesoft.metadata.exception.BuilderException;
import mulesoft.metadata.exception.UnsupportedOptionException;
import mulesoft.mmcompiler.ast.MMToken;
import mulesoft.mmcompiler.ast.MetaModelAST;
import mulesoft.mmcompiler.builder.ASTUnresolvedTypeReference;
import mulesoft.mmcompiler.builder.BuilderFromAST;
import mulesoft.mmcompiler.builder.Maker;
import mulesoft.mmcompiler.builder.QContext;
import mulesoft.parser.ASTNode;
import mulesoft.type.FieldReference;
import mulesoft.type.MetaModel;
import mulesoft.type.Type;
import mulesoft.type.Types;
import org.jetbrains.annotations.NotNull;

abstract class CompositeMaker<M extends MetaModel, F extends TypeField, FB extends CompositeFieldBuilder<FB>>
extends Maker {
    CompositeMaker(MetaModelAST entityNode, BuilderFromAST builderFromAST, String sourceName, QContext context) {
        super(entityNode, builderFromAST, sourceName, context);
    }

    void addDocumentation(FB builder, MetaModelAST fieldNode) {
        fieldNode.children(MMToken.DOCUMENTATION).getFirst().ifPresent(n -> this.buildFieldDocumentation(builder, (MetaModelAST)n));
    }

    void addField(CompositeBuilder<M, F, FB, ?> builder, MetaModelAST field, String name) {
        try {
            builder.addField(this.buildField(name, field));
        }
        catch (BuilderException e) {
            this.error(field, (BuilderError)e);
        }
    }

    void addOptions(FB builder, Type type, MetaModelAST fieldNode) {
        Iterator iterator = fieldNode.iterator();
        while (iterator.hasNext()) {
            MetaModelAST n = (MetaModelAST)iterator.next();
            try {
                if (!n.hasType(MMToken.OPTION)) continue;
                this.buildFieldOption(builder, n, type.getFinalType());
            }
            catch (BuilderException e) {
                this.error(n, (BuilderError)e);
            }
        }
    }

    void addSearchable(@NotNull DbObjectBuilder<M, F, FB, ?> builder, @NotNull MetaModelAST node) {
        if (this.retrieveSearchableDatabase(node)) {
            builder.searchByDatabase();
        }
        this.searchByFields(builder, node);
        builder.defaultSearchable();
    }

    FB buildField(String name, MetaModelAST fieldNode) {
        ASTNode.Utils.assertType((ASTNode)fieldNode, (TokenType)MMToken.FIELD);
        Tuple<MetaModelAST, String> idLabel = this.retrieveLabeledId(fieldNode);
        String fieldName = ((MetaModelAST)idLabel.first()).getText();
        Type type = this.retrieveNotNullType(fieldNode, fieldName, new TypeProcessRef());
        FB builder = this.createField(fieldName, type);
        this.addDocumentation(builder, fieldNode);
        this.addOptions(builder, type, fieldNode);
        return (FB)((CompositeFieldBuilder)Predefined.cast(builder));
    }

    abstract FB createField(String var1, Type var2);

    Tuple<String, Collection<ModelField>> getIndex(MetaModelAST node) {
        Seq identifier = node.children(MMToken.IDENTIFIER);
        Seq refs = node.children(MMToken.FIELD_REF);
        Option first = identifier.getFirst();
        String id = first.isPresent() ? ((MetaModelAST)((MetaModelAST)first.get()).getChild(0)).getText() : ((MetaModelAST)((MetaModelAST)refs.getFirst().get()).getChild(0)).getText();
        return Tuple.tuple((Object)id, this.retrieveFieldIds(node, (Seq<MetaModelAST>)refs).values());
    }

    private void addSearchableOption(SearchFieldBuilder builder, MetaModelAST n) throws BuilderException {
        FieldOption opt = this.retrieveOption(n);
        if (opt == null) {
            return;
        }
        switch (opt) {
            case FILTER_ONLY: 
            case ANALYZED: 
            case PREFIX: {
                builder.with(opt);
                break;
            }
            case FUZZY: 
            case BOOST: 
            case SLOP: {
                builder.with(opt, Strings.parseAsInt((String)((MetaModelAST)n.getChild(1)).getText(), (int)0));
                break;
            }
            default: {
                this.error(n, (BuilderError)new UnsupportedOptionException(opt));
            }
        }
    }

    private void buildFieldDocumentation(FB builder, MetaModelAST documentationNode) {
        builder.withFieldDocumentation(this.getDocumentationText(documentationNode));
    }

    private void buildFieldOption(FB builder, MetaModelAST n, Type type) throws BuilderException {
        FieldOption opt = this.retrieveOption(n);
        if (opt == null) {
            return;
        }
        switch (opt) {
            case CHECK: {
                Iterator iterator = ((MetaModelAST)n.getChild(1)).iterator();
                while (iterator.hasNext()) {
                    MetaModelAST c = (MetaModelAST)iterator.next();
                    builder.check(this.getAsExpression((MetaModelAST)c.getChild(0), (Type)Types.booleanType()), Strings.decode((String)((MetaModelAST)c.getChild(3)).getText()));
                }
                break;
            }
            case DEFAULT: {
                builder.defaultValue(this.getAsExpression((MetaModelAST)n.getChild(1), type));
                break;
            }
            case OPTIONAL: {
                builder.optional();
                break;
            }
            case SIGNED: 
            case PROTECTED: 
            case ABSTRACT: 
            case READ_ONLY: {
                builder.with(opt);
                break;
            }
            case COLUMN: {
                builder.withOption(opt, this.buildIdList(((MetaModelAST)n.getChild(1)).getEffectiveNode()));
                break;
            }
            case SERIAL: {
                builder.serial(((MetaModelAST)n.getChild(1)).getText());
                break;
            }
            case START_WITH: {
                builder.withOption(opt, (Object)Strings.parseAsInt((String)((MetaModelAST)n.getChild(1)).getText(), (int)1));
                break;
            }
        }
    }

    private ImmutableList<String> buildIdList(MetaModelAST cols) {
        if (!cols.hasType(MMToken.LIST)) {
            return Colls.listOf((Object)cols.getText());
        }
        ImmutableList.Builder list = ImmutableList.builder();
        Iterator iterator = cols.iterator();
        while (iterator.hasNext()) {
            MetaModelAST col = (MetaModelAST)iterator.next();
            list.add((Object)col.getText());
        }
        return list.build();
    }

    @NotNull
    private SearchFieldBuilder buildSearchableField(@NotNull MetaModelAST field) {
        String id = this.retrieveId(field);
        String name = this.retrieveRefId(field);
        SearchFieldBuilder b = new SearchFieldBuilder((ModelField)FieldReference.unresolvedFieldRef((String)name), Predefined.notEmpty((String)id, (String)name));
        for (MetaModelAST opt : field.children(MMToken.OPTION)) {
            try {
                this.addSearchableOption(b, opt);
            }
            catch (BuilderException e) {
                this.error(opt, (BuilderError)e);
            }
        }
        return b;
    }

    @NotNull
    private String retrieveRefId(@NotNull MetaModelAST fieldNode) {
        for (MetaModelAST ref : fieldNode.children(MMToken.FIELD_REF)) {
            ImmutableIterator immutableIterator = ref.children(MMToken.IDENTIFIER).iterator();
            if (!immutableIterator.hasNext()) continue;
            MetaModelAST id = (MetaModelAST)immutableIterator.next();
            return id.getText();
        }
        return "";
    }

    private boolean retrieveSearchableDatabase(@NotNull MetaModelAST node) {
        return !node.children(MMToken.DATABASE).isEmpty();
    }

    private void searchByFields(@NotNull DbObjectBuilder<M, F, FB, ?> builder, @NotNull MetaModelAST node) {
        Option fieldList = node.children(MMToken.LIST).getFirst();
        if (fieldList.isPresent()) {
            for (MetaModelAST field : ((MetaModelAST)fieldList.get()).children(MMToken.FIELD)) {
                try {
                    builder.addSearchableField(this.buildSearchableField(field));
                }
                catch (BuilderException e) {
                    this.error(field, (BuilderError)e);
                }
            }
        }
    }

    private class TypeProcessRef
    implements Function<MetaModelAST, Type> {
        private TypeProcessRef() {
        }

        @Override
        public Type apply(MetaModelAST typeNode) {
            MetaModelAST ref = (MetaModelAST)typeNode.getChild(0);
            boolean multiple = ((MetaModelAST)typeNode.getChild(1)).hasType(MMToken.ASTERISK);
            return new ASTUnresolvedTypeReference(CompositeMaker.this, CompositeMaker.this.sourceName, CompositeMaker.this.context, BuilderFromAST.retrieveReferenceQualifiedId(ref), ref, multiple);
        }
    }
}

