/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.mmcompiler.builder;

import java.util.Collection;
import java.util.EnumSet;
import java.util.function.Function;
import mulesoft.common.core.QName;
import mulesoft.common.core.Tuple;
import mulesoft.field.ModelField;
import mulesoft.lexer.TokenType;
import mulesoft.metadata.common.ModelBuilder;
import mulesoft.metadata.entity.Attribute;
import mulesoft.metadata.entity.AttributeBuilder;
import mulesoft.metadata.entity.Entity;
import mulesoft.metadata.entity.EntityBuilder;
import mulesoft.metadata.exception.BuilderError;
import mulesoft.metadata.exception.BuilderException;
import mulesoft.mmcompiler.ast.MMToken;
import mulesoft.mmcompiler.ast.MetaModelAST;
import mulesoft.mmcompiler.builder.ASTFieldReference;
import mulesoft.mmcompiler.builder.ASTUnresolvedTypeReference;
import mulesoft.mmcompiler.builder.BuilderFromAST;
import mulesoft.mmcompiler.builder.CompositeMaker;
import mulesoft.mmcompiler.builder.QContext;
import mulesoft.parser.ASTNode;
import mulesoft.type.Modifier;
import mulesoft.type.Type;
import org.jetbrains.annotations.NotNull;

class EntityMaker
extends CompositeMaker<Entity, Attribute, AttributeBuilder> {
    @NotNull
    private String parent = "";

    EntityMaker(MetaModelAST entityNode, BuilderFromAST builderFromAST, String sourceName, QContext context) {
        super(entityNode, builderFromAST, sourceName, context);
    }

    @Override
    protected AttributeBuilder buildField(String entityName, MetaModelAST fieldNode) {
        ASTNode.Utils.assertType((ASTNode)fieldNode, (TokenType)MMToken.FIELD);
        Tuple<MetaModelAST, String> idLabel = this.retrieveLabeledId(fieldNode);
        String fieldName = ((MetaModelAST)idLabel.first()).getText();
        EntityProcessRef refHandler = new EntityProcessRef(entityName);
        Type type = this.retrieveNotNullType(fieldNode, fieldName, refHandler);
        AttributeBuilder builder = EntityBuilder.createAttribute((String)fieldName, (Type)type);
        if (refHandler.multiple) {
            builder.multiple();
        }
        if (refHandler.inner) {
            builder.inner();
        }
        builder.description((String)idLabel.second()).withReverseReference(refHandler.getReverse());
        this.addOptions(builder, type, fieldNode);
        this.addDocumentation(builder, fieldNode);
        return builder;
    }

    protected EntityBuilder createBuilder(QName fqn, String label, EnumSet<Modifier> modifiers) {
        EntityBuilder builder = (EntityBuilder)((EntityBuilder)EntityBuilder.entity((String)this.sourceName, (String)fqn.getQualification(), (String)fqn.getName(), (String)this.parent, (String)this.context.getSchema()).label(label)).withModifiers(modifiers);
        this.rootNode.forEach(n -> this.addEntityOption(builder, fqn.getName(), (MetaModelAST)n));
        this.checkBuilder((ModelBuilder<?, ?>)builder);
        return builder;
    }

    @Override
    AttributeBuilder createField(String nm, Type type) {
        return EntityBuilder.createAttribute((String)nm, (Type)type);
    }

    private void addEntityOption(EntityBuilder builder, String name, MetaModelAST node) {
        switch ((MMToken)node.getType()) {
            case DESCRIBED_BY: {
                builder.describedBy(this.retrieveFieldIds(node).values());
                break;
            }
            case IMAGE: {
                MetaModelAST image = (MetaModelAST)((MetaModelAST)node.getChild(0)).getChild(0);
                builder.image((ModelField)new ASTFieldReference(image.getText(), this, image));
                break;
            }
            case UNIQUE: {
                Tuple<String, Collection<ModelField>> uniqueIndex = this.getIndex(node);
                try {
                    builder.withUnique((String)uniqueIndex.first(), (Collection)uniqueIndex.second());
                }
                catch (BuilderException e) {
                    this.error(node, (BuilderError)e);
                }
                break;
            }
            case INDEX: {
                Tuple<String, Collection<ModelField>> index = this.getIndex(node);
                try {
                    builder.withIndex((String)index.first(), (Collection)index.second());
                }
                catch (BuilderException e) {
                    this.error(node, (BuilderError)e);
                }
                break;
            }
            case SEARCHABLE: {
                this.addSearchable(builder, node);
                break;
            }
            case DEPRECABLE: {
                builder.deprecable();
                break;
            }
            case AUDITABLE: {
                builder.auditable();
                break;
            }
            case REMOTABLE: {
                builder.remotable();
                break;
            }
            case OPTIMISTIC: {
                builder.optimistic();
                break;
            }
            case CACHE: {
                MetaModelAST child = (MetaModelAST)node.getChild(0);
                if (child.isEmpty()) {
                    builder.cached();
                    break;
                }
                String text = child.getText();
                if (text.equals(MMToken.ALL.getText())) {
                    builder.fullyCached();
                    break;
                }
                builder.cached(Integer.parseInt(text));
                break;
            }
            case TABLE: {
                String s = ((MetaModelAST)node.getChild(0)).getText();
                String t = ((MetaModelAST)node.getChild(1)).getText();
                builder.databaseName(t.isEmpty() ? QName.createQName((String)s) : QName.createQName((String)s, (String)t));
                break;
            }
            case PRIMARY_KEY: {
                builder.primaryKey(this.retrieveFieldIds(node).values());
                break;
            }
            case FORM_REF: {
                builder.defaultForm(((MetaModelAST)node.getChild(0)).getText());
                break;
            }
            case LIST: {
                for (MetaModelAST field : node.children(MMToken.FIELD)) {
                    this.addField(builder, field, name);
                }
                break;
            }
        }
    }

    private class EntityProcessRef
    implements Function<MetaModelAST, Type> {
        private final String entityName;
        private boolean inner;
        private boolean multiple;
        private String reverse;

        public EntityProcessRef(String entityName) {
            this.entityName = entityName;
            this.multiple = false;
            this.reverse = "";
        }

        @Override
        public Type apply(MetaModelAST typeNode) {
            String refName;
            int entityIdx = ((MetaModelAST)typeNode.getChild(0)).hasType(MMToken.DOCUMENTATION) ? 1 : 0;
            MetaModelAST typeRefNode = (MetaModelAST)typeNode.getChild(entityIdx);
            if (typeNode.hasType(MMToken.ENTITY)) {
                EntityMaker maker = new EntityMaker(typeNode, EntityMaker.this.builderFromAST, EntityMaker.this.sourceName, EntityMaker.this.context);
                maker.parent = this.entityName;
                maker.make();
                this.inner = true;
                this.multiple = this.hasMultipleMark(typeRefNode, 1);
                refName = ((MetaModelAST)typeRefNode.getChild(0)).getText();
            } else {
                this.multiple = this.hasMultipleMark(typeNode, entityIdx + 1);
                this.reverse = ((MetaModelAST)typeNode.getChild(entityIdx + (this.multiple ? 2 : 1))).getText();
                refName = BuilderFromAST.retrieveReferenceQualifiedId(typeRefNode);
            }
            return new ASTUnresolvedTypeReference(EntityMaker.this, EntityMaker.this.sourceName, EntityMaker.this.context, refName, typeRefNode);
        }

        public boolean isMultiple() {
            return this.multiple;
        }

        public String getReverse() {
            return this.reverse;
        }

        private boolean hasMultipleMark(MetaModelAST typeNode, int child) {
            return ((MetaModelAST)typeNode.getChild(child)).hasType(MMToken.ASTERISK);
        }
    }
}

