/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.mmcompiler.builder;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.Iterator;
import mulesoft.common.collections.ImmutableCollection;
import mulesoft.common.collections.ImmutableIterator;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.QName;
import mulesoft.common.core.Strings;
import mulesoft.field.TypeField;
import mulesoft.metadata.common.ModelBuilder;
import mulesoft.metadata.entity.EnumBuilder;
import mulesoft.metadata.entity.TypeFieldBuilder;
import mulesoft.metadata.exception.BuilderErrors;
import mulesoft.mmcompiler.ast.MMToken;
import mulesoft.mmcompiler.ast.MetaModelAST;
import mulesoft.mmcompiler.builder.BuilderFromAST;
import mulesoft.mmcompiler.builder.CompositeMaker;
import mulesoft.mmcompiler.builder.QContext;
import mulesoft.type.EnumType;
import mulesoft.type.Modifier;
import mulesoft.type.Type;

class EnumMaker
extends CompositeMaker<EnumType, TypeField, TypeFieldBuilder> {
    EnumMaker(MetaModelAST enumNode, BuilderFromAST builderFromAST, String sourceName, QContext context) {
        super(enumNode, builderFromAST, sourceName, context);
    }

    protected EnumBuilder createBuilder(QName fqn, String label, EnumSet<Modifier> modifiers) {
        EnumBuilder builder = (EnumBuilder)((EnumBuilder)EnumBuilder.enumType((String)this.sourceName, (String)fqn.getQualification(), (String)fqn.getName()).label(label)).withModifiers(modifiers);
        Iterator iterator = this.rootNode.iterator();
        block8: while (iterator.hasNext()) {
            MetaModelAST node = (MetaModelAST)iterator.next();
            switch ((MMToken)node.getType()) {
                case DEFAULT: {
                    builder.withDefault(((MetaModelAST)((MetaModelAST)node.getChild(0)).getChild(0)).getText());
                    break;
                }
                case PRIMARY_KEY: {
                    builder.withPrimaryKey(((MetaModelAST)((MetaModelAST)node.getChild(0)).getChild(0)).getText());
                    break;
                }
                case INDEX: {
                    builder.withIndex(((MetaModelAST)((MetaModelAST)node.getChild(0)).getChild(0)).getText());
                    break;
                }
                case WITH: {
                    for (MetaModelAST field : node.children(MMToken.FIELD)) {
                        this.addField(builder, field, fqn.getName());
                    }
                    continue block8;
                }
                case IMPLEMENTS: {
                    for (MetaModelAST clazz : node.children(MMToken.CLASS)) {
                        builder.withInterface(BuilderFromAST.retrieveReferenceQualifiedId(clazz));
                    }
                    continue block8;
                }
                case LIST: {
                    for (MetaModelAST e : node.children(MMToken.ENUM_FIELD)) {
                        MetaModelAST enumValue = (MetaModelAST)e.getChild(0);
                        MetaModelAST key = (MetaModelAST)enumValue.getChild(0);
                        if (key.isEmpty()) continue;
                        this.parseEnumValue(builder, key.getText(), e);
                    }
                    continue block8;
                }
            }
        }
        this.checkBuilder((ModelBuilder<?, ?>)builder);
        return builder;
    }

    @Override
    TypeFieldBuilder createField(String nm, Type type) {
        return new TypeFieldBuilder(nm, type);
    }

    private void parseEnumValue(EnumBuilder builder, String id, MetaModelAST e) {
        MetaModelAST desc = (MetaModelAST)e.getChild(1);
        if (desc.isEmpty() || desc.hasType(MMToken.DOCUMENTATION)) {
            this.parseValue(builder, id, "", EnumType.SERIALIZABLES, e);
        } else {
            ImmutableCollection fields = builder.getFields();
            String label = Strings.decode((String)desc.getText());
            if (fields.isEmpty()) {
                this.parseValue(builder, id, label, EnumType.SERIALIZABLES, e);
            } else {
                Iterator it = ((MetaModelAST)e.getChild(2)).iterator();
                Serializable[] values = new Serializable[fields.size()];
                int i = 0;
                for (TypeFieldBuilder field : fields) {
                    if (!it.hasNext()) {
                        if (field.isOptional()) {
                            values[i++] = null;
                            continue;
                        }
                        this.error(e, BuilderErrors.missingEnumValue((String)builder.getFullName(), (String)field.getName()));
                        break;
                    }
                    values[i++] = this.getAsExpression((MetaModelAST)it.next(), field.getType());
                }
                if (it.hasNext()) {
                    MetaModelAST next = (MetaModelAST)it.next();
                    this.error(next, BuilderErrors.extraEnumValue((String)next.getText(), (String)builder.getFullName()));
                }
                this.parseValue(builder, id, label, values, e);
            }
            if (128 < label.length()) {
                this.error(desc, BuilderErrors.enumValueLabelIsTooLong((String)label));
            }
        }
        if (50 < id.length()) {
            this.error((MetaModelAST)e.getChild(0), BuilderErrors.enumValueKeyIsTooLong((String)id));
        }
    }

    private void parseValue(EnumBuilder builder, String id, String label, Serializable[] values, MetaModelAST e) {
        Seq children = e.children(MMToken.DOCUMENTATION);
        if (children.isEmpty()) {
            builder.value(id, label, values);
        } else {
            ImmutableIterator immutableIterator = children.iterator();
            if (immutableIterator.hasNext()) {
                MetaModelAST doc = (MetaModelAST)immutableIterator.next();
                builder.value(id, label, this.getDocumentationText(doc), values);
                return;
            }
        }
    }
}

