/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.mmcompiler.builder;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Option;
import mulesoft.common.core.QName;
import mulesoft.common.core.StrBuilder;
import mulesoft.common.core.Strings;
import mulesoft.common.core.Tuple;
import mulesoft.common.core.enumeration.Enumerations;
import mulesoft.common.util.JavaReservedWords;
import mulesoft.expr.Expression;
import mulesoft.expr.exception.IllegalOperationException;
import mulesoft.field.FieldOption;
import mulesoft.field.ModelField;
import mulesoft.metadata.common.ModelBuilder;
import mulesoft.metadata.entity.SimpleType;
import mulesoft.metadata.exception.BuilderError;
import mulesoft.metadata.exception.BuilderErrors;
import mulesoft.metadata.exception.BuilderException;
import mulesoft.metadata.exception.DuplicateAttributeException;
import mulesoft.metadata.exception.NullableInPrimaryKeyException;
import mulesoft.metadata.exception.UnmappedReferenceException;
import mulesoft.mmcompiler.ast.MMToken;
import mulesoft.mmcompiler.ast.MetaModelAST;
import mulesoft.mmcompiler.builder.ASTFieldReference;
import mulesoft.mmcompiler.builder.BuilderErrorListener;
import mulesoft.mmcompiler.builder.BuilderFromAST;
import mulesoft.mmcompiler.builder.QContext;
import mulesoft.mmcompiler.parser.ExpressionCompiler;
import mulesoft.parser.ASTNode;
import mulesoft.repository.ModelRepository;
import mulesoft.type.MetaModel;
import mulesoft.type.Modifier;
import mulesoft.type.Type;
import mulesoft.type.Types;
import mulesoft.type.UnresolvedTypeReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class Maker {
    @NotNull
    BuilderFromAST builderFromAST;
    @NotNull
    final QContext context;
    @NotNull
    String documentation;
    @NotNull
    ModelRepository repository;
    @NotNull
    MetaModelAST rootNode;
    @NotNull
    String sourceName;
    @NotNull
    private final Tuple<MetaModelAST, String> idLabel;
    @NotNull
    private final QName modelName;

    Maker(@NotNull MetaModelAST rootNode, @NotNull BuilderFromAST builderFromAST, @NotNull String sourceName, @NotNull QContext context) {
        this.builderFromAST = builderFromAST;
        this.sourceName = sourceName;
        this.context = context;
        this.rootNode = rootNode;
        this.repository = builderFromAST.getRepository();
        this.idLabel = this.retrieveLabeledId(rootNode);
        MetaModelAST id = (MetaModelAST)this.idLabel.first();
        this.modelName = context.withPackage(id.getText());
        this.documentation = this.retrieveDocumentation();
    }

    public String toString() {
        return this.modelName.toString();
    }

    protected abstract ModelBuilder<?, ?> createBuilder(QName var1, String var2, EnumSet<Modifier> var3);

    void checkBuilder(ModelBuilder<?, ?> builder) {
        for (BuilderError error : builder.check()) {
            if (error instanceof NullableInPrimaryKeyException) {
                this.error(error);
                continue;
            }
            if (((MetaModelAST)this.rootNode.getChild(0)).isEmpty()) {
                this.error(this.rootNode, error);
                continue;
            }
            this.error((MetaModelAST)this.rootNode.getChild(0), error);
        }
    }

    void error(MetaModelAST node, BuilderError e) {
        this.getErrorListener().error(node, e);
    }

    void make() {
        MetaModelAST id = (MetaModelAST)this.idLabel.first();
        String idText = id.getText();
        if (Predefined.isEmpty((String)idText)) {
            return;
        }
        if (Character.isLowerCase(idText.charAt(0))) {
            this.error(id, BuilderErrors.lowerCaseModel((String)idText));
            return;
        }
        if (JavaReservedWords.isReserved((String)Strings.deCapitalizeFirst((String)idText))) {
            this.error(id, BuilderErrors.javaReservedWordModel((String)idText));
            return;
        }
        try {
            MetaModel build = this.createBuilder(this.modelName, (String)this.idLabel.second(), this.retrieveModifiers(this.rootNode)).withDocumentation(this.documentation).build();
            this.builderFromAST.addModel(build, id);
        }
        catch (BuilderException e) {
            this.error(id, (BuilderError)e);
        }
        catch (ExpressionCompiler.InvalidExpression e) {
            this.error(e.getExpressionAst(), e.getBuilderError());
        }
        catch (UnmappedReferenceException e) {
            this.error(id, (BuilderError)e.getCause());
        }
        catch (IllegalOperationException e) {
            this.error(id, (BuilderError)BuilderErrors.invalidExpression((String)e.getErrorMessage(), (String)idText));
        }
    }

    @NotNull
    <T extends Enum<T>> Option<T> retrieveEnumValue(Class<T> enumeration, MetaModelAST node) {
        String text = Predefined.notEmpty((String)node.getText(), (String)"");
        try {
            return Option.some((Object)Enumerations.valueOf(enumeration, (String)text.toUpperCase()));
        }
        catch (IllegalArgumentException e) {
            this.error(node, (BuilderError)BuilderErrors.illegalEnumValue(enumeration, (String)text));
            return Option.empty();
        }
    }

    Map<String, ModelField> retrieveFieldIds(MetaModelAST node) {
        return this.retrieveFieldIds(node, (Seq<MetaModelAST>)node.children());
    }

    @NotNull
    Map<String, ModelField> retrieveFieldIds(MetaModelAST mainNode, Seq<MetaModelAST> children) {
        LinkedHashMap<String, ModelField> result = new LinkedHashMap<String, ModelField>();
        for (MetaModelAST n : children) {
            String id = ((MetaModelAST)n.getChild(0)).getText();
            if (id.isEmpty()) continue;
            if (result.containsKey(id)) {
                this.error(n, (BuilderError)new DuplicateAttributeException(id, ((MMToken)mainNode.getType()).getText(), ""));
                continue;
            }
            result.put(id, (ModelField)new ASTFieldReference(id, this, n));
        }
        return result;
    }

    @Nullable
    String retrieveId(MetaModelAST node) {
        Seq children = node.children(MMToken.IDENTIFIER);
        if (children.size() == 1) {
            return ((MetaModelAST)children.getFirst().get()).getText();
        }
        return null;
    }

    Tuple<MetaModelAST, String> retrieveLabeledId(MetaModelAST node) {
        MetaModelAST id = (MetaModelAST)node.getEmptyNode();
        String label = "";
        for (MetaModelAST child : node.children(MMToken.LABELED_ID)) {
            Iterator iterator = child.iterator();
            while (iterator.hasNext()) {
                MetaModelAST a = (MetaModelAST)iterator.next();
                if (a.hasType(MMToken.IDENTIFIER)) {
                    id = a;
                    continue;
                }
                if (!a.hasType(MMToken.STRING_LITERAL)) continue;
                label = Strings.decode((String)a.getText());
            }
        }
        return Tuple.tuple((Object)id, (Object)label);
    }

    @NotNull
    Type retrieveNotNullType(MetaModelAST fieldNode, String fieldName, @NotNull Function<MetaModelAST, Type> refHandler) {
        Type type = this.retrieveType(fieldNode, refHandler);
        if (type == null) {
            this.error(fieldNode, BuilderErrors.unspecifiedType((String)fieldName));
            this.retrieveType(fieldNode, refHandler);
            type = Types.stringType();
        }
        return type;
    }

    @Nullable
    FieldOption retrieveOption(MetaModelAST n) {
        String optionName = ((MetaModelAST)n.getChild(0)).getText();
        FieldOption opt = FieldOption.fromId((String)optionName);
        if (opt != null) {
            return opt;
        }
        this.error(n, BuilderErrors.invalidOption((String)optionName));
        return null;
    }

    @Nullable
    Type retrieveType(MetaModelAST fieldNode, @NotNull Function<MetaModelAST, Type> refHandler) {
        for (MetaModelAST child : fieldNode.children()) {
            if (child.hasType(MMToken.ENTITY) || child.hasType(MMToken.ENUM)) {
                return refHandler.apply(child);
            }
            if (!child.hasType(MMToken.TYPE_NODE)) continue;
            MetaModelAST t = (MetaModelAST)child.getChild(0);
            return t.hasType(MMToken.TYPE_REF) || t.hasType(MMToken.STRUCT_REF) ? refHandler.apply(child) : this.retrieveType(child);
        }
        return null;
    }

    @Nullable
    String retrieveUsing(MetaModelAST node) {
        Seq children = node.children(MMToken.CLASS);
        if (children.size() == 1) {
            MetaModelAST metaModelAST = (MetaModelAST)Colls.first((Iterable)children).get();
            String name = BuilderFromAST.retrieveReferenceQualifiedId(metaModelAST);
            return name.isEmpty() ? name : this.context.withPackage(name).getFullName();
        }
        return null;
    }

    @NotNull
    Expression getAsExpression(MetaModelAST element, Type resultType) {
        return this.getAsExpression(element, resultType, null, null);
    }

    @NotNull
    Expression getAsExpression(MetaModelAST element, @NotNull Expression defaultValue) {
        return this.getAsExpression(element, defaultValue.getType(), defaultValue);
    }

    @NotNull
    Expression getAsExpression(@NotNull MetaModelAST element, @NotNull Type resultType, @Nullable Type innerExprType) {
        return this.getAsExpression(element, resultType, null, innerExprType);
    }

    @NotNull
    String getDocumentationText(MetaModelAST ast) {
        if (!ast.hasType(MMToken.DOCUMENTATION)) {
            return "";
        }
        String text = ((MetaModelAST)ast.getChild(0)).getText();
        return text.startsWith("//-") ? text.substring(3).trim() : Strings.unCommentText((String)text);
    }

    <T extends MetaModel> Option<T> getMetaModelReference(Class<T> clazz, MetaModelAST n) {
        String name = BuilderFromAST.retrieveReferenceQualifiedId(n);
        Option model = this.repository.getModel(this.context.extractQualification(name), this.context.extractName(name), clazz);
        if (model.isEmpty()) {
            this.error(n, (BuilderError)BuilderErrors.unresolvedReference((String)name));
        }
        return model;
    }

    <T extends MetaModel> Option<T> getMetaModelReferenceCheckType(Class<T> clazz, MetaModelAST n) {
        String name = BuilderFromAST.retrieveReferenceQualifiedId(n);
        Option model = this.repository.getModel(this.context.extractQualification(name), this.context.extractName(name));
        if (model.isEmpty()) {
            this.error((MetaModelAST)n.getChild(0), (BuilderError)BuilderErrors.unresolvedReference((String)name));
            return Option.empty();
        }
        Option result = model.castTo(clazz);
        MetaModel type = (MetaModel)model.get();
        if (result.isEmpty() && type instanceof SimpleType) {
            Type ft = ((SimpleType)type).getFinalType();
            result = ft instanceof UnresolvedTypeReference ? this.repository.getModel(((UnresolvedTypeReference)ft).getKey()).castTo(clazz) : Option.some((Object)ft).castTo(clazz);
        }
        return result;
    }

    String getName() {
        return this.modelName.getName();
    }

    Type getTypeFromString(String typeName) {
        return Types.fromString((String)typeName);
    }

    private void error(BuilderError e) {
        this.getErrorListener().error(e);
    }

    @NotNull
    private String retrieveDocumentation() {
        for (MetaModelAST ast : this.rootNode.children(MMToken.DOCUMENTATION)) {
            if (!ast.hasType(MMToken.DOCUMENTATION)) continue;
            return this.getDocumentationText(ast);
        }
        return "";
    }

    private EnumSet<Modifier> retrieveModifiers(MetaModelAST node) {
        EnumSet result = Modifier.emptySet();
        for (MetaModelAST modifiers : node.children(MMToken.MODIFIERS)) {
            Iterator iterator = modifiers.iterator();
            while (iterator.hasNext()) {
                MetaModelAST m = (MetaModelAST)iterator.next();
                Modifier e = Modifier.fromId((String)m.getText());
                if (e == null) continue;
                result.add(e);
            }
        }
        return result;
    }

    @Nullable
    private Type retrieveType(MetaModelAST node) {
        MetaModelAST t = (MetaModelAST)node.getChild(0);
        String typeName = BuilderFromAST.retrieveReferenceQualifiedId(t);
        Type type = this.getTypeFromString(typeName);
        if (type == Types.nullType()) {
            this.error(t, BuilderErrors.unexpectedType((String)typeName));
            return null;
        }
        MetaModelAST next = (MetaModelAST)node.getChild(1);
        if (next.hasType(MMToken.LIST)) {
            type = type.applyParameters(ASTNode.Utils.childrenAsStrings((ASTNode)node.getChild(1)));
            next = (MetaModelAST)node.getChild(2);
        }
        return next.hasType(MMToken.ASTERISK) ? Types.arrayType((Type)type) : type;
    }

    @NotNull
    private Expression getAsExpression(@NotNull MetaModelAST element, @NotNull Type resultType, @Nullable Expression defaultValue) {
        return this.getAsExpression(element, resultType, defaultValue, null);
    }

    @NotNull
    private Expression getAsExpression(@NotNull MetaModelAST element, @NotNull Type resultType, @Nullable Expression defaultValue, @Nullable Type innerExprType) {
        Expression e;
        Expression expression = e = element.isEmpty() ? defaultValue : ExpressionCompiler.buildExpression(element, resultType, innerExprType).createExpression();
        if (e == null) {
            throw new ExpressionCompiler.InvalidExpression(element);
        }
        return e;
    }

    @NotNull
    private BuilderErrorListener getErrorListener() {
        return this.builderFromAST.getErrorListener();
    }

    static String retrieveNodeText(MetaModelAST t) {
        StrBuilder result = new StrBuilder();
        Iterator iterator = t.iterator();
        while (iterator.hasNext()) {
            MetaModelAST id = (MetaModelAST)iterator.next();
            result.appendElement((Object)id.getText(), ".");
        }
        return result.toString();
    }
}

