/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.mmcompiler.builder;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mulesoft.common.Predefined;
import mulesoft.common.core.QName;
import org.jetbrains.annotations.NotNull;

public class QContext {
    @NotNull
    private final Map<String, String> imports;
    @NotNull
    private final String packageId;
    @NotNull
    private final String schema;

    public QContext(@NotNull String packageId, @NotNull String schema, @NotNull List<String> imports) {
        this.packageId = packageId;
        this.schema = schema;
        this.imports = this.calculate(imports);
    }

    @NotNull
    public String extractName(@NotNull String name) {
        return QName.extractName((String)name);
    }

    public boolean hasImportNameConflict(String fqn) {
        String name = this.extractName(fqn);
        String match = this.imports.get(name);
        return !Predefined.isEmpty((String)match) && !QName.extractQualification((String)fqn).equals(match);
    }

    public boolean needsQualification(@NotNull String fqn) {
        String name = this.extractName(fqn);
        String expected = (String)Predefined.notNull((Object)this.imports.get(name), (Object)this.packageId);
        return !QName.extractQualification((String)fqn).equals(expected);
    }

    @NotNull
    public QName resolve(@NotNull String name) {
        return QName.createQName((String)this.extractQualification(name), (String)this.extractName(name));
    }

    @NotNull
    public String getSchema() {
        return this.schema;
    }

    @NotNull
    String extractQualification(String name) {
        if (QName.isQualified((String)name)) {
            return QName.extractQualification((String)name);
        }
        return (String)Predefined.notNull((Object)this.imports.get(name), (Object)this.packageId);
    }

    @NotNull
    QName withPackage(String name) {
        return QName.createQName((String)QName.qualify((String)this.packageId, (String)name));
    }

    private Map<String, String> calculate(@NotNull List<String> statements) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (String statement : statements) {
            result.put(QName.extractName((String)statement), QName.extractQualification((String)statement));
        }
        return result;
    }
}

