/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.mmcompiler.builder;

import java.util.EnumSet;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.core.Option;
import mulesoft.common.core.QName;
import mulesoft.field.TypeField;
import mulesoft.metadata.common.ModelBuilder;
import mulesoft.metadata.entity.StructBuilder;
import mulesoft.metadata.entity.StructType;
import mulesoft.metadata.entity.TypeDefBuilder;
import mulesoft.metadata.entity.TypeFieldBuilder;
import mulesoft.metadata.exception.BuilderError;
import mulesoft.metadata.exception.BuilderException;
import mulesoft.metadata.exception.inheritance.ExtendsFromFinalException;
import mulesoft.metadata.exception.inheritance.FieldClashesWithUnrelatedTypeException;
import mulesoft.metadata.exception.inheritance.InterfaceExtendsOnlyException;
import mulesoft.metadata.exception.inheritance.MultipleInheritanceException;
import mulesoft.mmcompiler.ast.MMToken;
import mulesoft.mmcompiler.ast.MetaModelAST;
import mulesoft.mmcompiler.builder.BuilderFromAST;
import mulesoft.mmcompiler.builder.CompositeMaker;
import mulesoft.mmcompiler.builder.QContext;
import mulesoft.type.Modifier;
import mulesoft.type.Type;

class TypeMaker
extends CompositeMaker<StructType, TypeField, TypeFieldBuilder> {
    TypeMaker(MetaModelAST node, BuilderFromAST builderFromAST, String sourceName, QContext context) {
        super(node, builderFromAST, sourceName, context);
    }

    @Override
    protected ModelBuilder<?, ?> createBuilder(QName fqn, String label, EnumSet<Modifier> modifiers) {
        ImmutableList nodes = Colls.toList((Iterable)((Object)this.rootNode));
        MetaModelAST lastNode = (MetaModelAST)nodes.get(nodes.size() - 1);
        StructBuilder builder = lastNode.getType() == MMToken.FIELD ? this.makeTypeDef(fqn, modifiers, lastNode) : this.makeStructBuilder(fqn, label, modifiers, (ImmutableList<MetaModelAST>)nodes);
        this.checkBuilder((ModelBuilder<?, ?>)builder);
        return builder;
    }

    void addArg(StructBuilder builder, MetaModelAST field, String name) {
        try {
            builder.addArgument((TypeFieldBuilder)this.buildField(name, field));
        }
        catch (BuilderException e) {
            this.error(field, (BuilderError)e);
        }
    }

    @Override
    TypeFieldBuilder createField(String nm, Type type) {
        return new TypeFieldBuilder(nm, type);
    }

    private void addSuperType(StructBuilder builder, MetaModelAST node, Option<StructType> superType) {
        try {
            builder.withSuperType((StructType)superType.get());
        }
        catch (ExtendsFromFinalException | FieldClashesWithUnrelatedTypeException | InterfaceExtendsOnlyException | MultipleInheritanceException e) {
            this.error(node, (BuilderError)e);
        }
    }

    private StructBuilder makeStructBuilder(QName fqn, String label, EnumSet<Modifier> modifiers, ImmutableList<MetaModelAST> nodes) {
        StructBuilder builder = (StructBuilder)((StructBuilder)StructBuilder.struct((String)this.sourceName, (String)fqn.getQualification(), (String)fqn.getName()).label(label)).withModifiers(modifiers);
        block5: for (MetaModelAST node : nodes) {
            switch ((MMToken)node.getType()) {
                case LIST: {
                    for (MetaModelAST field : node.children(MMToken.FIELD)) {
                        this.addField(builder, field, fqn.getName());
                    }
                    continue block5;
                }
                case ARG_LIST: {
                    for (MetaModelAST field : node.children(MMToken.FIELD)) {
                        this.addArg(builder, field, fqn.getName());
                    }
                    continue block5;
                }
                case EXTENDS: {
                    for (MetaModelAST field : node.children(MMToken.STRUCT_REF)) {
                        Option<StructType> superType = this.getMetaModelReference(StructType.class, field);
                        if (!superType.isPresent()) continue;
                        this.addSuperType(builder, node, superType);
                    }
                    continue block5;
                }
            }
        }
        return builder;
    }

    private ModelBuilder<?, ?> makeTypeDef(QName fqn, EnumSet<Modifier> modifiers, MetaModelAST node) {
        TypeFieldBuilder field = (TypeFieldBuilder)this.buildField(fqn.getName(), node);
        return ((TypeDefBuilder)TypeDefBuilder.typeDef((String)this.sourceName, (String)fqn.getQualification(), (String)fqn.getName(), (Type)field.getType()).withModifiers(modifiers)).withOptions(field.getOptions());
    }
}

