/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.mmcompiler.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Option;
import mulesoft.common.core.QName;
import mulesoft.common.core.Strings;
import mulesoft.common.core.Tuple;
import mulesoft.field.ModelField;
import mulesoft.lexer.TokenType;
import mulesoft.metadata.common.ModelBuilder;
import mulesoft.metadata.entity.AttributeBuilder;
import mulesoft.metadata.entity.View;
import mulesoft.metadata.entity.ViewAttribute;
import mulesoft.metadata.entity.ViewAttributeBuilder;
import mulesoft.metadata.entity.ViewBuilder;
import mulesoft.metadata.exception.BuilderError;
import mulesoft.metadata.exception.BuilderErrors;
import mulesoft.metadata.exception.BuilderException;
import mulesoft.mmcompiler.ast.MMToken;
import mulesoft.mmcompiler.ast.MetaModelAST;
import mulesoft.mmcompiler.builder.ASTFieldReference;
import mulesoft.mmcompiler.builder.ASTUnresolvedTypeReference;
import mulesoft.mmcompiler.builder.BuilderFromAST;
import mulesoft.mmcompiler.builder.CompositeMaker;
import mulesoft.mmcompiler.builder.QContext;
import mulesoft.parser.ASTNode;
import mulesoft.type.MetaModel;
import mulesoft.type.Modifier;
import mulesoft.type.Type;
import org.jetbrains.annotations.Nullable;

class ViewMaker
extends CompositeMaker<View, ViewAttribute, AttributeBuilder> {
    private boolean asView;

    ViewMaker(MetaModelAST entityNode, BuilderFromAST builderFromAST, String sourceName, QContext context) {
        super(entityNode, builderFromAST, sourceName, context);
    }

    @Override
    protected AttributeBuilder buildField(String viewName, MetaModelAST fieldNode) {
        if (this.asView || fieldNode.children().exists(n -> n.hasType(MMToken.OPTION))) {
            return (AttributeBuilder)super.buildField(viewName, fieldNode);
        }
        ASTNode.Utils.assertType((ASTNode)fieldNode, (TokenType)MMToken.FIELD);
        Tuple<MetaModelAST, String> labeledId = this.retrieveLabeledId(fieldNode);
        String attributeName = this.retrieveFieldRef(fieldNode);
        String name = ((MetaModelAST)labeledId.first()).getText();
        if (attributeName == null) {
            this.error(fieldNode, BuilderErrors.unspecifiedType((String)name));
            attributeName = "";
        }
        ViewAttributeBuilder builder = new ViewAttributeBuilder(name, (ModelField)new ASTFieldReference(attributeName, this, fieldNode));
        builder.description((String)labeledId.second());
        return builder;
    }

    protected ViewBuilder createBuilder(QName fqn, String label, EnumSet<Modifier> modifiers) {
        ViewBuilder builder = (ViewBuilder)((ViewBuilder)new ViewBuilder(this.sourceName, fqn.getQualification(), fqn.getName(), this.context.getSchema()).label(label)).withModifiers(modifiers);
        Iterator iterator = this.rootNode.iterator();
        block16: while (iterator.hasNext()) {
            MetaModelAST node = (MetaModelAST)iterator.next();
            switch ((MMToken)node.getType()) {
                case DESCRIBED_BY: {
                    builder.describedBy(this.retrieveFieldIds(node).values());
                    break;
                }
                case IMAGE: {
                    MetaModelAST image = (MetaModelAST)((MetaModelAST)node.getChild(0)).getChild(0);
                    builder.image((ModelField)new ASTFieldReference(image.getText(), this, image));
                    break;
                }
                case AS: {
                    builder.as(Strings.decode((String)((MetaModelAST)node.children(MMToken.STRING_LITERAL).getFirst().get()).getText()));
                    this.asView = true;
                    break;
                }
                case INDEX: {
                    Tuple<String, Collection<ModelField>> index = this.getIndex(node);
                    try {
                        builder.withIndex((String)index.first(), (Collection)index.second());
                    }
                    catch (BuilderException e) {
                        this.error(node, (BuilderError)e);
                    }
                    break;
                }
                case PRIMARY_KEY: {
                    builder.primaryKey(this.retrieveFieldIds(node).values());
                    break;
                }
                case OF: {
                    builder.withEntities(this.retrieveMetaModels(node));
                    break;
                }
                case SEARCHABLE: {
                    this.addSearchable(builder, node);
                    break;
                }
                case UPDATABLE: {
                    builder.updatable();
                    break;
                }
                case REMOTABLE: {
                    builder.remotable();
                    break;
                }
                case OPTIMISTIC: {
                    builder.optimistic();
                    break;
                }
                case BATCH_SIZE: {
                    builder.batchSize(Integer.parseInt(((MetaModelAST)node.getChild(0)).getText()));
                    break;
                }
                case LIST: {
                    for (MetaModelAST field : node.children(MMToken.FIELD)) {
                        this.addField(builder, field, fqn.getName());
                    }
                    continue block16;
                }
            }
        }
        this.checkBuilder((ModelBuilder<?, ?>)builder);
        return builder;
    }

    @Override
    AttributeBuilder createField(String nm, Type type) {
        return new AttributeBuilder(nm, type);
    }

    @Nullable
    private String retrieveFieldRef(MetaModelAST field) {
        Seq children = field.children(MMToken.FIELD_REF);
        return children.size() == 1 ? this.retrieveId((MetaModelAST)children.getFirst().get()) : null;
    }

    private List<MetaModel> retrieveMetaModels(MetaModelAST node) {
        ArrayList<MetaModel> result = new ArrayList<MetaModel>();
        for (MetaModelAST typeNode : node.children(MMToken.DATAOBJECT_REF)) {
            String name = BuilderFromAST.retrieveReferenceQualifiedId(typeNode);
            String fqn = QName.qualify((String)this.context.extractQualification(name), (String)this.context.extractName(name));
            Option o = this.repository.getModel(QName.createQName((String)fqn));
            if (o.isPresent()) {
                result.add((MetaModel)o.get());
                continue;
            }
            result.add((MetaModel)new ASTUnresolvedTypeReference(this, this.sourceName, this.context, fqn, typeNode));
        }
        return result;
    }
}

