/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.mmcompiler.parser;

import mulesoft.lexer.TokenType;
import mulesoft.mmcompiler.ast.MMToken;
import mulesoft.mmcompiler.parser.DatabaseObjectParser;
import mulesoft.mmcompiler.parser.EnumParser;
import mulesoft.mmcompiler.parser.MetaModelParser;
import mulesoft.parser.Parser;
import mulesoft.type.MetaModelKind;
import org.jetbrains.annotations.NotNull;

class EntityParser
extends DatabaseObjectParser {
    private EntityParser(@NotNull MetaModelParser parent) {
        super(parent);
    }

    @Override
    public void parse() {
        this.parseLabeledId(false);
        this.parseEntityOptions(false);
        this.parseList(MMToken.LIST, MMToken.LEFT_BRACE, null, MMToken.RIGHT_BRACE, new EntityFieldParser());
        this.endTree(MMToken.ENTITY);
    }

    private void parseEntityOptions(boolean embedded) {
        block14: while (this.notCurrent(MMToken.LEFT_BRACE)) {
            this.loopCheck();
            MMToken token = (MMToken)this.getAnyOf(new MMToken[]{MMToken.PRIMARY_KEY, MMToken.DESCRIBED_BY, MMToken.IMAGE, MMToken.SEARCHABLE, MMToken.UNIQUE, MMToken.INDEX, MMToken.DEPRECABLE, MMToken.AUDITABLE, MMToken.REMOTABLE, MMToken.OPTIMISTIC, MMToken.CACHE, MMToken.TABLE});
            switch (token) {
                case PRIMARY_KEY: {
                    if (embedded) {
                        this.unexpectedError();
                    }
                    this.parseOptionWithFields(MMToken.PRIMARY_KEY, new MMToken[0]);
                    continue block14;
                }
                case DESCRIBED_BY: {
                    this.parseOptionWithFields(MMToken.DESCRIBED_BY, new MMToken[0]);
                    continue block14;
                }
                case IMAGE: {
                    this.parseOptionWithField(MMToken.IMAGE, new MMToken[0]);
                    continue block14;
                }
                case SEARCHABLE: {
                    this.parseSearchable();
                    continue block14;
                }
                case UNIQUE: {
                    this.parseIndex(MMToken.UNIQUE);
                    continue block14;
                }
                case INDEX: {
                    this.parseIndex(MMToken.INDEX);
                    continue block14;
                }
                case DEPRECABLE: {
                    this.parseOptionWithoutFields(MMToken.DEPRECABLE);
                    continue block14;
                }
                case AUDITABLE: {
                    this.parseOptionWithoutFields(MMToken.AUDITABLE);
                    continue block14;
                }
                case REMOTABLE: {
                    this.parseOptionWithoutFields(MMToken.REMOTABLE);
                    continue block14;
                }
                case OPTIMISTIC: {
                    this.parseOptionWithoutFields(MMToken.OPTIMISTIC);
                    continue block14;
                }
                case CACHE: {
                    this.parseCache();
                    continue block14;
                }
                case TABLE: {
                    this.parseTableName();
                    continue block14;
                }
            }
            this.unexpectedAndAdvanceTo(new MMToken[]{MMToken.LEFT_BRACE});
        }
    }

    static void register() {
        EntityParser.registerDefinitionParser(MMToken.ENTITY, EntityParser::new);
    }

    private class EntityFieldParser
    implements Parser {
        private EntityFieldParser() {
        }

        public void parse() {
            EntityParser.this.beginTree();
            EntityParser.this.parseLabeledId(false);
            if (EntityParser.this.currentOrError(MMToken.COLON)) {
                this.parseFieldDefinition();
            } else {
                EntityParser.this.advanceTo(new MMToken[]{MMToken.SEMICOLON, MMToken.RIGHT_BRACE});
                EntityParser.this.discard((TokenType)MMToken.SEMICOLON);
            }
            EntityParser.this.endTree(MMToken.FIELD);
        }

        private void parseEmbeddedEntity() {
            EntityParser.this.beginTree();
            if (EntityParser.this.current((TokenType)MMToken.DOCUMENTATION)) {
                EntityParser.this.beginTree();
                EntityParser.this.consume();
                EntityParser.this.endTree(MMToken.DOCUMENTATION);
                if (!EntityParser.this.currentByText(MMToken.ENTITY)) {
                    EntityParser.this.unexpectedAndAdvanceTo(new MMToken[]{MMToken.COMMA, MMToken.SEMICOLON, MMToken.RIGHT_BRACE});
                }
            }
            EntityParser.this.discard();
            EntityParser.this.beginTree();
            EntityParser.this.matchOrError(MMToken.IDENTIFIER);
            EntityParser.this.match(MMToken.ASTERISK);
            EntityParser.this.match(MMToken.STRING_LITERAL);
            EntityParser.this.endTree(MMToken.LABELED_ID);
            EntityParser.this.parseEntityOptions(true);
            EntityParser.this.parseList(MMToken.LIST, MMToken.LEFT_BRACE, null, MMToken.RIGHT_BRACE, new EntityFieldParser());
            EntityParser.this.endTree(MMToken.ENTITY);
        }

        private void parseEmbeddedEnum() {
            EntityParser.this.beginTree();
            EntityParser.this.discard();
            this.parseEnum();
        }

        private void parseEnum() {
            new EnumParser(EntityParser.this).parse();
        }

        private void parseFieldDefinition() {
            EntityParser.this.discard(MMToken.COLON);
            if (EntityParser.this.current(MMToken.ENUM)) {
                this.parseEmbeddedEnum();
            } else if (EntityParser.this.current(MMToken.DOCUMENTATION) || EntityParser.this.current(MMToken.IDENTIFIER)) {
                if (EntityParser.this.current(MMToken.DOCUMENTATION) || EntityParser.this.currentByText(MMToken.ENTITY)) {
                    this.parseEmbeddedEntity();
                } else {
                    EntityParser.this.parseType(true, true, MMToken.TYPE_REF);
                }
            } else {
                EntityParser.this.unexpectedAndAdvanceTo(new MMToken[]{MMToken.COMMA, MMToken.SEMICOLON, MMToken.RIGHT_BRACE});
            }
            EntityParser.this.parseFieldOptions(MetaModelKind.ENTITY, false);
            EntityParser.this.discardOrError(MMToken.SEMICOLON);
            EntityParser.this.parseFieldDocumentation();
        }
    }
}

