/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.mmcompiler.parser;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import mulesoft.code.Binder;
import mulesoft.code.Evaluator;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Option;
import mulesoft.common.core.Strings;
import mulesoft.common.core.Suppliers;
import mulesoft.expr.AssignmentExpression;
import mulesoft.expr.BinaryExpression;
import mulesoft.expr.ConversionOp;
import mulesoft.expr.Expression;
import mulesoft.expr.ExpressionAST;
import mulesoft.expr.ExpressionFactory;
import mulesoft.expr.ForbiddenExpression;
import mulesoft.expr.FunctionCallNode;
import mulesoft.expr.IfExpression;
import mulesoft.expr.ListExpression;
import mulesoft.expr.ReadOnlyExpression;
import mulesoft.expr.Ref;
import mulesoft.expr.RefTypeSolver;
import mulesoft.expr.UnaryExpression;
import mulesoft.expr.UpdateExpression;
import mulesoft.expr.exception.IllegalOperationException;
import mulesoft.field.TypeField;
import mulesoft.lexer.CharSequenceStream;
import mulesoft.lexer.CharStream;
import mulesoft.lexer.Lexer;
import mulesoft.metadata.entity.DbObject;
import mulesoft.metadata.entity.SearchField;
import mulesoft.metadata.exception.BuilderError;
import mulesoft.metadata.exception.BuilderErrors;
import mulesoft.mmcompiler.ast.MMToken;
import mulesoft.mmcompiler.ast.MetaModelAST;
import mulesoft.mmcompiler.builder.BuilderFromAST;
import mulesoft.mmcompiler.parser.MetaModelCompiler;
import mulesoft.type.EnumType;
import mulesoft.type.Kind;
import mulesoft.type.Type;
import mulesoft.type.Typed;
import mulesoft.type.Types;
import mulesoft.type.UnresolvedTypeReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionCompiler
extends MetaModelCompiler {
    public ExpressionCompiler(@NotNull String expression) {
        super((Lexer<MMToken>)MMToken.lexer().resetStream((CharStream)new CharSequenceStream("", (CharSequence)expression)), "");
    }

    @NotNull
    public Expression buildExpression(@NotNull Type resultType) {
        return ExpressionCompiler.buildExpression(this.getAST(), resultType).createExpression();
    }

    @Override
    @NotNull
    public MetaModelAST getAST() {
        return (MetaModelAST)super.getAST().getChild(0);
    }

    @Override
    protected void parse() {
        this.parser.parseExpression();
    }

    public static ExpressionAST buildExpression(@NotNull MetaModelAST ast, @NotNull Type resultType) {
        IdentityHashMap<ExpressionAST, MetaModelAST> map = new IdentityHashMap<ExpressionAST, MetaModelAST>();
        return new RootExpressionAst(ExpressionCompiler.buildExpression(ast, ast, map), resultType, ast, map);
    }

    public static ExpressionAST buildExpression(@NotNull MetaModelAST ast, @NotNull Type resultType, @Nullable Type innerExprType) {
        IdentityHashMap<ExpressionAST, MetaModelAST> map = new IdentityHashMap<ExpressionAST, MetaModelAST>();
        return new RootExpressionAst(ExpressionCompiler.buildExpression(ast, ast, map, innerExprType), resultType, ast, map);
    }

    public static <T extends Binder & RefTypeSolver> Object evaluate(String expression, T environment) {
        Evaluator evaluator = new Evaluator();
        ExpressionCompiler compiler = new ExpressionCompiler(expression);
        return compiler.buildExpression((Type)Types.anyType()).compileBindAndEvaluate((RefTypeSolver)environment, environment, evaluator);
    }

    private static ExpressionAST bld(MetaModelAST ast, int n, Map<ExpressionAST, MetaModelAST> map) {
        return ExpressionCompiler.buildExpression((MetaModelAST)ast.getChild(n), ast, map);
    }

    @NotNull
    private static ExpressionAST buildAssignmentExpression(MetaModelAST ast, Map<ExpressionAST, MetaModelAST> map) {
        ExpressionAST ref = ExpressionCompiler.buildExpression((MetaModelAST)ast.getChild(0), ast, map);
        ExpressionAST value = ExpressionCompiler.buildExpression((MetaModelAST)((MetaModelAST)ast.getChild(1)).getChild(0), (MetaModelAST)ast.getChild(1), map);
        Option when = ((MetaModelAST)ast.getChild(2)).isEmpty() ? Option.empty() : Option.some((Object)ExpressionCompiler.buildExpression((MetaModelAST)ast.getChild(2), ast, map));
        boolean mustOrMustNot = ((MetaModelAST)ast.getChild(1)).getType() == MMToken.EQ;
        return new AssignmentExpression(ref, value, when, mustOrMustNot);
    }

    private static ExpressionAST buildExpression(MetaModelAST ast, MetaModelAST parentAst, Map<ExpressionAST, MetaModelAST> map) {
        return ExpressionCompiler.buildExpression(ast, parentAst, map, null);
    }

    private static ExpressionAST buildExpression(MetaModelAST ast, MetaModelAST parentAst, Map<ExpressionAST, MetaModelAST> map, @Nullable Type innerExprType) {
        Object result;
        MMToken type = (MMToken)ast.getType();
        if (type.isLiteral()) {
            result = ExpressionCompiler.buildLiteral(ast);
        } else if (type == MMToken.INTERPOLATION) {
            result = ExpressionCompiler.buildLiteral((MetaModelAST)ast.getChild(0));
        } else if (type == MMToken.FIELD_REF) {
            result = new RefAst(ast, BuilderFromAST.retrieveReferenceQualifiedId(ast));
        } else if (type == MMToken.FILTER_REF) {
            result = new FilterRef(ast, BuilderFromAST.retrieveReferenceQualifiedId(ast));
        } else if (type == MMToken.FORBIDDEN) {
            result = new ForbiddenExpression(((MetaModelAST)((MetaModelAST)ast.getChild(0)).getChild(0)).getText());
        } else if (type == MMToken.IS_UPDATE) {
            result = new UpdateExpression();
        } else if (type == MMToken.IS_READ_ONLY) {
            result = new ReadOnlyExpression();
        } else if (type == MMToken.INVOKE) {
            result = ExpressionCompiler.buildFunctionCall(ast, map);
        } else if (type == MMToken.IF) {
            result = new IfExpression(ExpressionCompiler.bld(ast, 0, map), ExpressionCompiler.bld(ast, 1, map), ExpressionCompiler.bld(ast, 2, map));
        } else if (type == MMToken.ASSIGNMENT_FIELD) {
            result = ExpressionCompiler.buildAssignmentExpression(ast, map);
        } else if (type == MMToken.ASSIGNMENT_LIST || type == MMToken.INNER_ASSIGNMENT_LIST) {
            ListExpression.AssignmentListExpression expr = new ListExpression.AssignmentListExpression(null, innerExprType, type != MMToken.ASSIGNMENT_LIST);
            for (MetaModelAST node : ast.children()) {
                expr.add(ExpressionCompiler.buildExpression(node, ast, map, innerExprType));
            }
            result = expr;
        } else if (type == MMToken.LIST) {
            ListExpression expr = new ListExpression(innerExprType);
            for (MetaModelAST node : ast.children()) {
                expr.add(ExpressionCompiler.buildExpression(node, ast, map, innerExprType));
            }
            result = expr;
        } else {
            BinaryExpression.Operator b = type.binaryOperator();
            if (b != null) {
                result = new BinaryExpression(b, ExpressionCompiler.bld(ast, 0, map), ExpressionCompiler.bld(ast, 1, map));
            } else {
                UnaryExpression.Operator u = type.unaryOperator();
                if (u != null) {
                    result = new UnaryExpression(u, ExpressionCompiler.bld(ast, 0, map));
                } else {
                    throw new InvalidExpression(parentAst);
                }
            }
        }
        map.put((ExpressionAST)result, ast);
        return result;
    }

    private static ExpressionAST buildFunctionCall(MetaModelAST ast, Map<ExpressionAST, MetaModelAST> map) {
        UnaryExpression result;
        String name = null;
        ArrayList<ExpressionAST> args = new ArrayList<ExpressionAST>();
        for (MetaModelAST c : ast.children()) {
            if (name == null) {
                name = c.getText();
                continue;
            }
            args.add(ExpressionCompiler.buildExpression(c, c, map));
        }
        if (name == null) {
            throw new IllegalStateException("Name is undefined");
        }
        if (args.size() == 1 && (result = UnaryExpression.fromId((String)name, (ExpressionAST)((ExpressionAST)args.get(0)))) != null) {
            return result;
        }
        return new FunctionCallNode(name, args);
    }

    private static ExpressionAST buildLiteral(MetaModelAST ast) {
        String text = ast.getText();
        MMToken type = (MMToken)ast.getType();
        switch (type) {
            case TRUE: {
                return ExpressionFactory.bool((Boolean)true);
            }
            case FALSE: {
                return ExpressionFactory.bool((Boolean)false);
            }
            case NULL: {
                return ExpressionFactory.nullValue();
            }
            case STRING_LITERAL: {
                return ExpressionFactory.str((String)Strings.decode((String)text));
            }
            case HEX_INT: {
                return ExpressionFactory.integer((int)Integer.parseInt(text, 16));
            }
            case DEC_INT: {
                return ExpressionFactory.integer((int)Integer.parseInt(text));
            }
            case FIXED_POINT_DECIMAL: {
                return ExpressionFactory.decimal((BigDecimal)new BigDecimal(text));
            }
            case DOUBLE_LITERAL: {
                return ExpressionFactory.real((Double)Double.parseDouble(text));
            }
        }
        throw new IllegalArgumentException("Illegal Literal Token: " + text + " " + (Object)((Object)type));
    }

    public static class RootExpressionAst
    extends ConversionOp {
        private final IdentityHashMap<ExpressionAST, MetaModelAST> map;

        private RootExpressionAst(@NotNull ExpressionAST e, @NotNull Type expectedType, @NotNull MetaModelAST ast, IdentityHashMap<ExpressionAST, MetaModelAST> map) {
            super(e, (Supplier)(expectedType instanceof UnresolvedTypeReference ? (UnresolvedTypeReference)expectedType : Suppliers.fromObject((Object)expectedType)));
            this.map = map;
            map.put((ExpressionAST)this, ast);
        }

        @NotNull
        public ExpressionAST solveType(@NotNull RefTypeSolver refResolver) {
            try {
                return super.solveType(refResolver);
            }
            catch (IllegalOperationException e) {
                throw new InvalidExpression(this.map.get(e.getExpr()), e);
            }
        }

        public String toString() {
            return this.getOperand().toString();
        }

        protected boolean conversionNeeded(Type opType) {
            return this.getTargetKind() != Kind.ANY && (opType.getKind() == Kind.DECIMAL || super.conversionNeeded(opType));
        }
    }

    public static class RefAst
    extends Ref {
        private final MetaModelAST ast;

        private RefAst(@NotNull MetaModelAST ast, String ref) {
            super(ref);
            this.ast = ast;
        }

        @NotNull
        protected Type doSolveType(@NotNull RefTypeSolver refResolver) {
            Type type = super.doSolveType(refResolver);
            if (type.isUndefined()) {
                throw new InvalidExpression(this.ast, (BuilderError)BuilderErrors.unresolvedReference((String)this.getName()));
            }
            return type;
        }
    }

    public static class InvalidExpression
    extends RuntimeException {
        private final BuilderError builderError;
        private final MetaModelAST expressionAst;
        private static final long serialVersionUID = 3345553268264615254L;

        public InvalidExpression(@NotNull MetaModelAST expressionAst) {
            this(expressionAst, (BuilderError)BuilderErrors.invalidExpression((String)"Invalid expression", (String)expressionAst.getText()));
        }

        private InvalidExpression(@NotNull MetaModelAST expressionAst, @NotNull IllegalOperationException cause) {
            this(expressionAst, (BuilderError)BuilderErrors.invalidExpression((String)cause.getErrorMessage(), (String)expressionAst.getText()));
        }

        private InvalidExpression(@NotNull MetaModelAST expressionAst, @NotNull BuilderError builderError) {
            this.expressionAst = expressionAst;
            this.builderError = builderError;
        }

        public BuilderError getBuilderError() {
            return this.builderError;
        }

        public MetaModelAST getExpressionAst() {
            return this.expressionAst;
        }
    }

    public static class FilterRef
    extends Ref {
        private final MetaModelAST ast;

        FilterRef(@NotNull MetaModelAST ast, String ref) {
            super(ref);
            this.ast = ast;
        }

        @NotNull
        public ExpressionAST solveType(@NotNull RefTypeSolver refResolver) {
            Type type = this.getTargetType();
            if (type == null) {
                return super.solveType(refResolver);
            }
            if (type.isDatabaseObject()) {
                ImmutableList fields = ((DbObject)type).searchByFields();
                Option fieldOpt = fields.getFirst(f -> f.getId().equals(this.getName()));
                if (fieldOpt.isEmpty() && !"_deprecated".equals(this.getName())) {
                    throw new InvalidExpression(this.ast, (BuilderError)BuilderErrors.unresolvedSearchableField((String)this.getName()));
                }
                return super.solveType((referenceName, isColumn) -> (Type)fields.getFirst(field -> field.getId().equals(this.getName())).map(SearchField::getField).map(Typed::getType).orElse((Object)Types.nullType()));
            }
            if (type.isEnum()) {
                EnumType enumType = (EnumType)type;
                Seq children = enumType.getChildren();
                Option fieldOpt = children.filter(c -> c.getName().equals(this.getName())).getFirst();
                if (fieldOpt.isEmpty()) {
                    throw new InvalidExpression(this.ast, (BuilderError)BuilderErrors.unresolvedField((String)this.getName(), (String)enumType.getFullName()));
                }
                return super.solveType((referenceName, isColumn) -> ((TypeField)fieldOpt.get()).getType());
            }
            return super.solveType(refResolver);
        }

        public boolean isFilterRef() {
            return true;
        }
    }
}

