/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.mmcompiler.parser;

import java.util.EnumSet;
import mulesoft.mmcompiler.ast.MMToken;
import mulesoft.mmcompiler.parser.MetaModelParser;

public enum ExpressionType {
    IF{

        @Override
        public ExpressionType inner() {
            return OR;
        }

        @Override
        public boolean handles(MMToken t) {
            return t == MMToken.IF;
        }

        @Override
        public void parseExpression(MetaModelParser p) {
            p.beginTree();
            OR.parseExpression(p);
            if (p.getCurrent() != MMToken.IF) {
                p.dropTree();
            } else {
                p.discard();
                this.parseExpression(p);
                if (p.getCurrent() != MMToken.COLON) {
                    p.dropTree();
                } else {
                    p.discard();
                    this.parseExpression(p);
                    p.endTree(MMToken.IF);
                }
            }
        }
    }
    ,
    OR{

        @Override
        public ExpressionType inner() {
            return AND;
        }

        @Override
        public boolean handles(MMToken t) {
            return t == MMToken.OR;
        }
    }
    ,
    AND{

        @Override
        public ExpressionType inner() {
            return EQUAL;
        }

        @Override
        public boolean handles(MMToken t) {
            return t == MMToken.AND;
        }
    }
    ,
    EQUAL{

        @Override
        public ExpressionType inner() {
            return RELATIONAL;
        }

        @Override
        public boolean handles(MMToken t) {
            return t == MMToken.EQ_EQ || t == MMToken.NE;
        }
    }
    ,
    RELATIONAL{

        @Override
        public ExpressionType inner() {
            return ADDITIVE;
        }

        @Override
        public boolean handles(MMToken t) {
            return EnumSet.of(MMToken.GE, MMToken.GT, MMToken.LE, MMToken.LT).contains((Object)t);
        }
    }
    ,
    ADDITIVE{

        @Override
        public ExpressionType inner() {
            return MULTIPLICATIVE;
        }

        @Override
        public boolean handles(MMToken t) {
            return t == MMToken.PLUS || t == MMToken.MINUS;
        }
    }
    ,
    MULTIPLICATIVE{

        @Override
        public ExpressionType inner() {
            return UNARY;
        }

        @Override
        public boolean handles(MMToken t) {
            return t == MMToken.ASTERISK || t == MMToken.SLASH;
        }
    }
    ,
    UNARY{

        @Override
        public ExpressionType inner() {
            return ELEMENT;
        }

        @Override
        public boolean handles(MMToken t) {
            return t == MMToken.NOT || t == MMToken.PLUS || t == MMToken.MINUS || t == MMToken.FORBIDDEN;
        }

        @Override
        public void parseExpression(MetaModelParser p) {
            MMToken operator = (MMToken)p.getCurrent();
            if (this.handles(operator)) {
                p.beginTree();
                p.discard();
                this.parseExpression(p);
                p.endTree(operator == MMToken.MINUS ? MMToken.UNARY_MINUS : operator);
            } else {
                this.inner().parseExpression(p);
            }
        }
    }
    ,
    ELEMENT{

        @Override
        public ExpressionType inner() {
            return null;
        }

        @Override
        public void parseExpression(MetaModelParser p) {
            p.parseExpressionElement();
        }

        @Override
        public boolean handles(MMToken t) {
            return false;
        }
    };


    public void parseExpression(MetaModelParser p) {
        p.beginTree();
        this.inner().parseExpression(p);
        MMToken operator = (MMToken)p.getCurrent();
        boolean match = this.handles(operator);
        if (!match) {
            p.dropTree();
        } else {
            do {
                p.discard();
                this.inner().parseExpression(p);
                match = this.handles((MMToken)p.getCurrent());
                if (match) {
                    p.endAndPushTree(operator);
                } else {
                    p.endTree(operator);
                }
                operator = (MMToken)p.getCurrent();
            } while (match);
        }
    }

    protected abstract boolean handles(MMToken var1);

    protected abstract ExpressionType inner();
}

