/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.mmcompiler.parser;

import java.util.HashMap;
import java.util.Map;
import mulesoft.common.Predefined;
import mulesoft.common.core.Option;
import mulesoft.expr.ExpressionFactory;
import mulesoft.field.FieldOption;
import mulesoft.lexer.TokenKind;
import mulesoft.lexer.TokenType;
import mulesoft.mmcompiler.ast.MMToken;
import mulesoft.mmcompiler.parser.EntityParser;
import mulesoft.mmcompiler.parser.EnumParser;
import mulesoft.mmcompiler.parser.ExpressionType;
import mulesoft.mmcompiler.parser.InterpolationParser;
import mulesoft.mmcompiler.parser.TypeParser;
import mulesoft.mmcompiler.parser.ViewParser;
import mulesoft.parser.ASTBuilder;
import mulesoft.parser.AbstractParser;
import mulesoft.parser.LoopException;
import mulesoft.parser.Parser;
import mulesoft.parser.ParserCommonMessages;
import mulesoft.parser.ParserErrorListener;
import mulesoft.type.MetaModelKind;
import mulesoft.type.Modifier;
import mulesoft.type.Type;
import mulesoft.type.Types;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaModelParser
extends AbstractParser<MMToken> {
    private static final Map<String, Factory> definitionParsers = new HashMap<String, Factory>();

    MetaModelParser(MetaModelParser parent) {
        this((ASTBuilder<MMToken>)parent.getAstBuilder(), parent.getErrorListener());
    }

    public MetaModelParser(@NotNull ASTBuilder<MMToken> builder, ParserErrorListener listener) {
        super(builder, listener);
    }

    public void parse() {
        try {
            this.parsePackage();
            this.parseImports();
            this.parseDefinitions();
        }
        catch (LoopException l) {
            this.advanceToEof();
            this.dropAllTrees();
            this.error(l.getPosition(), ParserCommonMessages.MSGS.loop());
        }
    }

    public String parseQualifiedId() {
        this.beginTree();
        return this.parseQualifiedId(new StringBuilder()).toString();
    }

    String matchIdOrError() {
        if (!this.currentOrError(MMToken.IDENTIFIER)) {
            return "";
        }
        String result = this.getCurrentText();
        this.consume();
        return result;
    }

    void parseExpression() {
        ExpressionType.IF.parseExpression(this);
    }

    void parseExpressionElement() {
        MMToken current = (MMToken)this.getCurrent();
        switch (current) {
            case IDENTIFIER: {
                if (this.next(MMToken.LEFT_PAREN)) {
                    if (this.currentByText(MMToken.FORBIDDEN)) {
                        this.parseForbidden();
                        break;
                    }
                    if (this.currentByText(MMToken.IS_UPDATE)) {
                        this.parseBooleanFunction(MMToken.IS_UPDATE);
                        break;
                    }
                    if (this.currentByText(MMToken.IS_READ_ONLY)) {
                        this.parseBooleanFunction(MMToken.IS_READ_ONLY);
                        break;
                    }
                    this.parseInvoke();
                    break;
                }
                this.parseQualifiedId(MMToken.FIELD_REF, false);
                break;
            }
            case LEFT_PAREN: {
                this.discard();
                this.parseExpression();
                this.discardOrError(MMToken.RIGHT_PAREN);
                break;
            }
            case STRING_LITERAL: {
                if (ExpressionFactory.isInterpolation((String)this.getCurrentText())) {
                    this.beginTree();
                    this.matchOrError(MMToken.STRING_LITERAL);
                    this.endTree(MMToken.INTERPOLATION);
                    break;
                }
                this.consume();
                break;
            }
            default: {
                if (current.isLiteral()) {
                    this.consume();
                    break;
                }
                this.unexpectedError();
            }
        }
    }

    void parseFieldDocumentation() {
        if (!this.current(MMToken.DOCUMENTATION)) {
            return;
        }
        this.beginTree();
        this.consume();
        this.endTree(MMToken.DOCUMENTATION);
    }

    void parseFieldOptions(@NotNull MetaModelKind mmKind, boolean commaConsumed) {
        if (!commaConsumed && !this.discard(MMToken.COMMA)) {
            return;
        }
        do {
            if (this.parseFieldOption(mmKind)) continue;
            this.unexpectedAndAdvanceTo(new MMToken[]{MMToken.COMMA, MMToken.SEMICOLON, MMToken.RIGHT_BRACE});
        } while (this.discard(MMToken.COMMA));
    }

    void parseFieldOptionValue(@NotNull FieldOption option) {
        switch (option.getType()) {
            case CHECK_T: {
                this.parseOptionalList(MMToken.LIST, MMToken.LEFT_PAREN, MMToken.COMMA, MMToken.RIGHT_PAREN, this::parseCheckElement);
                break;
            }
            case LABELED_IDS_T: {
                this.parseOptionalList(MMToken.LIST, MMToken.LEFT_PAREN, MMToken.COMMA, MMToken.RIGHT_PAREN, () -> this.parseLabeledId(false));
                break;
            }
            case STRING_T: {
                this.matchOrError(MMToken.STRING_LITERAL);
                break;
            }
            case IDENTIFIERS_T: {
                this.parseIdentifierList();
                break;
            }
            case IDENTIFIER_T: {
                this.matchOrError(MMToken.IDENTIFIER);
                break;
            }
            case METHOD_T: {
                if (option == FieldOption.ON_SUGGEST) {
                    this.parseInvoke(true);
                    break;
                }
                this.beginTree();
                this.matchOrError(MMToken.IDENTIFIER);
                if (this.currentByText(MMToken.WHEN)) {
                    this.discard();
                    this.parseExpression();
                }
                this.endTree(MMToken.METHOD_REF);
                break;
            }
            case METAMODEL_REFERENCE_T: {
                this.parseQualifiedId();
                break;
            }
            case BOOLEAN_T: {
                break;
            }
            case STRING_EXPR_T: 
            case UNSIGNED_EXPR_T: 
            case VALUE_EXPR_T: 
            case VALUE_ARRAY_EXPR_T: 
            case GENERIC_EXPR_T: 
            case STRING_ARRAY_EXPR_T: {
                this.parseExpression();
                break;
            }
            case STRING_EXPRS_T: {
                if (this.parseList(MMToken.LIST, MMToken.LEFT_PAREN, MMToken.COMMA, MMToken.RIGHT_PAREN, this::parseExpression)) break;
                this.parseExpression();
                break;
            }
            case ASSIGNMENT_EXPRS: {
                if (!this.currentOrError(MMToken.LEFT_PAREN)) break;
                this.parseList(MMToken.ASSIGNMENT_LIST, MMToken.LEFT_PAREN, MMToken.COMMA, MMToken.RIGHT_PAREN, this::parseAssignmentExpression);
                break;
            }
            case BOOLEAN_EXPR_T: {
                if (!this.currentByText(MMToken.WHEN)) break;
                this.discard();
                this.parseExpression();
                break;
            }
            case UNSIGNED_T: {
                this.parseInteger();
                break;
            }
            case ENUM_T: {
                this.matchOrError(MMToken.IDENTIFIER);
                break;
            }
            case TYPE_T: {
                this.parseType(true);
                break;
            }
            case FIELDS_T: {
                this.parseList(MMToken.LIST, MMToken.LEFT_BRACE, null, MMToken.RIGHT_BRACE, (Parser)new TypeParser.TypeFieldParser(this));
                break;
            }
            case AGGREGATE_T: 
            case METHOD_REF_T: {
                throw Predefined.unreachable();
            }
        }
    }

    void parseId(MMToken token) {
        this.parseId(token, false);
    }

    void parseId(MMToken token, boolean discardCurrent) {
        this.beginTree();
        if (discardCurrent) {
            this.discard();
        }
        this.matchIdOrError();
        this.endTree(token);
    }

    void parseLabeledId(boolean optionalId) {
        boolean notMatch;
        this.beginTree();
        boolean bl = notMatch = !this.match(MMToken.IDENTIFIER);
        if (notMatch && !optionalId) {
            this.currentOrError(MMToken.IDENTIFIER);
            this.discard();
        }
        this.match(MMToken.STRING_LITERAL);
        this.endTree(MMToken.LABELED_ID);
    }

    boolean parseOptionalInteger() {
        return this.matchAnyOf(new MMToken[]{MMToken.HEX_INT, MMToken.DEC_INT});
    }

    void parseOptionWithField(MMToken key, MMToken ... extraTokens) {
        this.beginTree();
        this.discard();
        this.parseRef(MMToken.FIELD_REF, extraTokens);
        this.endTree(key);
    }

    void parseOptionWithFields(MMToken key, MMToken ... extraTokens) {
        this.parseOptionWithFieldsExpecting(key, MMToken.FIELD_REF, extraTokens);
    }

    void parseOptionWithFieldsExpecting(MMToken key, MMToken refToken, MMToken ... extraTokens) {
        this.beginTree();
        this.discard();
        this.parseRef(refToken, extraTokens);
        while (this.discard(MMToken.COMMA)) {
            this.parseRef(refToken, extraTokens);
        }
        this.endTree(key);
    }

    void parseOptionWithoutFields(MMToken key) {
        this.beginTree();
        this.discard();
        this.endTree(key);
    }

    void parseOptionWithRefsExpecting(MMToken key, MMToken refToken) {
        this.beginTree();
        this.discard();
        this.parseQualifiedId(refToken, false);
        while (this.discard(MMToken.COMMA)) {
            this.parseQualifiedId(refToken, false);
        }
        this.endTree(key);
    }

    void parseQualifiedId(MMToken token, boolean discardCurrent) {
        this.beginTree();
        if (discardCurrent) {
            this.discard();
        }
        this.parseQualifiedId();
        this.endTree(token);
    }

    void parseRef(MMToken key) {
        if (this.currentOrError(MMToken.IDENTIFIER)) {
            this.beginTree();
            this.consume();
            this.endTree(key);
        }
    }

    void parseRef(MMToken key, MMToken ... extraTokens) {
        TokenType[] tokens;
        if (extraTokens.length > 0) {
            tokens = new MMToken[extraTokens.length + 1];
            tokens[0] = MMToken.IDENTIFIER;
            System.arraycopy(extraTokens, 0, tokens, 1, extraTokens.length);
        } else {
            tokens = new MMToken[]{MMToken.IDENTIFIER};
        }
        if (this.currentAnyOfOrError(tokens)) {
            this.beginTree();
            this.consume();
            this.endTree(key);
        }
    }

    void parseSearchable() {
        this.beginTree();
        this.discard();
        if (this.currentByText(MMToken.BY)) {
            this.discard();
            if (this.currentByText(MMToken.DATABASE)) {
                this.discard();
                this.beginTree();
                this.endTree(MMToken.DATABASE);
            }
            if (this.currentOrError(MMToken.LEFT_BRACE)) {
                this.parseList(MMToken.LIST, MMToken.LEFT_BRACE, MMToken.SEMICOLON, MMToken.RIGHT_BRACE, new SearchableFieldParser());
            }
        }
        this.endTree(MMToken.SEARCHABLE);
    }

    void parseType(boolean allowReferenceCardinality) {
        this.parseType(allowReferenceCardinality, false, MMToken.TYPE_REF);
    }

    void parseType(boolean allowReferenceCardinality, boolean allowTypeCardinality, MMToken refType) {
        this.beginTree();
        String typeName = this.parseQualifiedId();
        Type t = this.getTypeFromString(typeName);
        boolean reference = t.isNull();
        if (reference) {
            this.dupBeginTree();
            this.endTree(refType);
        }
        this.parseParameters(t.getParametersCount());
        if (reference) {
            if (allowReferenceCardinality) {
                this.match(MMToken.ASTERISK);
            }
            if (this.currentByText(MMToken.USING)) {
                this.discard();
                this.matchOrError(MMToken.IDENTIFIER);
            }
        } else if (allowTypeCardinality) {
            this.match(MMToken.ASTERISK);
        }
        this.endTree(MMToken.TYPE_NODE);
    }

    @NotNull
    Type getTypeFromString(String typeName) {
        return Types.fromString((String)typeName);
    }

    private void checkType(MMToken ... tokens) {
        this.beginTree();
        this.getAnyOf(tokens);
        for (MMToken token : tokens) {
            if (!this.currentByText(token)) continue;
            this.consume();
            break;
        }
        this.endTree(MMToken.OPTION);
    }

    @Nullable
    private Parser createDefinitionParser() {
        Factory factory = null;
        boolean inTree = false;
        boolean doc = false;
        while (!this.eof()) {
            if (!inTree && !doc && this.current(MMToken.DOCUMENTATION)) {
                this.beginTree();
                this.beginTree();
                this.consume();
                this.endTree(MMToken.DOCUMENTATION);
                doc = true;
                if (!this.notValidAfterDocumentation()) continue;
                this.error(this.getAstBuilder().getCurrentPosition(), ParserCommonMessages.MSGS.unexpectedAfterDoc(this.getCurrentText()));
                continue;
            }
            String txt = this.textFromIdOrKeyword();
            if (txt.isEmpty()) break;
            Modifier mod = Modifier.fromId((String)txt);
            if (mod == null) {
                factory = definitionParsers.get(txt);
                break;
            }
            if (!inTree) {
                if (!doc) {
                    this.beginTree();
                }
                this.beginTree();
                inTree = true;
            }
            this.consume();
        }
        if (factory == null) {
            if (inTree) {
                this.dropTree();
                this.dropTree();
            } else if (doc) {
                this.dropTree();
            }
            return null;
        }
        if (inTree) {
            this.endTree(MMToken.MODIFIERS);
        } else if (!doc) {
            this.beginTree();
        }
        return factory.create(this);
    }

    private boolean notValidAfterDocumentation() {
        String txt = this.textFromIdOrKeyword();
        return txt.isEmpty() || Modifier.fromId((String)txt) == null && definitionParsers.get(txt) == null;
    }

    private void parseAssignmentExpression() {
        this.beginTree();
        this.parseRef(MMToken.FILTER_REF);
        if (this.currentAnyOfOrError(new MMToken[]{MMToken.EQ, MMToken.NE})) {
            MMToken sign = (MMToken)this.getCurrent();
            this.discard();
            this.beginTree();
            if (!this.parseList(MMToken.INNER_ASSIGNMENT_LIST, MMToken.LEFT_PAREN, MMToken.COMMA, MMToken.RIGHT_PAREN, this::parseExpression)) {
                this.parseExpression();
            }
            this.endTree(sign);
            if (this.currentByText(MMToken.WHEN)) {
                this.discard();
                this.parseExpression();
            }
        }
        this.endTree(MMToken.ASSIGNMENT_FIELD);
    }

    private void parseBooleanFunction(@NotNull MMToken func) {
        this.beginTree();
        this.discardOrError(MMToken.IDENTIFIER);
        this.discardOrError(MMToken.LEFT_PAREN);
        this.discardOrError(MMToken.RIGHT_PAREN);
        this.endTree(func);
    }

    private void parseCheckElement() {
        this.beginTree();
        this.parseExpression();
        this.discardOrError(MMToken.COLON);
        this.checkType(MMToken.POPUP, MMToken.INLINE);
        this.checkType(MMToken.ERROR, MMToken.WARNING, MMToken.INFO);
        this.matchOrError(MMToken.STRING_LITERAL);
        this.endTree(MMToken.CHECK);
    }

    private boolean parseDefinition() {
        Parser parser = this.createDefinitionParser();
        if (parser == null) {
            return false;
        }
        this.beginTree();
        this.discard();
        this.endTree(MMToken.MODEL);
        parser.parse();
        return true;
    }

    private void parseDefinitions() {
        boolean recovered = true;
        while (!this.eof()) {
            this.loopCheck();
            if (this.parseDefinition()) {
                recovered = true;
                continue;
            }
            if (recovered) {
                this.unexpectedError();
                recovered = false;
            }
            this.discard();
        }
    }

    private boolean parseFieldOption(MetaModelKind mmKind) {
        FieldOption option = FieldOption.fromId((String)this.textFromIdOrKeyword(), (MetaModelKind)mmKind);
        if (option == null) {
            return false;
        }
        this.beginTree();
        this.consume();
        Option<MMToken> wrapper = MMToken.nodeFor(option);
        wrapper.ifPresent(w -> this.beginTree());
        this.parseFieldOptionValue(option);
        wrapper.ifPresent(arg_0 -> ((MetaModelParser)this).endTree(arg_0));
        this.endTree(MMToken.OPTION);
        return true;
    }

    private void parseForbidden() {
        this.beginTree();
        this.discardOrError(MMToken.IDENTIFIER);
        this.discardOrError(MMToken.LEFT_PAREN);
        this.parseRef(MMToken.PERMISSION_REF);
        this.discardOrError(MMToken.RIGHT_PAREN);
        this.endTree(MMToken.FORBIDDEN);
    }

    private void parseIdentifierList() {
        if (!this.match(MMToken.IDENTIFIER)) {
            this.parseList(MMToken.LIST, MMToken.LEFT_PAREN, MMToken.COMMA, MMToken.RIGHT_PAREN, this::matchIdOrError);
        }
    }

    private void parseImports() {
        while (this.current(MMToken.IMPORT)) {
            this.beginTree();
            this.discard(MMToken.IMPORT);
            String fqn = this.parseQualifiedId();
            if (fqn.isEmpty()) {
                this.advanceTo(new MMToken[]{MMToken.SEMICOLON});
            }
            this.discardOrError(MMToken.SEMICOLON);
            this.endTree(MMToken.IMPORT);
        }
    }

    private void parseInteger() {
        this.parseOptionalInteger();
    }

    private void parseInvoke() {
        this.parseInvoke(false);
    }

    private void parseInvoke(boolean optionalArguments) {
        this.beginTree();
        this.matchOrError(MMToken.IDENTIFIER);
        if (this.current(MMToken.LEFT_PAREN) || !optionalArguments) {
            this.discardOrError(MMToken.LEFT_PAREN);
            if (!this.current(MMToken.RIGHT_PAREN)) {
                this.parseExpression();
                while (this.discard(MMToken.COMMA)) {
                    this.parseExpression();
                }
            }
            this.discardOrError(MMToken.RIGHT_PAREN);
        }
        this.endTree(MMToken.INVOKE);
    }

    private void parsePackage() {
        if (this.currentOrError(MMToken.PACKAGE)) {
            this.beginTree();
            this.discard(MMToken.PACKAGE);
            this.parseQualifiedId();
            this.endTree(MMToken.PACKAGE);
            if (this.currentByText(MMToken.SCHEMA)) {
                this.beginTree();
                this.discard();
                this.matchIdOrError();
                this.endTree(MMToken.SCHEMA);
            }
            this.discardOrError(MMToken.SEMICOLON);
        }
    }

    private void parseParameters(int parametersCount) {
        if (this.current(MMToken.LEFT_PAREN)) {
            boolean hasParameters;
            boolean bl = hasParameters = parametersCount > 0;
            if (hasParameters) {
                this.beginTree();
            } else {
                this.unexpectedError();
            }
            this.discard();
            this.parseInteger();
            int n = 0;
            while (this.current(MMToken.COMMA)) {
                if (++n == parametersCount) {
                    this.unexpectedError();
                }
                this.discard(MMToken.COMMA);
                this.parseInteger();
            }
            this.discardOrError(MMToken.RIGHT_PAREN);
            if (hasParameters) {
                this.endTree(MMToken.LIST);
            }
        }
    }

    private StringBuilder parseQualifiedId(@NotNull StringBuilder text) {
        String identifier = this.matchIdOrError();
        text.append(identifier);
        if (this.current(MMToken.DOT)) {
            this.dupBeginTree();
        }
        this.endTree(MMToken.REFERENCE);
        if (identifier.isEmpty()) {
            return new StringBuilder();
        }
        if (this.discard(MMToken.DOT)) {
            text.append('.');
            this.parseQualifiedId(text);
        }
        return text;
    }

    private String textFromIdOrKeyword() {
        TokenKind kind = ((MMToken)this.getCurrent()).getKind();
        return kind.isIdentifier() || kind.isKeyword() ? this.getCurrentText() : "";
    }

    static void registerDefinitionParser(MMToken tokenId, Factory factory) {
        definitionParsers.put(tokenId.getText(), factory);
    }

    static {
        EntityParser.register();
        InterpolationParser.register();
        EnumParser.register();
        TypeParser.register();
        ViewParser.register();
    }

    private class SearchableFieldParser
    implements Parser {
        private SearchableFieldParser() {
        }

        public void parse() {
            MetaModelParser.this.beginTree();
            if (MetaModelParser.this.ahead(MMToken.COLON, 1)) {
                MetaModelParser.this.match(MMToken.IDENTIFIER);
                MetaModelParser.this.discardOrError(MMToken.COLON);
            }
            if (MetaModelParser.this.currentOrError(MMToken.IDENTIFIER)) {
                MetaModelParser.this.parseRef(MMToken.FIELD_REF);
                if (MetaModelParser.this.discard(MMToken.COMMA)) {
                    MetaModelParser.this.parseFieldOptions(MetaModelKind.SEARCHABLE, true);
                }
            }
            MetaModelParser.this.endTree(MMToken.FIELD);
        }
    }

    static interface Factory {
        public Parser create(MetaModelParser var1);
    }
}

