/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.mmcompiler.parser;

import mulesoft.mmcompiler.ast.MMToken;
import mulesoft.mmcompiler.parser.MetaModelParser;
import org.jetbrains.annotations.NotNull;

class PathParser
extends MetaModelParser {
    private PathParser(@NotNull MetaModelParser parent) {
        super(parent);
    }

    @Override
    public void parse() {
        if (this.discard(MMToken.COLON)) {
            do {
                this.discardOrError(MMToken.SLASH);
                if (this.current(MMToken.EMPTY_TOKEN)) continue;
                this.parsePart();
            } while (this.current(MMToken.SLASH));
        } else {
            this.advanceTo(new MMToken[]{MMToken.SEMICOLON});
        }
        this.discard(MMToken.SEMICOLON);
        this.endTree(MMToken.PATH);
    }

    private void consumePart() {
        this.beginTree();
        this.consume();
        this.endTree(MMToken.PART);
    }

    private void parsePart() {
        while (!this.currentAnyOf(new MMToken[]{MMToken.SLASH, MMToken.SEMICOLON}) && !this.eof()) {
            this.loopCheck();
            if (this.current(MMToken.IDENTIFIER) || ((MMToken)this.getCurrent()).isLiteral() || ((MMToken)this.getCurrent()).isKeyword()) {
                this.consumePart();
                continue;
            }
            if (this.discard(MMToken.DOLLAR)) {
                this.parseId(MMToken.PARAMETER);
                if (this.discard(MMToken.COLON)) {
                    this.parseType(false);
                    continue;
                }
                this.discard(MMToken.ASTERISK);
                continue;
            }
            if (this.currentAnyOf(new MMToken[]{MMToken.MINUS, MMToken.DOT})) {
                this.discard();
                continue;
            }
            this.unexpectedAndAdvanceTo(new MMToken[]{MMToken.SLASH, MMToken.SEMICOLON});
        }
    }

    static void register() {
        PathParser.registerDefinitionParser(MMToken.PATH, PathParser::new);
    }
}

