/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.mmcompiler.parser;

import mulesoft.mmcompiler.ast.MMToken;
import mulesoft.mmcompiler.parser.MetaModelParser;

class TaskParser
extends MetaModelParser {
    private TaskParser(MetaModelParser parent) {
        super(parent);
    }

    @Override
    public void parse() {
        this.parseLabeledId(false);
        this.parseTaskOptions();
        this.discardOrError(MMToken.SEMICOLON);
        this.endTree(MMToken.TASK);
    }

    private void parseExclusionGroup() {
        this.beginTree();
        this.discard();
        this.matchOrError(MMToken.STRING_LITERAL);
        this.endTree(MMToken.EXCLUSION_GROUP);
    }

    private void parsePatternOption() {
        this.beginTree();
        this.discard();
        this.matchOrError(MMToken.STRING_LITERAL);
        this.endTree(MMToken.PATTERN);
    }

    private void parseSchedule() {
        this.beginTree();
        this.discard();
        if (this.currentByText(MMToken.AFTER)) {
            this.parseQualifiedId(MMToken.TASK_REF, true);
        } else {
            this.matchOrError(MMToken.STRING_LITERAL);
        }
        this.endTree(MMToken.SCHEDULE);
    }

    private void parseTaskOptions() {
        block8: while (this.notCurrentAnyOf(new MMToken[]{MMToken.SEMICOLON})) {
            this.loopCheck();
            MMToken token = (MMToken)this.getAnyOf(new MMToken[]{MMToken.SCHEDULE, MMToken.CLUSTER, MMToken.NODE, MMToken.TRANSACTION, MMToken.PATTERN, MMToken.EXCLUSION_GROUP});
            switch (token) {
                case SCHEDULE: {
                    this.parseSchedule();
                    continue block8;
                }
                case CLUSTER: {
                    this.beginTree();
                    this.discard();
                    this.endTree(MMToken.CLUSTER);
                    continue block8;
                }
                case NODE: {
                    this.beginTree();
                    this.discard();
                    this.endTree(MMToken.NODE);
                    continue block8;
                }
                case TRANSACTION: {
                    this.parseTransactionOption();
                    continue block8;
                }
                case PATTERN: {
                    this.parsePatternOption();
                    continue block8;
                }
                case EXCLUSION_GROUP: {
                    this.parseExclusionGroup();
                    continue block8;
                }
            }
            this.unexpectedAndAdvanceTo(new MMToken[]{MMToken.SEMICOLON});
        }
    }

    private void parseTransactionOption() {
        this.beginTree();
        this.discard();
        MMToken token = (MMToken)this.getAnyOf(new MMToken[]{MMToken.NONE, MMToken.ALL, MMToken.EACH, MMToken.ISOLATED});
        switch (token) {
            case NONE: {
                this.beginTree();
                this.discard();
                this.endTree(MMToken.NONE);
                break;
            }
            case ALL: {
                this.beginTree();
                this.discard();
                this.endTree(MMToken.ALL);
                break;
            }
            case ISOLATED: {
                this.beginTree();
                this.discard();
                this.endTree(MMToken.ISOLATED);
                break;
            }
            case EACH: {
                this.beginTree();
                this.discard();
                this.matchOrError(MMToken.DEC_INT);
                this.endTree(MMToken.EACH);
                break;
            }
            default: {
                this.unexpectedAndAdvanceTo(new MMToken[]{MMToken.SEMICOLON});
            }
        }
        this.endTree(MMToken.TRANSACTION);
    }

    static void register() {
        TaskParser.registerDefinitionParser(MMToken.TASK, TaskParser::new);
    }
}

