/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.mmcompiler.parser;

import mulesoft.mmcompiler.ast.MMToken;
import mulesoft.mmcompiler.parser.MetaModelParser;
import mulesoft.parser.Parser;
import mulesoft.type.MetaModelKind;
import org.jetbrains.annotations.NotNull;

class TypeParser
extends MetaModelParser {
    private TypeParser(@NotNull MetaModelParser parent) {
        super(parent);
    }

    @Override
    public void parse() {
        this.parseLabeledId(false);
        if (this.discard(MMToken.EQ)) {
            this.beginTree();
            if (this.current(MMToken.IDENTIFIER)) {
                this.parseType(true);
            } else {
                this.unexpectedAndAdvanceTo(new MMToken[]{MMToken.COMMA, MMToken.SEMICOLON});
            }
            this.parseFieldOptions(MetaModelKind.TYPE, false);
            this.discardOrError(MMToken.SEMICOLON);
            this.endTree(MMToken.FIELD);
        } else {
            this.parseList(MMToken.ARG_LIST, MMToken.LEFT_PAREN, null, MMToken.RIGHT_PAREN, (Parser)new TypeArgParser(this));
            this.parseStructTypeOptions();
            this.parseList(MMToken.LIST, MMToken.LEFT_BRACE, null, MMToken.RIGHT_BRACE, (Parser)new TypeFieldParser(this, true, true, MMToken.STRUCT_REF));
        }
        this.endTree(MMToken.TYPE);
    }

    private void parseStructTypeOptions() {
        block3: while (this.currentByTextAnyOf(new MMToken[]{MMToken.EXTENDS})) {
            this.loopCheck();
            MMToken token = (MMToken)this.getAnyOf(new MMToken[]{MMToken.EXTENDS});
            switch (token) {
                case EXTENDS: {
                    this.discard(MMToken.EXTENDS);
                    this.parseValues(MMToken.EXTENDS, MMToken.COMMA, new StructRefParser());
                    continue block3;
                }
            }
            this.unexpectedAndAdvanceTo(new MMToken[]{MMToken.LEFT_BRACE});
        }
    }

    static void register() {
        TypeParser.registerDefinitionParser(MMToken.TYPE, TypeParser::new);
    }

    static class TypeFieldParser
    extends MetaModelParser {
        private final boolean allowBasicTypeCardinality;
        private final boolean allowReferenceCardinality;
        private final MMToken refType;

        public TypeFieldParser(MetaModelParser typeParser) {
            this(typeParser, true, true, MMToken.TYPE_REF);
        }

        public TypeFieldParser(MetaModelParser typeParser, boolean allowReferenceCardinality, boolean allowBasicTypeCardinality, MMToken refType) {
            super(typeParser);
            this.allowReferenceCardinality = allowReferenceCardinality;
            this.allowBasicTypeCardinality = allowBasicTypeCardinality;
            this.refType = refType;
        }

        @Override
        public void parse() {
            this.beginTree();
            this.parseLabeledId(false);
            if (this.currentOrError(MMToken.COLON)) {
                this.parseFieldDefinition();
            } else {
                this.advanceTo(new MMToken[]{MMToken.SEMICOLON, MMToken.RIGHT_BRACE});
                this.discard(MMToken.SEMICOLON);
            }
            this.endTree(MMToken.FIELD);
        }

        private void parseFieldDefinition() {
            this.discard(MMToken.COLON);
            if (this.current(MMToken.IDENTIFIER)) {
                this.parseType(this.allowReferenceCardinality, this.allowBasicTypeCardinality, this.refType);
            } else {
                this.unexpectedAndAdvanceTo(new MMToken[]{MMToken.COMMA, MMToken.SEMICOLON, MMToken.RIGHT_BRACE});
            }
            this.parseFieldOptions(MetaModelKind.TYPE, false);
            this.discardOrError(MMToken.SEMICOLON);
            this.parseFieldDocumentation();
        }
    }

    static class TypeArgParser
    extends MetaModelParser {
        public TypeArgParser(MetaModelParser typeParser) {
            super(typeParser);
        }

        @Override
        public void parse() {
            this.beginTree();
            this.parseLabeledId(false);
            if (this.currentOrError(MMToken.COLON)) {
                this.parseFieldDefinition();
            } else {
                this.advanceTo(new MMToken[]{MMToken.COLON, MMToken.RIGHT_PAREN});
            }
            this.endTree(MMToken.FIELD);
        }

        private void parseFieldDefinition() {
            this.discard(MMToken.COLON);
            if (this.current(MMToken.IDENTIFIER)) {
                this.parseType(true, true, MMToken.STRUCT_REF);
            } else {
                this.unexpectedAndAdvanceTo(new MMToken[]{MMToken.COMMA, MMToken.RIGHT_BRACE});
            }
            this.parseFieldOptions(MetaModelKind.TYPE, false);
            boolean notSemicolon = !this.discard(MMToken.SEMICOLON);
            this.parseFieldDocumentation();
            if (notSemicolon) {
                this.currentOrError(MMToken.RIGHT_PAREN);
            }
        }
    }

    private class StructRefParser
    implements Parser {
        private StructRefParser() {
        }

        public void parse() {
            TypeParser.this.parseQualifiedId(MMToken.STRUCT_REF, false);
        }
    }
}

